/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import junit.framework.Test;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.SwitchTool;
import org.polarsys.capella.test.diagram.tools.ju.model.SwitchCategory;
import org.polarsys.capella.test.framework.context.SessionContext;

public class SwitchCategoryWithDelegation
extends SwitchCategory {
    public void test() throws Exception {
        Session session = this.getSessionForTestModel(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        DiagramContext diagramContext = (DiagramContext)new OpenDiagramStep(context, "[PAB] Category Delegation Test").run();
        DDiagramContents diagramContents = new DDiagramContents(diagramContext.getDiagram());
        CapellaModel model = this.getTestModel(this.getRequiredTestModel());
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        EObject physicalCategory = IdManager.getInstance().getEObject("fb6a157c-10e5-406d-a6c1-89fb9eb0a829", (IScope)scope);
        EObject pp1OfPC11 = IdManager.getInstance().getEObject("d99cb30c-a986-4a57-8863-609c30d2625a", (IScope)scope);
        EObject pp1OfPC21 = IdManager.getInstance().getEObject("25387032-30fc-476a-81ab-64f0776c7953", (IScope)scope);
        EObject componentCategory = IdManager.getInstance().getEObject("ca3ab8f3-e4fe-4917-832a-92f35eb01142", (IScope)scope);
        EObject cp1OfPC5 = IdManager.getInstance().getEObject("91be7757-fb01-4fbc-9c15-7abe6f739176", (IScope)scope);
        EObject cp1OfPC6 = IdManager.getInstance().getEObject("2fe87f6a-3ab1-4cd0-8054-5c8aa6603489", (IScope)scope);
        EObject cp1OfPC7 = IdManager.getInstance().getEObject("f89d1adf-8ef2-4028-b288-f895862ded85", (IScope)scope);
        EObject cp1OfPC8 = IdManager.getInstance().getEObject("3701c0bb-00a2-4d9f-8ebe-c10614aa84b9", (IScope)scope);
        new SwitchTool(diagramContext, "switch.physical.links.categories").insert(new String[]{"fb6a157c-10e5-406d-a6c1-89fb9eb0a829"});
        new SwitchTool(diagramContext, "switch.component.exchanges.categories").insert(new String[]{"ca3ab8f3-e4fe-4917-832a-92f35eb01142"});
        diagramContext.refreshDiagram();
        DiagramElementMapping physicalCategoryMapping = diagramContents.getMapping(MappingConstantsHelper.getMappingABPhysicalCategory((DDiagram)diagramContext.getDiagram()));
        boolean pl1Switched = false;
        boolean pl1DelegationToPC1Switched = false;
        boolean pl1DelegationToPC2Switched = false;
        boolean pl1DelegationToPC7Switched = false;
        boolean pl1DelegationToPC8Switched = false;
        for (DDiagramElement diagramElement : diagramContents.getDiagramElements(physicalCategoryMapping)) {
            if (diagramElement.getTarget() != physicalCategory) continue;
            DEdge physicalCategoryEdge = (DEdge)diagramElement;
            DSemanticDecorator sourceNode = (DSemanticDecorator)physicalCategoryEdge.getSourceNode();
            DSemanticDecorator targetNode = (DSemanticDecorator)physicalCategoryEdge.getTargetNode();
            if (sourceNode.getTarget() == physicalCategory && targetNode.getTarget() == physicalCategory) {
                pl1Switched = true;
                continue;
            }
            if (sourceNode.getTarget() == physicalCategory && targetNode.getTarget() == pp1OfPC11) {
                pl1DelegationToPC1Switched = true;
                continue;
            }
            if (sourceNode.getTarget() == physicalCategory && targetNode.getTarget() == pp1OfPC21) {
                pl1DelegationToPC2Switched = true;
                continue;
            }
            if (sourceNode.getTarget() == physicalCategory && targetNode.getTarget() == cp1OfPC7) {
                pl1DelegationToPC7Switched = true;
                continue;
            }
            if (sourceNode.getTarget() != physicalCategory || targetNode.getTarget() != cp1OfPC8) continue;
            pl1DelegationToPC8Switched = true;
        }
        SwitchCategoryWithDelegation.assertTrue((String)"There isn't a Physical Category between PC 1 and PC 2", (boolean)pl1Switched);
        SwitchCategoryWithDelegation.assertTrue((String)"There isn't a Physical Category between PC 1 and PC 11", (boolean)pl1DelegationToPC1Switched);
        SwitchCategoryWithDelegation.assertTrue((String)"There isn't a Physical Category between PC 2 and PC 21", (boolean)pl1DelegationToPC2Switched);
        SwitchCategoryWithDelegation.assertTrue((String)"There isn't a Physical Category between PC 1 and PC 7", (boolean)pl1DelegationToPC7Switched);
        SwitchCategoryWithDelegation.assertTrue((String)"There isn't a Physical Category between PC 2 and PC 8", (boolean)pl1DelegationToPC8Switched);
        DiagramElementMapping componentCategoryMapping = diagramContents.getMapping(MappingConstantsHelper.getMappingABComponentCategory((DDiagram)diagramContext.getDiagram()));
        boolean ce1Switched = false;
        boolean ce1DelegationToPC5Switched = false;
        boolean ce1DelegationToPC6Switched = false;
        for (DDiagramElement diagramElement : diagramContents.getDiagramElements(componentCategoryMapping)) {
            if (diagramElement.getTarget() != componentCategory) continue;
            DEdge physicalCategoryEdge = (DEdge)diagramElement;
            DSemanticDecorator sourceNode = (DSemanticDecorator)physicalCategoryEdge.getSourceNode();
            DSemanticDecorator targetNode = (DSemanticDecorator)physicalCategoryEdge.getTargetNode();
            if (sourceNode.getTarget() == componentCategory && targetNode.getTarget() == componentCategory) {
                ce1Switched = true;
                continue;
            }
            if (sourceNode.getTarget() == componentCategory && targetNode.getTarget() == cp1OfPC5) {
                ce1DelegationToPC5Switched = true;
                continue;
            }
            if (sourceNode.getTarget() != componentCategory || targetNode.getTarget() != cp1OfPC6) continue;
            ce1DelegationToPC6Switched = true;
        }
        SwitchCategoryWithDelegation.assertTrue((String)"There isn't a Component Category between PC 3 and PC 4", (boolean)ce1Switched);
        SwitchCategoryWithDelegation.assertTrue((String)"There isn't a Component Category between PC 3 and PC 5", (boolean)ce1DelegationToPC5Switched);
        SwitchCategoryWithDelegation.assertTrue((String)"There isn't a Component Category between PC 4 and PC 6", (boolean)ce1DelegationToPC6Switched);
        diagramContext.hasntViews(new String[]{"ed5d6ad1-1ca2-4082-84a3-42a58d25156d", "236b95d8-0b6a-4134-8067-db2bb476138f", "1c0d63ff-9d4b-4659-93fc-4dd6502a8c05", "c03e7c1a-27e7-40f7-ab2b-a8ccb8c253b7", "17289a07-9b9f-4da9-bca3-bb75e32e6326", "2fd38174-5936-46be-b996-713d913f71fa"});
    }

    public static Test suite() {
        return new SwitchCategoryWithDelegation();
    }
}

