/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xdfb;

import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.FunctionAllocator;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateContainerTools;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBInsertRemoveTools;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.XDFBToolsTestingModel;
import org.polarsys.capella.test.framework.context.SessionContext;

public class XDFBShowHideFunctions
extends XDFBToolsTestingModel {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXDFBDiagram(context, "Operational RA Data Flow Diagram", BlockArchitectureExt.Type.OA);
        this.testOnXDFBDiagram(context, "System RF Data Flow Diagram", BlockArchitectureExt.Type.SA);
        this.testOnXDFBDiagram(context, "Logical RF Data Flow Diagram", BlockArchitectureExt.Type.LA);
        this.testOnXDFBDiagram(context, "Physical RF Data Flow Diagram", BlockArchitectureExt.Type.PA);
    }

    protected void testOnXDFBDiagram(final SessionContext context, String diagramName, BlockArchitectureExt.Type diagramType) {
        XDFBDiagram xdfb = XDFBDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)diagramType);
        String diagramId = xdfb.getDiagramId();
        String function1Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        String function2Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        this.hideAndShow(xdfb, function1Id, function2Id);
        final String actorFunction1Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        final String actorFunction2Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        context.getExecutionManager().execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                Component actor = (Component)context.getSemanticElement("41347b92-d3e6-4b6a-b46d-01af1685b84d");
                AbstractFunction actorFunction1 = (AbstractFunction)context.getSemanticElement(actorFunction1Id);
                AbstractFunction actorFunction2 = (AbstractFunction)context.getSemanticElement(actorFunction2Id);
                FunctionAllocator.allocate((AbstractFunction)actorFunction1).on(actor);
                FunctionAllocator.allocate((AbstractFunction)actorFunction2).on(actor);
            }
        });
        this.hideAndShow(xdfb, actorFunction1Id, actorFunction2Id);
    }

    private void hideAndShow(XDFBDiagram xdfb, String ... functions) {
        String diagramId = xdfb.getDiagramId();
        xdfb.hideElements(diagramId, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, functions);
        xdfb.showElements(diagramId, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, new String[]{functions[0]});
        xdfb.showElements(diagramId, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, new String[]{functions[1]});
        xdfb.hideElements(diagramId, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, new String[]{functions[0]});
        xdfb.hideElements(diagramId, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, new String[]{functions[1]});
        xdfb.showElements(diagramId, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, functions);
    }
}

