/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.fragmentation.ju.utils;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.api.query.NotificationQuery;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.junit.Assert;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.mdsofa.common.helper.StringHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.handler.AbortedTransactionException;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.test.fragmentation.ju.utils.FragmentUtils;
import org.polarsys.kitalpha.emde.model.Element;

public class FragmentModificationListener
implements ResourceSetListener {
    private final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private Set<IFile> _filesToMakeWritable = new HashSet<IFile>(0);
    private Set<IFile> _expectedFilesToMakeWritable = new HashSet<IFile>(0);

    public FragmentModificationListener(Set<IFile> expectedSet) {
        this._expectedFilesToMakeWritable = expectedSet;
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event_p) throws RollbackException {
        List notifications = event_p.getNotifications();
        HashSet<IFile> filesToMakeWritable = new HashSet<IFile>(0);
        HashMap<ResourceSetSync, Set<Resource>> additionalResourcesToChangeStatus = new HashMap<ResourceSetSync, Set<Resource>>(0);
        HashMap<Element, Resource> removedElementFromResource = new HashMap<Element, Resource>(0);
        for (Object currentNotification : notifications) {
            Resource resource;
            Notification notification;
            Object notifier;
            if (!(currentNotification instanceof Notification) || !((notifier = (notification = (Notification)currentNotification).getNotifier()) instanceof EObject)) continue;
            if (notifier instanceof Element) {
                this.markDirtyDependentResources(filesToMakeWritable, additionalResourcesToChangeStatus, notification, (Element)notifier, removedElementFromResource);
            }
            if ((resource = ((EObject)notifier).eResource()) == null || new NotificationQuery((Notification)currentNotification).isTransientNotification()) continue;
            IFile file = EcoreUtil2.getFile((Resource)resource);
            this.handleMakeFileWritable(filesToMakeWritable, currentNotification, file);
        }
        this._filesToMakeWritable = filesToMakeWritable;
        if (!filesToMakeWritable.isEmpty()) {
            this.checkFilesWritables();
            this.makeFilesWritable(event_p.getEditingDomain(), filesToMakeWritable);
        }
        for (Map.Entry entry : additionalResourcesToChangeStatus.entrySet()) {
            ResourceSetSync resourceSetSync = (ResourceSetSync)entry.getKey();
            Set dependentResources = (Set)entry.getValue();
            for (Resource resource : dependentResources) {
                resourceSetSync.statusChanged(resource, ResourceSetSync.ResourceStatus.SYNC, ResourceSetSync.ResourceStatus.CHANGED);
            }
        }
        return null;
    }

    protected void markDirtyDependentResources(Set<IFile> filesToMakeWritable_p, Map<ResourceSetSync, Set<Resource>> additionalResourcesToChangeStatus_p, Notification notification_p, Element notifier_p, Map<Element, Resource> removedElementFromResource_p) {
        EReference reference;
        EStructuralFeature feature = (EStructuralFeature)notification_p.getFeature();
        if (feature instanceof EReference && (reference = (EReference)feature).isContainment() && !notification_p.isTouch()) {
            ArrayList<EObject> objectsToUpdate = new ArrayList<EObject>(1);
            switch (notification_p.getEventType()) {
                case 2: 
                case 4: {
                    Object oldValue = notification_p.getOldValue();
                    if (oldValue instanceof Element) {
                        Element removedElement = (Element)oldValue;
                        removedElementFromResource_p.put(removedElement, notifier_p.eResource());
                    }
                    return;
                }
                case 6: {
                    break;
                }
                case 1: 
                case 3: {
                    objectsToUpdate.add((EObject)notification_p.getNewValue());
                    break;
                }
                case 5: {
                    objectsToUpdate.addAll((Collection)notification_p.getNewValue());
                }
            }
            Resource notifierResource = notifier_p.eResource();
            for (EObject objectToUpdate : objectsToUpdate) {
                Resource objectToUpdateResource = removedElementFromResource_p.get(objectToUpdate);
                if (objectToUpdateResource == null || notifierResource.equals(objectToUpdateResource)) continue;
                Collection dependentResources = RepresentationHelper.collectDependentResources((EObject)objectToUpdate);
                for (Resource dependentResource : dependentResources) {
                    IFile file = EcoreUtil2.getFile((Resource)dependentResource);
                    this.handleMakeFileWritable(filesToMakeWritable_p, objectToUpdate, file);
                    ResourceSetSync resourceSetSync = ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)objectToUpdate)));
                    if (!ResourceSetSync.ResourceStatus.SYNC.equals((Object)ResourceSetSync.getStatus((Resource)dependentResource))) continue;
                    Set<Resource> resources = additionalResourcesToChangeStatus_p.get(resourceSetSync);
                    if (resources == null) {
                        resources = new HashSet<Resource>(0);
                        additionalResourcesToChangeStatus_p.put(resourceSetSync, resources);
                    }
                    resources.add(dependentResource);
                }
            }
        }
    }

    public void handleMakeFileWritable(Set<IFile> filesToMakeWritable, Object notificationObject, IFile file) {
        if (file != null && file.isReadOnly()) {
            if (this.__logger.isDebugEnabled() && !filesToMakeWritable.contains(file)) {
                this.__logger.debug((Object)new EmbeddedMessage(StringHelper.formatMessage((String)"Make File ''{0}'' Writable due to notification:{1}", (Object[])new String[]{file.getFullPath().toString(), notificationObject.toString()}), "User Interface"));
            }
            filesToMakeWritable.add(file);
        }
    }

    public void makeFilesWritable(TransactionalEditingDomain editingDomain_p, Collection<IFile> filesToMakeWritable_p) throws AbortedTransactionException {
        try {
            FragmentUtils.setIFileListWrite(filesToMakeWritable_p);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void checkFilesWritables() {
        boolean areReadOnly = false;
        for (IFile file : this._filesToMakeWritable) {
            if (file.isReadOnly()) {
                areReadOnly = true;
                continue;
            }
            areReadOnly = false;
            break;
        }
        if (areReadOnly) {
            Set<IFile> expectedFilesToBeModified = this._expectedFilesToMakeWritable;
            boolean haveSameFiles = this._filesToMakeWritable.equals(expectedFilesToBeModified);
            HashSet<String> fileNameToMakeWritable = new HashSet<String>();
            for (IFile file : this._filesToMakeWritable) {
                fileNameToMakeWritable.add(file.getName());
            }
            Assert.assertTrue((String)MessageFormat.format("The actual and expected sets of files to make writable are different. The actual set is the following {0}. Check the expected set.", fileNameToMakeWritable), (boolean)haveSameFiles);
        }
    }

    public static void checkFilesWritables(Collection<IFile> actual_p, Set<IFile> expected_p) {
        boolean areReadOnly = false;
        for (IFile file : actual_p) {
            if (file.isReadOnly()) {
                areReadOnly = true;
                continue;
            }
            areReadOnly = false;
            break;
        }
        if (areReadOnly) {
            boolean haveSameFiles = true;
            for (IFile currentFile : expected_p) {
                if (actual_p.contains(currentFile)) continue;
                haveSameFiles = false;
                break;
            }
            HashSet<String> fileNameToMakeWritable = new HashSet<String>();
            for (IFile file : actual_p) {
                fileNameToMakeWritable.add(file.getName());
            }
            Assert.assertTrue((String)MessageFormat.format("The actual and expected sets of files to make writable are different. The actual set is the following {0}. Check the expected set.", fileNameToMakeWritable), (haveSameFiles && actual_p.size() == expected_p.size() ? 1 : 0) != 0);
        }
    }

    public void resourceSetChanged(ResourceSetChangeEvent event_p) {
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isPostcommitOnly() {
        return false;
    }
}

