/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.fragmentation.ju.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.junit.Assert;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.mdsofa.common.helper.ProjectHelper;
import org.polarsys.capella.test.fragmentation.ju.messages.FragmentationMessages;
import org.polarsys.capella.test.framework.helpers.GuiActions;

public class FragmentUtils {
    public static void checkEResource(EObject object_p, Resource expectedResource_p) {
        Resource resource = object_p.eResource();
        Assert.assertEquals((String)NLS.bind((String)FragmentationMessages.fragmentUtils_resourceDoesNotMatch, (Object[])new Object[]{EObjectExt.getText((EObject)object_p), resource.getURI().toString(), expectedResource_p.getURI().toString()}), (Object)resource, (Object)expectedResource_p);
    }

    public static List<EObject> getFragmentedRootObjects(Resource resource) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject root = (EObject)resource.getContents().get(0);
        TreeIterator it = root.eAllContents();
        EObject current = null;
        while (it.hasNext()) {
            current = (EObject)it.next();
            if (FragmentUtils.getDirectResource(current) == null) continue;
            result.add(current);
        }
        return result;
    }

    public static int getNumberOfProperEObjects(EObject eObject_p) {
        return FragmentUtils.getProperContents(eObject_p).size();
    }

    public static List<EObject> getProperContents(EObject eObject_p) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator it = EcoreUtil.getAllProperContents((EObject)eObject_p, (boolean)true);
        while (it.hasNext()) {
            result.add((EObject)it.next());
        }
        return result;
    }

    public static Map<EObject, Integer> getProperContentsRefCount(EObject eObject_p) {
        HashMap<EObject, Integer> result = new HashMap<EObject, Integer>();
        ResourceSet resourceSet = eObject_p.eResource().getResourceSet();
        List<EObject> list = FragmentUtils.getProperContents(eObject_p);
        list.add(eObject_p);
        int count = -1;
        for (EObject eObject : list) {
            Set set;
            count = 0;
            HashMap map = new HashMap();
            for (EStructuralFeature.Setting setting : EcoreUtil.UsageCrossReferencer.find((EObject)eObject, (ResourceSet)resourceSet)) {
                if (!map.containsKey(setting.getEObject())) {
                    set = new HashSet();
                    map.put(setting.getEObject(), set);
                }
                ((Set)map.get(setting.getEObject())).add(setting.getEStructuralFeature());
            }
            for (EObject eobj : map.keySet()) {
                set = (Set)map.get(eobj);
                count += set.size();
            }
            result.put(eObject, count);
        }
        return result;
    }

    public static void compareRefCountForTest(EObject root_p, Map<EObject, Integer> old_p, Map<EObject, Integer> new_p, boolean fragment_p) {
        Iterator<Map.Entry<EObject, Integer>> it = old_p.entrySet().iterator();
        Map.Entry<EObject, Integer> entry = null;
        EObject current = null;
        int old = -1;
        int neww = -1;
        while (it.hasNext()) {
            entry = it.next();
            current = entry.getKey();
            old = entry.getValue();
            neww = new_p.get(current);
            if (current == root_p) {
                neww = fragment_p ? (neww -= 1 + (FragmentUtils.getLinkedDRepresentation(current).isEmpty() ? 0 : 1)) : (neww += 1 + (FragmentUtils.getLinkedDRepresentation(current).isEmpty() ? 0 : 1));
            }
            Assert.assertEquals((String)NLS.bind((String)FragmentationMessages.fragmentUtils_numberOfRefDoesNotMatch, (Object)EObjectExt.getText((EObject)current)), (long)old, (long)neww);
        }
    }

    public static List<DRepresentation> getLinkedDRepresentation(EObject eObject_p) {
        Session session = SessionManager.INSTANCE.getSession(eObject_p);
        ArrayList<DRepresentation> result = new ArrayList<DRepresentation>();
        result.addAll(DialectManager.INSTANCE.getRepresentations(eObject_p, session));
        TreeIterator it = EcoreUtil.getAllProperContents((EObject)eObject_p, (boolean)true);
        while (it.hasNext()) {
            EObject root = (EObject)it.next();
            result.addAll(DialectManager.INSTANCE.getRepresentations(root, session));
        }
        return result;
    }

    public static List<DRepresentationDescriptor> getLinkedDRepresentationDescriptor(EObject eObject_p) {
        Session session = SessionManager.INSTANCE.getSession(eObject_p);
        ArrayList<DRepresentationDescriptor> result = new ArrayList<DRepresentationDescriptor>();
        result.addAll(DialectManager.INSTANCE.getRepresentationDescriptors(eObject_p, session));
        TreeIterator it = EcoreUtil.getAllProperContents((EObject)eObject_p, (boolean)true);
        while (it.hasNext()) {
            EObject root = (EObject)it.next();
            result.addAll(DialectManager.INSTANCE.getRepresentationDescriptors(root, session));
        }
        return result;
    }

    public static Resource getDirectResource(EObject eObject_p) {
        return ((InternalEObject)eObject_p).eDirectResource();
    }

    public static Set<Resource> getAirdResourceWithAnalysisOn(EObject eobject_p) {
        Session session = SessionManager.INSTANCE.getSession(eobject_p);
        HashSet<Resource> results = new HashSet<Resource>();
        if (session != null && session instanceof DAnalysisSession) {
            for (Resource resource : session.getAllSessionResources()) {
                for (DAnalysis analysis : FragmentUtils.getAnalyses(resource)) {
                    if (!analysis.getModels().contains((Object)eobject_p)) continue;
                    results.add(resource);
                }
            }
        }
        return results;
    }

    private static Collection<DAnalysis> getAnalyses(Resource airdResource_p) {
        ArrayList<DAnalysis> analyses = new ArrayList<DAnalysis>();
        for (EObject root : airdResource_p.getContents()) {
            if (!(root instanceof DAnalysis)) continue;
            analyses.add((DAnalysis)root);
        }
        return analyses;
    }

    public static void copyFragmentFileWithSpace(IProject project_p, String fileName_p, String plugin_p, String fragmentFolder_p) {
        ProjectHelper.refreshProject((IProject)project_p, (IProgressMonitor)new NullProgressMonitor());
        String fileRelativePath_p = String.valueOf(plugin_p) + fragmentFolder_p + '/' + fileName_p;
        IFolder folder = project_p.getFolder(fragmentFolder_p);
        ProjectHelper.refreshProject((IProject)project_p, (IProgressMonitor)new NullProgressMonitor());
        if (!folder.exists()) {
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception_p) {
                exception_p.printStackTrace();
            }
        }
        ProjectHelper.refreshProject((IProject)project_p, (IProgressMonitor)new NullProgressMonitor());
        FragmentUtils.writeFile(String.valueOf(project_p.getName()) + '/' + fragmentFolder_p + '/' + fileName_p, true, fileRelativePath_p);
        ProjectHelper.refreshProject((IProject)project_p, (IProgressMonitor)new NullProgressMonitor());
        GuiActions.flushASyncGuiThread();
    }

    static void writeFile(String filePath_p, boolean ensureFolders_p, String sourceFile_p) {
        try {
            GuiActions.flushASyncGuiThread();
            URI source = URI.createPlatformPluginURI((String)sourceFile_p, (boolean)false);
            URL url = FileLocator.resolve((URL)new URL(source.toString()));
            URI aTarget = URI.createPlatformResourceURI((String)filePath_p, (boolean)false);
            URL url2 = FileLocator.resolve((URL)new URL(aTarget.toString()));
            File asource = new File(url.getFile());
            File target = new File(url2.getFile());
            if (url.getProtocol().equals("jar")) {
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                InputStream is = jarConnection.getInputStream();
                FileOutputStream fos = new FileOutputStream(target);
                while (is.available() > 0) {
                    fos.write(is.read());
                }
                fos.close();
                is.close();
            } else {
                FragmentUtils.copyFile(asource, target);
            }
            GuiActions.flushASyncGuiThread();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void copyFile(File srcFile, File destFile) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel iChannel = null;
        AbstractInterruptibleChannel oChannel = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            iChannel = fis.getChannel();
            oChannel = fos.getChannel();
            long size = ((FileChannel)iChannel).size();
            long length = 0L;
            long pos = 0L;
            while (pos < size) {
                long rr = size - pos;
                length = Math.min(100000L, rr);
                long res = ((FileChannel)oChannel).transferFrom((ReadableByteChannel)((Object)iChannel), pos, length);
                if (res == 0L) {
                    break;
                }
                pos += res;
            }
        }
        finally {
            iChannel.close();
            oChannel.close();
            fis.close();
            fos.close();
        }
    }

    private static void setIFileAttribute(IFile file_p, boolean bReadOnly) throws CoreException {
        ResourceAttributes resourceAttribute = new ResourceAttributes();
        resourceAttribute.setReadOnly(bReadOnly);
        try {
            file_p.setResourceAttributes(resourceAttribute);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void setIFileReadOnly(IFile file_p) throws CoreException {
        FragmentUtils.setIFileAttribute(file_p, true);
    }

    public static void setIFileListReadOnly(Collection<IFile> fileList_p) throws CoreException {
        for (IFile currentFile : fileList_p) {
            FragmentUtils.setIFileReadOnly(currentFile);
        }
    }

    public static void setIFileWrite(IFile file_p) throws CoreException {
        FragmentUtils.setIFileAttribute(file_p, false);
    }

    public static void setIFileListWrite(Collection<IFile> fileList_p) throws CoreException {
        for (IFile currentFile : fileList_p) {
            FragmentUtils.setIFileWrite(currentFile);
        }
    }
}

