/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.migration.ju.fwk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.lib.IdGenerator;
import org.polarsys.capella.common.utils.ReflectUtil;
import org.polarsys.capella.core.data.migration.MigrationHelpers;
import org.polarsys.capella.core.data.migration.capella.ModelMigrationRunnable;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public abstract class MigrationContributionTest
extends BasicTestCase {
    private static final String PROJECTNAME = "test";

    protected void addContribution(TestMigrationContribution contribution) {
        try {
            ArrayList migrations = (ArrayList)ReflectUtil.getInvisibleFieldValue((Object)MigrationHelpers.getInstance(), (String)"migrations");
            migrations.removeIf(TestMigrationContribution.class::isInstance);
            migrations.add(contribution);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            MigrationContributionTest.assertFalse((String)"Can't register a contribution", (boolean)true);
        }
    }

    private void removeContributions() {
        try {
            ArrayList migrations = (ArrayList)ReflectUtil.getInvisibleFieldValue((Object)MigrationHelpers.getInstance(), (String)"migrations");
            migrations.removeIf(TestMigrationContribution.class::isInstance);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            MigrationContributionTest.assertFalse((String)"Can't cleanup contributions", (boolean)true);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.removeContributions();
    }

    protected IFile getFile(String modelFile) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECTNAME);
        if (!project.exists()) {
            try {
                project.create((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        try {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return project.getFile(modelFile);
    }

    protected void launchMigration(IFile file) {
        ModelMigrationRunnable runnable = new ModelMigrationRunnable(file);
        MigrationContext context = new MigrationContext();
        context.setBackupModel(false);
        context.setSkipConfirmation(true);
        context.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        context.setShell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        runnable.run(context, false);
    }

    protected class Factory {
        HashMap<String, Object> values = new HashMap();
        ResourceSet set;
        XMIResource modelResource;
        ExecutionManager manager = ExecutionManagerRegistry.getInstance().addNewManager();
        EPackage PKG;
        EPackage PKG_EXT;

        Factory(final IFile modelFile) {
            this.set = this.manager.getEditingDomain().getResourceSet();
            this.set.setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryRegistryImpl(){
                private Resource.Factory _factory = new ResourceFactoryImpl(){

                    public Resource createResource(URI uri2) {
                        return new XMIResourceImpl(uri2){

                            protected XMLLoad createXMLLoad() {
                                XMLLoad load = super.createXMLLoad();
                                ((this).this).Factory.this.values.put("XMLLoad", load);
                                return load;
                            }

                            protected XMLHelper createXMLHelper() {
                                XMLHelper helper = super.createXMLHelper();
                                ((this).this).Factory.this.values.put("XMLHelper", helper);
                                return helper;
                            }

                            public String getID(EObject eObject) {
                                return EcoreUtil.getID((EObject)eObject);
                            }
                        };
                    }
                };

                public Resource.Factory delegatedGetFactory(URI uri) {
                    if (!"ecore".equals(uri.fileExtension())) {
                        return this._factory;
                    }
                    return Resource.Factory.Registry.INSTANCE.getFactory(uri);
                }
            });
            this.manager.execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    URI uri = URI.createPlatformPluginURI((String)"org.polarsys.capella.test.migration.ju/model/Migration.ecore", (boolean)false);
                    Resource ecore = Factory.this.manager.getEditingDomain().getResourceSet().getResource(uri, true);
                    Factory.this.PKG = (EPackage)ecore.getContents().get(0);
                    Factory.this.PKG_EXT = (EPackage)Factory.this.PKG.getESubpackages().get(0);
                    Factory.this.set.getPackageRegistry().put((Object)Factory.this.PKG.getNsURI(), (Object)Factory.this.PKG);
                    for (EPackage child : Factory.this.PKG.getESubpackages()) {
                        Factory.this.set.getPackageRegistry().put((Object)child.getNsURI(), (Object)child);
                    }
                    Factory.this.modelResource = (XMIResource)Factory.this.set.createResource(EcoreUtil2.getURI((IFile)modelFile));
                }
            });
        }

        void init(Runnable object) {
            this.execute(res -> object.run((Resource)this.modelResource));
            try {
                this.modelResource.save(null);
            }
            catch (IOException e) {
                e.printStackTrace();
                MigrationContributionTest.assertFalse((String)e.getMessage(), (boolean)true);
            }
        }

        public void test(Runnable object) {
            this.reload();
            object.run((Resource)this.modelResource);
        }

        public void reload() {
            this.execute(res -> {
                res.unload();
                this.set.getResources().remove((Object)res);
                this.modelResource = (XMIResource)this.set.getResource(res.getURI(), true);
            });
        }

        EClass getEClass(String eClass) {
            EClass clazz = (EClass)this.PKG.getEClassifier(eClass);
            Iterator childs = this.PKG.getESubpackages().iterator();
            while (clazz == null && childs.hasNext()) {
                EPackage child = (EPackage)childs.next();
                clazz = (EClass)child.getEClassifier(eClass);
            }
            return clazz;
        }

        EObject create(String eClass, String id) {
            EClass clazz = this.getEClass(eClass);
            EObject result = clazz.getEPackage().getEFactoryInstance().create(clazz);
            this.set(result, "id", id);
            return result;
        }

        EObject create(String eClass) {
            return this.create(eClass, IdGenerator.createId());
        }

        void set(EObject object, String featureName, Object value) {
            EStructuralFeature feature = object.eClass().getEStructuralFeature(featureName);
            if (feature.isMany()) {
                ((EList)object.eGet(feature)).add(value);
            } else {
                object.eSet(feature, value);
            }
        }

        void add(EObject object, String featureName, EObject value) {
            this.set(object, featureName, value);
        }

        void remove(EObject object, String featureName, EObject value) {
            EStructuralFeature feature = object.eClass().getEStructuralFeature(featureName);
            if (feature.isMany()) {
                ((EList)object.eGet(feature)).remove((Object)value);
            } else {
                object.eUnset(feature);
            }
        }

        void execute(final Runnable object) {
            this.manager.execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    object.run((Resource)Factory.this.modelResource);
                }
            });
        }
    }

    @FunctionalInterface
    public static interface Runnable {
        public void run(Resource var1);
    }

    class TestMigrationContribution
    extends AbstractMigrationContribution {
        TestMigrationContribution() {
        }
    }
}

