/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.migration.ju.fwk;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.test.migration.ju.fwk.MigrationContributionTest;

public class NsPrefixTest
extends MigrationContributionTest {
    static final String OWNER = "a";
    static final String ONE = "b";
    static final String EXT = "e";

    public void test() throws Exception {
        this.prefixNotChanged();
        this.prefixChanged();
    }

    private MigrationContributionTest.Factory initModel(IFile file) {
        MigrationContributionTest.Factory f = new MigrationContributionTest.Factory(file);
        f.init(res -> {
            EObject owner = f.create("Owner", OWNER);
            EObject one = f.create("One", ONE);
            EObject extone = f.create("ExtOne", EXT);
            f.set(owner, "ownedOne", one);
            f.set(one, "ownedAbstracts", extone);
            res.getContents().add((Object)owner);
        });
        return f;
    }

    private void changeEPackageNsPrefix(MigrationContributionTest.Factory f) {
        f.execute(res -> factory.PKG_EXT.setNsPrefix("dummy"));
    }

    private void prefixNotChanged() throws Exception {
        IFile file = this.getFile("test4.capella");
        final MigrationContributionTest.Factory f = this.initModel(file);
        this.changeEPackageNsPrefix(f);
        this.addContribution(new MigrationContributionTest.TestMigrationContribution(this){

            public EFactory getEFactory(String prefix, Resource resource, MigrationContext context) {
                if (prefix.equals("extension")) {
                    return f.PKG_EXT.getEFactoryInstance();
                }
                return super.getEFactory(prefix, resource, context);
            }

            public void contributePackageRegistry(EPackage.Registry packageRegistry, MigrationContext context) {
                super.contributePackageRegistry(packageRegistry, context);
                packageRegistry.put((Object)f.PKG.getNsURI(), (Object)f.PKG);
                packageRegistry.put((Object)f.PKG_EXT.getNsURI(), (Object)f.PKG_EXT);
            }
        });
        this.launchMigration(file);
        XMLHelper helper = (XMLHelper)f.values.get("XMLHelper");
        NsPrefixTest.assertTrue((boolean)helper.getPrefixToNamespaceMap().containsKey((Object)"extension"));
        NsPrefixTest.assertTrue((!helper.getPrefixToNamespaceMap().containsKey((Object)f.PKG_EXT.getNsPrefix()) ? 1 : 0) != 0);
    }

    private void prefixChanged() throws Exception {
        IFile file = this.getFile("test3.capella");
        final MigrationContributionTest.Factory f = this.initModel(file);
        this.changeEPackageNsPrefix(f);
        this.addContribution(new MigrationContributionTest.TestMigrationContribution(this){

            public String getNSPrefix(String prefix, MigrationContext context) {
                if ("xmlns:extension".equals(prefix)) {
                    return "xmlns:" + f.PKG_EXT.getNsPrefix();
                }
                return super.getNSPrefix(prefix, context);
            }

            public EFactory getEFactory(String prefix, Resource resource, MigrationContext context) {
                if (prefix.equals("extension")) {
                    return f.PKG_EXT.getEFactoryInstance();
                }
                return super.getEFactory(prefix, resource, context);
            }

            public void contributePackageRegistry(EPackage.Registry packageRegistry, MigrationContext context) {
                super.contributePackageRegistry(packageRegistry, context);
                packageRegistry.put((Object)f.PKG.getNsURI(), (Object)f.PKG);
                packageRegistry.put((Object)f.PKG_EXT.getNsURI(), (Object)f.PKG_EXT);
            }
        });
        this.launchMigration(file);
        f.reload();
        XMLHelper helper = (XMLHelper)f.values.get("XMLHelper");
        NsPrefixTest.assertTrue((!helper.getPrefixToNamespaceMap().containsKey((Object)"extension") ? 1 : 0) != 0);
        NsPrefixTest.assertTrue((boolean)helper.getPrefixToNamespaceMap().containsKey((Object)f.PKG_EXT.getNsPrefix()));
    }
}

