/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.migration.ju.fwk;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.test.migration.ju.fwk.MigrationContributionTest;

public class PackageRegistryTest
extends MigrationContributionTest {
    static final String OWNER = "a";
    static final String ONE = "b";
    static final String TWO = "c";
    static final String EOBJECT_PROCEEDED = "A";

    public void test() throws Exception {
        this.checkNoPackageRegistry();
        this.checkPackageRegistry();
    }

    private MigrationContributionTest.Factory initModel(IFile file) {
        MigrationContributionTest.Factory f = new MigrationContributionTest.Factory(this, file);
        f.init(res -> {
            EObject owner = f.create("Owner", OWNER);
            EObject one = f.create("One", ONE);
            f.set(owner, "ownedOne", one);
            res.getContents().add((Object)owner);
        });
        return f;
    }

    private void checkNoPackageRegistry() throws Exception {
        IFile file = this.getFile("test.model");
        final MigrationContributionTest.Factory f = this.initModel(file);
        this.addContribution(new MigrationContributionTest.TestMigrationContribution(this){

            public void unaryMigrationExecute(EObject currentElement, MigrationContext context) {
                if ("Owner".equals(currentElement.eClass().getName())) {
                    PackageRegistryTest.assertTrue((boolean)(currentElement instanceof AnyType));
                    f.values.put(PackageRegistryTest.EOBJECT_PROCEEDED, true);
                }
            }
        });
        this.launchMigration(file);
        PackageRegistryTest.assertTrue((boolean)f.values.containsKey(EOBJECT_PROCEEDED));
    }

    private void checkPackageRegistry() throws Exception {
        IFile file = this.getFile("test2.model");
        final MigrationContributionTest.Factory f = this.initModel(file);
        this.addContribution(new MigrationContributionTest.TestMigrationContribution(this){

            public void contributePackageRegistry(EPackage.Registry packageRegistry, MigrationContext context) {
                super.contributePackageRegistry(packageRegistry, context);
                packageRegistry.put((Object)f.PKG.getNsURI(), (Object)f.PKG);
            }

            public void unaryMigrationExecute(EObject currentElement, MigrationContext context) {
                if ("Owner".equals(currentElement.eClass().getName())) {
                    PackageRegistryTest.assertTrue((boolean)(currentElement instanceof DynamicEObjectImpl));
                    f.values.put(PackageRegistryTest.EOBJECT_PROCEEDED, true);
                }
            }
        });
        this.launchMigration(file);
        PackageRegistryTest.assertTrue((boolean)f.values.containsKey(EOBJECT_PROCEEDED));
    }
}

