/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.migration.ju.testcases.basic;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.diffdata.EAttributeValuePresence;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.impl.scopes.FragmentedModelScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.capella.core.compare.CapellaDiffPolicy;
import org.polarsys.capella.core.compare.CapellaMatchPolicy;
import org.polarsys.capella.core.compare.CapellaMergePolicy;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.migration.ju.helpers.MigrationHelper;

public class FunctionalChainNonRegressionTest
extends BasicTestCase {
    private static final String SOURCE_MODEL = "FunctionalChains";
    private static final String TARGET_MIGRATED_MODEL = "FunctionalChainsNonRegression";
    private static final String SOURCE_MODEL_RESOURCE = "FunctionalChains.capella";
    private static final String TARGET_MIGRATED_MODEL_RESOURCE = "FunctionalChainsNonRegression.capella";
    private IProject sourceModelProject;
    private IProject targetMigratedModelProject;

    public List<String> getRequiredTestModels() {
        return Arrays.asList(SOURCE_MODEL, TARGET_MIGRATED_MODEL);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.sourceModelProject = IResourceHelpers.getEclipseProjectInWorkspace((String)SOURCE_MODEL);
        this.targetMigratedModelProject = IResourceHelpers.getEclipseProjectInWorkspace((String)TARGET_MIGRATED_MODEL);
    }

    public void test() throws Exception {
        if (this.sourceModelProject.exists() && this.targetMigratedModelProject.exists()) {
            MigrationHelper.migrateProject(this.sourceModelProject);
            Resource sourceResource = this.getResourceToTest(this.sourceModelProject, SOURCE_MODEL_RESOURCE);
            Resource targetResource = this.getResourceToTest(this.targetMigratedModelProject, TARGET_MIGRATED_MODEL_RESOURCE);
            FragmentedModelScope sourceProjectScope = new FragmentedModelScope(sourceResource, true);
            FragmentedModelScope targetProjectScope = new FragmentedModelScope(targetResource, true);
            EComparisonImpl comparison = new EComparisonImpl((IEditableTreeDataScope)sourceProjectScope, (IEditableTreeDataScope)targetProjectScope);
            comparison.compute((IMatchPolicy)new CapellaMatchPolicy(), (IDiffPolicy)new CapellaDiffPolicy(){

                protected boolean doConsiderOrdered(EStructuralFeature feature_p) {
                    if (feature_p.equals(FaPackage.Literals.FUNCTIONAL_CHAIN__OWNED_FUNCTIONAL_CHAIN_INVOLVEMENTS)) {
                        return false;
                    }
                    return super.doConsiderOrdered(feature_p);
                }
            }, (IMergePolicy)new CapellaMergePolicy(), (IProgressMonitor)new NullProgressMonitor());
            this.assertOnlyProjectNameDifference(comparison.getDifferences(Role.TARGET), SOURCE_MODEL);
            this.assertOnlyProjectNameDifference(comparison.getDifferences(Role.REFERENCE), TARGET_MIGRATED_MODEL);
        }
    }

    public void assertOnlyProjectNameDifference(Collection<IDifference<EObject>> differences, String projectName) {
        FunctionalChainNonRegressionTest.assertEquals((int)1, (int)differences.size());
        IDifference<EObject> difference = differences.iterator().next();
        FunctionalChainNonRegressionTest.assertTrue((boolean)(difference instanceof EAttributeValuePresence));
        FunctionalChainNonRegressionTest.assertEquals((Object)((EAttributeValuePresence)difference).getValue(), (Object)projectName);
    }

    private Resource getResourceToTest(IProject project, String fileName) {
        IFile file = project.getFile(fileName);
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        return resourceSet.getResource(fileURI, true);
    }
}

