/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.components;

import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.test.diagram.common.ju.context.PABDiagram;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.SkeletonHelper;
import org.polarsys.capella.test.model.ju.components.CompositionTestCase;

public class PACompositionTestCase
extends CompositionTestCase {
    @Override
    protected void testOn(SessionContext context) {
        this.checkCompositionPA(context, "3dbda056-db8d-40aa-b505-c0aa41c4f683", "6649e0be-1e19-433c-93df-47a8f8918750");
        this.checkCompositionPA(context, "6649e0be-1e19-433c-93df-47a8f8918750", "6649e0be-1e19-433c-93df-47a8f8918750");
        PABDiagram diagram = PABDiagram.createDiagram((SessionContext)context, (String)"3dbda056-db8d-40aa-b505-c0aa41c4f683");
        String actorId = diagram.createActor(this.getComponentName());
        Component actor = (Component)((Part)context.getSemanticElement(actorId)).getAbstractType();
        this.checkCompositionPA(context, actor.getId(), actor.getId());
        String compId = diagram.createNodeComponent(this.getComponentName(), diagram.getDiagramId());
        Component comp = (Component)((Part)context.getSemanticElement(compId)).getAbstractType();
        this.checkCompositionPA(context, comp.getId(), comp.getId());
        ComponentPkg pkg = (ComponentPkg)SkeletonHelper.createComponentPkg((String)"6649e0be-1e19-433c-93df-47a8f8918750", (String)"PA Component PKG1", (SessionContext)context);
        this.checkCompositionPA(context, pkg.getId(), pkg.getId());
    }

    protected void checkCompositionPA(SessionContext context, String diagramContainerId, String targetContainerId) {
        String structureId = "3dbda056-db8d-40aa-b505-c0aa41c4f683";
        String systemId = "6649e0be-1e19-433c-93df-47a8f8918750";
        Component componentSystem = (Component)context.getSemanticElement(systemId);
        CapellaElement componentContainer = (CapellaElement)context.getSemanticElement(targetContainerId);
        PABDiagram diagram = PABDiagram.createDiagram((SessionContext)context, (String)diagramContainerId);
        String actor1Id = diagram.createActor(this.getComponentName());
        PhysicalComponent actor1 = (PhysicalComponent)((Part)context.getSemanticElement(actor1Id)).getAbstractType();
        CapellaElement structure = (CapellaElement)context.getSemanticElement(structureId);
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)actor1.getId(), (Object)structure.getId()), (Object)actor1.eContainer(), (Object)structure);
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be {1}", (Object)actor1.getId(), (Object)"NODE"), (Object)PhysicalComponentNature.NODE, (Object)actor1.getNature());
        String actor1_1Id = diagram.createActor(this.getComponentName(), actor1Id);
        PhysicalComponent actor1_1 = (PhysicalComponent)((Part)context.getSemanticElement(actor1_1Id)).getAbstractType();
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)actor1_1.getId(), (Object)actor1.getId()), (Object)actor1_1.eContainer(), (Object)actor1);
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be {1}", (Object)actor1_1.getId(), (Object)"NODE"), (Object)PhysicalComponentNature.NODE, (Object)actor1_1.getNature());
        this.setHuman(context, (Component)actor1_1, true);
        diagram.cannotCreateActor(this.getComponentName(), actor1_1Id);
        this.setHuman(context, (Component)actor1_1, true);
        diagram.cannotCreateBehaviorComponent(this.getComponentName(), actor1_1Id);
        diagram.cannotCreateNodeComponent(this.getComponentName(), actor1_1Id);
        diagram.createDeployedBehaviorComponent(this.getComponentName(), actor1_1Id);
        diagram.createDeployedNodeComponent(this.getComponentName(), actor1_1Id);
        String nodePC1Id = diagram.createNodeComponent(this.getComponentName(), actor1Id);
        PhysicalComponent nodePC1 = (PhysicalComponent)((Part)context.getSemanticElement(nodePC1Id)).getAbstractType();
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)nodePC1.getId(), (Object)actor1.getId()), (Object)nodePC1.eContainer(), (Object)actor1);
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be {1}", (Object)nodePC1.getId(), (Object)"NODE"), (Object)PhysicalComponentNature.NODE, (Object)nodePC1.getNature());
        String nodePC1_1Id = diagram.createNodeComponent(this.getComponentName(), nodePC1Id);
        PhysicalComponent nodePC1_1 = (PhysicalComponent)((Part)context.getSemanticElement(nodePC1_1Id)).getAbstractType();
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)nodePC1_1.getId(), (Object)nodePC1.getId()), (Object)nodePC1_1.eContainer(), (Object)nodePC1);
        String bComp1Id = diagram.createDeployedBehaviorComponent(this.getComponentName(), actor1Id);
        PhysicalComponent bComp1 = (PhysicalComponent)((Part)context.getSemanticElement(bComp1Id)).getAbstractType();
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)bComp1.getId(), (Object)componentSystem.getId()), (Object)bComp1.eContainer(), (Object)componentSystem);
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be {1}", (Object)nodePC1.getId(), (Object)"BEHAVIOR"), (Object)PhysicalComponentNature.BEHAVIOR, (Object)bComp1.getNature());
        String bComp2Id = diagram.createDeployedBehaviorComponent(this.getComponentName(), nodePC1Id);
        PhysicalComponent bComp2 = (PhysicalComponent)((Part)context.getSemanticElement(bComp2Id)).getAbstractType();
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)bComp2.getId(), (Object)componentSystem.getId()), (Object)bComp2.eContainer(), (Object)componentSystem);
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be {1}", (Object)bComp2.getId(), (Object)"BEHAVIOR"), (Object)PhysicalComponentNature.BEHAVIOR, (Object)bComp2.getNature());
        String actorbComp2Id = diagram.createActor(this.getComponentName(), bComp2Id);
        PhysicalComponent actorbComp2 = (PhysicalComponent)((Part)context.getSemanticElement(actorbComp2Id)).getAbstractType();
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)actorbComp2.getId(), (Object)bComp2.getId()), (Object)actorbComp2.eContainer(), (Object)bComp2);
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be {1}", (Object)actorbComp2.getId(), (Object)bComp2.getNature().toString()), (Object)actorbComp2.getNature(), (Object)bComp2.getNature());
        String nodePC2Id = diagram.createNodeComponent(this.getComponentName(), diagram.getDiagramId());
        PhysicalComponent nodePC2 = (PhysicalComponent)((Part)context.getSemanticElement(nodePC2Id)).getAbstractType();
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)nodePC2.getId(), (Object)componentContainer.getId()), (Object)nodePC2.eContainer(), (Object)componentContainer);
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be {1}", (Object)nodePC2.getId(), (Object)"NODE"), (Object)PhysicalComponentNature.NODE, (Object)nodePC2.getNature());
        String nodePC2_1Id = diagram.createNodeComponent(this.getComponentName(), nodePC2Id);
        PhysicalComponent nodePC2_1 = (PhysicalComponent)((Part)context.getSemanticElement(nodePC2_1Id)).getAbstractType();
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)nodePC2_1.getId(), (Object)nodePC2.getId()), (Object)nodePC2_1.eContainer(), (Object)nodePC2);
        String actor2_1Id = diagram.createActor(this.getComponentName(), nodePC2Id);
        PhysicalComponent actor2_1 = (PhysicalComponent)((Part)context.getSemanticElement(actor2_1Id)).getAbstractType();
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)actor2_1.getId(), (Object)nodePC2.getId()), (Object)actor2_1.eContainer(), (Object)nodePC2);
        PACompositionTestCase.assertEquals((Object)actor2_1.getNature(), (Object)nodePC2.getNature());
        String nodePC2_2Id = diagram.createDeployedNodeComponent(this.getComponentName(), nodePC2Id);
        Component nodePC2_2 = (Component)((Part)context.getSemanticElement(nodePC2_2Id)).getAbstractType();
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)nodePC2_2.getId(), (Object)componentSystem.getId()), (Object)nodePC2_2.eContainer(), (Object)componentSystem);
        String nodePC2_1_1Id = diagram.createDeployedNodeComponent(this.getComponentName(), actor2_1Id);
        PhysicalComponent nodePC2_1_1 = (PhysicalComponent)((Part)context.getSemanticElement(nodePC2_1_1Id)).getAbstractType();
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)nodePC2_1_1.getId(), (Object)componentSystem.getId()), (Object)nodePC2_1_1.eContainer(), (Object)componentSystem);
        PACompositionTestCase.assertEquals((Object)PhysicalComponentNature.NODE, (Object)nodePC2_1_1.getNature());
        String actornodePC2_1_1Id = diagram.createActor(this.getComponentName(), nodePC2_1_1Id);
        PhysicalComponent actornodePC2_1_1 = (PhysicalComponent)((Part)context.getSemanticElement(actornodePC2_1_1Id)).getAbstractType();
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)actornodePC2_1_1.getId(), (Object)nodePC2_1_1.getId()), (Object)actornodePC2_1_1.eContainer(), (Object)nodePC2_1_1);
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be {1}", (Object)actornodePC2_1_1.getId(), (Object)nodePC2_1_1.getNature().toString()), (Object)actornodePC2_1_1.getNature(), (Object)nodePC2_1_1.getNature());
        String nodePC2_1_1_1Id = diagram.createNodeComponent(this.getComponentName(), nodePC2_1_1Id);
        Component nodePC2_1_1_1 = (Component)((Part)context.getSemanticElement(nodePC2_1_1_1Id)).getAbstractType();
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)nodePC2_1_1_1.getId(), (Object)nodePC2_1_1.getId()), (Object)nodePC2_1_1_1.eContainer(), (Object)nodePC2_1_1);
        diagram.cannotCreateBehaviorComponent(this.getComponentName(), actornodePC2_1_1Id);
        diagram.cannotCreateBehaviorComponent(this.getComponentName(), nodePC2_2Id);
        diagram.cannotCreateDeployedNodeComponent(this.getComponentName(), diagram.getDiagramId());
        diagram.cannotCreateDeployedBehaviorComponent(this.getComponentName(), diagram.getDiagramId());
        if (targetContainerId.equals(systemId)) {
            String bComp3Id = diagram.createBehaviorComponent(this.getComponentName(), diagram.getDiagramId());
            Component bComp3 = (Component)((Part)context.getSemanticElement(bComp3Id)).getAbstractType();
            PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)bComp3.getId(), (Object)componentSystem.getId()), (Object)bComp3.eContainer(), (Object)componentSystem);
        } else if (componentContainer instanceof Component) {
            diagram.cannotCreateBehaviorComponent(this.getComponentName(), diagram.getDiagramId());
        }
        String bComp4Id = diagram.createBehaviorComponent(this.getComponentName(), bComp2Id);
        Component bComp4 = (Component)((Part)context.getSemanticElement(bComp4Id)).getAbstractType();
        PACompositionTestCase.assertEquals((String)NLS.bind((String)"{0} should be contained in {1}", (Object)bComp4.getId(), (Object)bComp2.getId()), (Object)bComp4.eContainer(), (Object)bComp2);
        diagram.cannotCreateDeployedBehaviorComponent(this.getComponentName(), diagram.getDiagramId());
        diagram.cannotCreateDeployedNodeComponent(this.getComponentName(), diagram.getDiagramId());
        diagram.cannotCreateDeployedNodeComponent(this.getComponentName(), bComp4Id);
        diagram.cannotCreateDeployedNodeComponent(this.getComponentName(), bComp2Id);
    }
}

