/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.helpers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.data.helpers.information.services.DataTypeExt;
import org.polarsys.capella.core.data.information.InformationRealization;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class DataTypeRealizedInformationTest
extends BasicTestCase {
    public static final String BOOLEAN_TYPE_1 = "09dc7956-5dee-44b8-b8b4-7ee623a3a343";
    public static final String BOOLEAN_TYPE_2 = "a9491dd0-cc6e-407f-987e-c82b132ce601";
    public static final String DIAGRAM = "[CDB] Data";
    public static String MODEL_NAME = "miscmodel";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(MODEL_NAME);
    }

    public void test() throws Exception {
        CapellaModel model = this.getTestModel(MODEL_NAME);
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        final BooleanType bt1 = (BooleanType)IdManager.getInstance().getEObject(BOOLEAN_TYPE_1, (IScope)scope);
        final BooleanType bt2 = (BooleanType)IdManager.getInstance().getEObject(BOOLEAN_TYPE_2, (IScope)scope);
        DSemanticDiagram diagram = (DSemanticDiagram)DiagramHelper.getDRepresentation((Session)session, (String)DIAGRAM);
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                DataTypeExt.addRealizedInformation((DataType)bt1, (TraceableElement)bt2);
            }
        };
        TestHelper.getExecutionManager((EObject)diagram).execute((ICommand)cmd);
        DataTypeRealizedInformationTest.assertFalse((boolean)bt1.getOwnedInformationRealizations().isEmpty());
        DataTypeRealizedInformationTest.assertTrue((((InformationRealization)bt1.getOwnedInformationRealizations().get(0)).getSourceElement() != null ? 1 : 0) != 0);
        DataTypeRealizedInformationTest.assertTrue((boolean)((InformationRealization)bt1.getOwnedInformationRealizations().get(0)).getSourceElement().equals(bt1));
    }
}

