/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.menu;

import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.mdsofa.common.constant.ICommonConstants;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.PrimitiveWrapper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.libraries.model.ICapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.platform.sirius.ui.handlers.CopyPathHandler;
import org.polarsys.capella.core.platform.sirius.ui.handlers.DeleteHandler;
import org.polarsys.capella.core.sirius.ui.handlers.CopyTextHandler;
import org.polarsys.capella.core.ui.properties.richtext.handlers.CopyAsDescriptionLinkHandler;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.model.ju.model.MiscModel;

public class CapellaMenusTestCase
extends MiscModel {
    ICapellaModel model;
    IScope scope;

    public void test() throws Exception {
        this.init();
        EObject selectedElement = IdManager.getInstance().getEObject("5b6b9d5b-d024-4423-9271-bcb3d77469c2", this.scope);
        CapellaMenusTestCase.assertNotNull((Object)selectedElement);
        this.testMenus("5b6b9d5b-d024-4423-9271-bcb3d77469c2", selectedElement);
        String pabDiagramID = "_HY2uQekKEem8xqbBNWv2mQ";
        EObject pabDiagram = IdManager.getInstance().getEObject(pabDiagramID, this.scope);
        CapellaMenusTestCase.assertTrue((boolean)(pabDiagram instanceof DRepresentationDescriptor));
        this.testDiagramMenus(pabDiagramID, (DRepresentationDescriptor)pabDiagram);
        this.testCopyAsTextNumericValue(5);
        this.testCopyAsTextNumericValue(5, 8, 9);
    }

    protected void init() {
        this.model = this.getTestModel();
        this.scope = new ScopeModelWrapper((IModel)this.model);
    }

    protected void testMenus(String selectedElementId, EObject selectedElement) {
        this.testDeleteCommand(selectedElementId, selectedElement);
        this.testCopyQualifiedNameCommand(selectedElement);
        this.testCopyAsDescriptionLinkCommand(selectedElement);
        this.testCopyAsTextCommand(selectedElement);
    }

    protected void testDiagramMenus(String selectedElementId, DRepresentationDescriptor selectedElement) {
        this.testDeleteCommand(selectedElementId, (EObject)selectedElement);
        this.testCopyAsDescriptionLinkCommand((EObject)selectedElement);
        this.testCopyAsTextCommand((EObject)selectedElement);
        this.testCopyAsTextValue((EObject)selectedElement, selectedElement.getName());
    }

    protected void testDeleteCommand(String selectedElementId, EObject selectedElement) {
        try {
            new DeleteHandler(){

                protected boolean withConfirmDeletion() {
                    return false;
                }
            }.execute(this.createExecutionEvent(selectedElement));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (selectedElement instanceof CapellaElement) {
            CapellaElement element = (CapellaElement)selectedElement;
            String id = element.getId();
            CapellaMenusTestCase.assertEquals((String)id, (String)selectedElementId);
        }
        EObject object = IdManager.getInstance().getEObject(selectedElementId, this.scope);
        CapellaMenusTestCase.assertNull((Object)object);
    }

    protected void testCopyQualifiedNameCommand(EObject selectedElement) {
        try {
            new CopyPathHandler().execute(this.createExecutionEvent(selectedElement));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    protected void testCopyAsDescriptionLinkCommand(EObject selectedElement) {
        try {
            new CopyAsDescriptionLinkHandler().execute(this.createExecutionEvent(selectedElement));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    protected void testCopyAsTextCommand(EObject selectedElement) {
        try {
            new CopyTextHandler().execute(this.createExecutionEvent(selectedElement));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    protected void testCopyAsTextValue(EObject selectedElement, String checkLabel) {
        CapellaMenusTestCase.assertTrue((String)("Copied label should be: " + checkLabel), (boolean)checkLabel.equals(this.getCopyAsText(selectedElement)));
    }

    protected void testCopyAsTextNumericValue(Integer ... values) {
        Object[] wrappers = Arrays.stream(values).map(value -> new PrimitiveWrapper(value)).toArray();
        String valuesStr = Arrays.stream(values).map(value -> String.valueOf(value)).collect(Collectors.joining(ICommonConstants.LINE_SEPARATOR));
        CapellaMenusTestCase.assertEquals((String)valuesStr, (String)this.getCopyAsText(wrappers));
    }

    private String getCopyAsText(Object ... values) {
        final ExecutionEvent event = this.createExecutionEvent(values);
        String result = new CopyTextHandler(){

            protected IStructuredSelection getSelection() {
                IEvaluationContext context = (IEvaluationContext)event.getApplicationContext();
                return (IStructuredSelection)context.getVariable("selection");
            }
        }.getSelectionAsText();
        return result;
    }

    private ExecutionEvent createExecutionEvent(Object ... elements) {
        EvaluationContext context = new EvaluationContext(null, new Object());
        HashMap parameters = new HashMap();
        ExecutionEvent event = new ExecutionEvent(null, parameters, null, (Object)context);
        context.addVariable("selection", (Object)new StructuredSelection(Arrays.asList(elements)));
        return event;
    }
}

