/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.oa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelOaSa;

public class CapabilityTransition
extends TopDownTransitionTestCase {
    private OperationalCapabilityPkg _rootOCPkg;
    private OperationalCapabilityPkg _subOCPkg;
    private OperationalCapability _oaOC1;
    private OperationalCapability _oaOC11;
    private OperationalCapability _oaOC2;
    private OperationalCapability _oaOC3;
    private OperationalCapability _oaSubOC1;
    private OperationalCapability OC1;
    private CapabilityPkg _rootCapabilityPkg;
    private CapabilityPkg _subCapabilityPkg;
    private Capability _ctxOC1;
    private Capability _ctxOC11;
    private Capability _ctxOC2;
    private Capability _ctxOC3;
    private Capability _ctxSubOC1;
    private SystemComponent SA_SYSTEM;
    private SystemComponent SA_OE3;
    private SystemComponent SA_OA1;

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this._rootOCPkg = (OperationalCapabilityPkg)this.getObject(ModelOaSa.rootOCPkgId);
        this._oaOC1 = (OperationalCapability)this.getObject(ModelOaSa.oc1Id);
        this._oaOC11 = (OperationalCapability)this.getObject(ModelOaSa.oc11Id);
        this._oaOC2 = (OperationalCapability)this.getObject(ModelOaSa.oc2Id);
        this._rootCapabilityPkg = (CapabilityPkg)this.getObject(ModelOaSa.rootCapabilityPkgId);
        this.OC1 = (OperationalCapability)this.getObject("9fd52848-ca2b-4c52-a6d5-ced8a04fb83e");
        this.SA_SYSTEM = (SystemComponent)this.getObject("50bb7f6f-96a9-41f9-a97c-4a5f1306734f");
        this.SA_OE3 = (SystemComponent)this.getObject("182730a6-438d-45bc-a0e3-e947805e5389");
        this.SA_OA1 = (SystemComponent)this.getObject("14e523bd-7e1a-4745-9563-18223acf1e07");
        this.performTest1();
        this.performTest2();
        this.performTest3();
        this.performTest4();
        this.performTest5();
    }

    public void performTest1() throws Exception {
        this.performCapabilityTransition(Collections.singletonList(this._oaOC11));
        this._ctxOC11 = (Capability)this.mustBeTransitioned(ModelOaSa.oc11Id);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC11.getName(), (Object)this._oaOC11.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC11) == this._oaOC11 ? 1 : 0) != 0);
    }

    public void performTest2() throws Exception {
        this.performCapabilityTransition(Collections.singletonList(this._rootOCPkg));
        this._ctxOC1 = ProjectionTestUtils.getProjectedCapability(this._oaOC1);
        this.mustNotBeNull((EObject)this._ctxOC1);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this._oaOC1.getName()), (this._oaOC1.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this._ctxOC1.getName()), (this._ctxOC1.eContainer() == this._rootCapabilityPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC1.getName(), (Object)this._oaOC1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC1) == this._oaOC1 ? 1 : 0) != 0);
        this._ctxOC2 = ProjectionTestUtils.getProjectedCapability(this._oaOC2);
        this.mustNotBeNull((EObject)this._ctxOC2);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this._oaOC2.getName()), (this._oaOC2.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this._ctxOC2.getName()), (this._ctxOC2.eContainer() == this._rootCapabilityPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC2.getName(), (Object)this._oaOC2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC2) == this._oaOC2 ? 1 : 0) != 0);
    }

    public void performTest3() throws Exception {
        this.performCapabilityTransition(Collections.singletonList(this._rootOCPkg));
        int oaSize = this._rootOCPkg.getOwnedOperationalCapabilities().size();
        int ctxSize = this._rootCapabilityPkg.getOwnedCapabilities().size();
        CapabilityTransition.assertTrue((String)Messages.WrongAllocation, (oaSize == ctxSize ? 1 : 0) != 0);
    }

    public void performTest4() throws Exception {
        this.getExecutionManager((EObject)this._rootOCPkg).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                CapabilityTransition.this._oaOC2.destroy();
                CapabilityTransition.this._oaOC3 = OaFactory.eINSTANCE.createOperationalCapability("OC3");
                CapabilityTransition.this._rootOCPkg.getOwnedOperationalCapabilities().add((Object)CapabilityTransition.this._oaOC3);
                CapabilityTransition.this._subOCPkg = OaFactory.eINSTANCE.createOperationalCapabilityPkg("Sub OC Pkg");
                CapabilityTransition.this._rootOCPkg.getOwnedOperationalCapabilityPkgs().add((Object)CapabilityTransition.this._subOCPkg);
                CapabilityTransition.this._oaSubOC1 = OaFactory.eINSTANCE.createOperationalCapability("Sub OC1");
                CapabilityTransition.this._subOCPkg.getOwnedOperationalCapabilities().add((Object)CapabilityTransition.this._oaSubOC1);
            }
        });
        this.performCapabilityTransition(Collections.singletonList(this._rootOCPkg));
        this.mustNotBeNull((EObject)this._ctxOC2);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC2.getName(), (Object)this._oaOC2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC2) == null ? 1 : 0) != 0);
        this._ctxOC3 = ProjectionTestUtils.getProjectedCapability(this._oaOC3);
        this.mustNotBeNull((EObject)this._ctxOC3);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this._oaOC3.getName()), (this._oaOC3.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this._ctxOC3.getName()), (this._ctxOC3.eContainer() == this._rootCapabilityPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC3.getName(), (Object)this._oaOC3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC3) == this._oaOC3 ? 1 : 0) != 0);
        this._subCapabilityPkg = (CapabilityPkg)this._rootCapabilityPkg.getOwnedCapabilityPkgs().get(0);
        this.mustNotBeNull((EObject)this._subCapabilityPkg);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._subCapabilityPkg.getName(), (Object)this._subOCPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._subCapabilityPkg) == this._subOCPkg ? 1 : 0) != 0);
        this._ctxSubOC1 = (Capability)this._subCapabilityPkg.getOwnedCapabilities().get(0);
        this.mustNotBeNull((EObject)this._ctxSubOC1);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxSubOC1.getName(), (Object)this._oaSubOC1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxSubOC1) == this._oaSubOC1 ? 1 : 0) != 0);
    }

    public void performTest5() throws Exception {
        this.performCapabilityTransition(Collections.singletonList(this.OC1));
        Capability ctxOC1 = (Capability)this.mustBeTransitioned("9fd52848-ca2b-4c52-a6d5-ced8a04fb83e");
        CapabilityTransition.assertTrue((String)"There must be only one involvement between the transitioned OC3 and the System ", (ctxOC1.getOwnedCapabilityInvolvements().stream().filter(i -> i.getInvolved() == this.SA_SYSTEM).count() == 1L ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)"There must be an involvement between the transitioned OC3 and the transitioned OE3 ", (ctxOC1.getOwnedCapabilityInvolvements().stream().filter(i -> i.getInvolved() == this.SA_OE3).count() == 1L ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)"There must be an involvement between the transitioned OC3 and the transitioned OA1 ", (ctxOC1.getOwnedCapabilityInvolvements().stream().filter(i -> i.getInvolved() == this.SA_OA1).count() == 1L ? 1 : 0) != 0);
        Capability ctxOC2 = (Capability)this.mustBeTransitioned("8b4ee168-aad2-493d-8b0e-df15a1ab570b");
        Capability ctxOC3 = (Capability)this.mustBeTransitioned("d60b1a48-5048-475f-b17a-1c85055cd310");
        Capability ctxOC4 = (Capability)this.mustBeTransitioned("b69d0f31-5cbe-4ec4-bf1c-cad7b94cec08");
        ctxOC1.getExtendedAbstractCapabilities().contains((Object)ctxOC2);
        ctxOC1.getIncludedAbstractCapabilities().contains((Object)ctxOC3);
        ctxOC1.getSuper().contains((Object)ctxOC4);
    }
}

