/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.sa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.Parameter;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.Service;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.StringType;
import org.polarsys.capella.core.data.information.datavalue.LiteralBooleanValue;
import org.polarsys.capella.test.transition.ju.CodeHelper;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelCtxLa;

public class DataTransition
extends TopDownTransitionTestCase {
    private DataPkg _ctxDataPkg;
    private DataPkg _saMyDataPkg;
    private Class _ctxPrimitiveClass;
    private Class _ctxSuperClass;
    private Class _ctxSubClass;
    private Class _ctxUnion;
    private Collection _saMyCollection;
    private Service _saMyService;
    private Parameter _saMyParameter;
    private BooleanType _saMyBooleanType;
    private LiteralBooleanValue _saFalseValue;
    private LiteralBooleanValue _saTrueValue;
    private StringType _ctxSuperST;
    private StringType _ctxSubST;
    private Property _ctxProperty1;
    private Service _ctxService1;
    private Parameter _ctxParameter1;
    private Service _ctxService2;
    private Parameter _ctxParameter2;
    private Constraint _ctxConstraint1;
    private DataPkg _laDataPkg;
    private DataPkg _laMyDataPkg;
    private Class _laPrimitiveClass;
    private Class _laSuperClass;
    private Class _laSubClass;
    private Class _laUnion;
    private Collection _laMyCollection;
    private Service _laMyService;
    private Parameter _laMyParameter;
    private BooleanType _laMyBooleanType;
    private LiteralBooleanValue _laFalseValue;
    private LiteralBooleanValue _laTrueValue;
    private StringType _laSuperST;
    private StringType _laSubST;
    private Property _laProperty1;
    private Service _laService1;
    private Parameter _laParameter1;
    private Service _laService2;
    private Parameter _laParameter2;
    private Constraint _laConstraint1;

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this._ctxDataPkg = (DataPkg)this.getObject(ModelCtxLa.ctxDataPkgId);
        this._ctxPrimitiveClass = (Class)this.getObject(ModelCtxLa.primitiveClassId);
        this._ctxSuperClass = (Class)this.getObject(ModelCtxLa.superClassId);
        this._ctxSubClass = (Class)this.getObject(ModelCtxLa.subClassId);
        this._ctxSuperST = (StringType)this.getObject(ModelCtxLa.superSTId);
        this._ctxSubST = (StringType)this.getObject(ModelCtxLa.subSTId);
        this._ctxProperty1 = (Property)this.getObject(ModelCtxLa.property1Id);
        this._ctxService1 = (Service)this.getObject(ModelCtxLa.service1Id);
        this._ctxParameter1 = (Parameter)this.getObject(ModelCtxLa.parameter1Id);
        this._ctxService2 = (Service)this.getObject(ModelCtxLa.service2Id);
        this._ctxConstraint1 = (Constraint)this.getObject(ModelCtxLa.constraint1Id);
        this._laDataPkg = (DataPkg)this.getObject(ModelCtxLa.laDataPkgId);
        this._saMyDataPkg = (DataPkg)this.getObject(ModelCtxLa.saMyDataPkgId);
        this._saMyCollection = (Collection)this.getObject(ModelCtxLa.saMyCollectionId);
        this._saMyService = (Service)this.getObject(ModelCtxLa.saMyServiceId);
        this._saMyParameter = (Parameter)this.getObject(ModelCtxLa.saMyParameterId);
        this._saMyBooleanType = (BooleanType)this.getObject(ModelCtxLa.saMyBooleanTypeId);
        this._saFalseValue = (LiteralBooleanValue)this.getObject(ModelCtxLa.saFalseValueId);
        this._saTrueValue = (LiteralBooleanValue)this.getObject(ModelCtxLa.saTrueValueId);
        this.performTest1();
        this.performTest2();
        this.performTest3();
        this.performTest4();
        this.performTest5();
    }

    public void performTest1() throws Exception {
        this.performDataTransition(Collections.singletonList(this._saMyCollection));
        this._laMyDataPkg = (DataPkg)this._laDataPkg.getOwnedDataPkgs().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laMyDataPkg);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laMyDataPkg.getName(), (Object)this._saMyDataPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laMyDataPkg) == this._saMyDataPkg ? 1 : 0) != 0);
        this._laMyBooleanType = (BooleanType)this._laMyDataPkg.getOwnedDataTypes().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laMyBooleanType);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laMyBooleanType.getName(), (Object)this._saMyBooleanType.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laMyBooleanType) == this._saMyBooleanType ? 1 : 0) != 0);
        this._laFalseValue = (LiteralBooleanValue)this._laMyBooleanType.getOwnedLiterals().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laFalseValue);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laFalseValue.getName(), (Object)this._saFalseValue.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laFalseValue) == this._saFalseValue ? 1 : 0) != 0);
        DataTransition.assertFalse((String)NLS.bind((String)Messages.WrongValue, (Object)this._laFalseValue.getName()), (boolean)this._laFalseValue.isValue());
        this._laTrueValue = (LiteralBooleanValue)this._laMyBooleanType.getOwnedLiterals().get(1);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laTrueValue);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laTrueValue.getName(), (Object)this._saTrueValue.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laTrueValue) == this._saTrueValue ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongValue, (Object)this._laTrueValue.getName()), (boolean)this._laTrueValue.isValue());
        this._laMyCollection = (Collection)this._laDataPkg.getOwnedCollections().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laMyCollection);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laMyCollection.getName(), (Object)this._saMyCollection.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laMyCollection) == this._saMyCollection ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this._laMyCollection.getName(), (Object)this._laMyBooleanType.getName()), (this._laMyCollection.getType() == this._laMyBooleanType ? 1 : 0) != 0);
        this._laMyService = (Service)this._laMyCollection.getContainedOperations().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laMyService);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laMyService.getName(), (Object)this._saMyService.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laMyService) == this._saMyService ? 1 : 0) != 0);
        this._laMyParameter = (Parameter)this._laMyService.getOwnedParameters().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laMyParameter);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laMyParameter.getName(), (Object)this._saMyParameter.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laMyParameter) == this._saMyParameter ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this._laMyParameter.getName(), (Object)this._laMyBooleanType.getName()), (this._laMyParameter.getType() == this._laMyBooleanType ? 1 : 0) != 0);
    }

    public void performTest2() throws Exception {
        this.performDataTransition(Collections.singletonList(this._ctxPrimitiveClass));
        this._laPrimitiveClass = ProjectionTestUtils.getRecentlyAddedClass(this._laDataPkg);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laPrimitiveClass);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laPrimitiveClass.getName(), (Object)this._ctxPrimitiveClass.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laPrimitiveClass) == this._ctxPrimitiveClass ? 1 : 0) != 0);
    }

    public void performTest3() throws Exception {
        this.performDataTransition(Collections.singletonList(this._ctxSubClass));
        this._laSuperST = (StringType)this._laDataPkg.getOwnedDataTypes().get(0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laSuperST.getName(), (Object)this._ctxSuperST.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laSuperST) == this._ctxSuperST ? 1 : 0) != 0);
        this._laSubST = (StringType)this._laDataPkg.getOwnedDataTypes().get(1);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laSubST.getName(), (Object)this._ctxSubST.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laSubST) == this._ctxSubST ? 1 : 0) != 0);
        this._laSubClass = (Class)CodeHelper.getChildTracingElement((EObject)this._laDataPkg, (EObject)this._ctxSubClass);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laSubClass);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laSubClass.getName(), (Object)this._ctxSubClass.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laSubClass) == this._ctxSubClass ? 1 : 0) != 0);
        this._laService1 = (Service)this._laSubClass.getContainedOperations().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laService1);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laService1.getName(), (Object)this._ctxService1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laService1) == this._ctxService1 ? 1 : 0) != 0);
        this._laParameter1 = (Parameter)this._laService1.getOwnedParameters().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laParameter1);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laParameter1.getName(), (Object)this._ctxParameter1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laParameter1) == this._ctxParameter1 ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this._laParameter1.getName(), (Object)this._laSuperST.getName()), (this._laParameter1.getType() == this._laSuperST ? 1 : 0) != 0);
        this._laService2 = (Service)this._laSubClass.getContainedOperations().get(1);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laService2);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laService2.getName(), (Object)this._ctxService2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laService2) == this._ctxService2 ? 1 : 0) != 0);
        this._laSuperClass = (Class)CodeHelper.getChildTracingElement((EObject)this._laDataPkg, (EObject)this._ctxSuperClass);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laSuperClass);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laSuperClass.getName(), (Object)this._ctxSuperClass.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laSuperClass) == this._ctxSuperClass ? 1 : 0) != 0);
        this._laProperty1 = (Property)this._laSuperClass.getContainedProperties().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laSuperClass);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laProperty1.getName(), (Object)this._ctxProperty1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laProperty1) == this._ctxProperty1 ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this._laProperty1.getName(), (Object)this._laSubST.getName()), (this._laProperty1.getType() == this._laSubST ? 1 : 0) != 0);
        this._laConstraint1 = (Constraint)this._laSubClass.getOwnedConstraints().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laConstraint1);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laConstraint1.getName(), (Object)this._ctxConstraint1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laConstraint1) == this._ctxConstraint1 ? 1 : 0) != 0);
    }

    public void performTest4() throws Exception {
        this.performDataTransition(Collections.singletonList(this._ctxDataPkg));
        DataTransition.assertEquals((String)Messages.ProjectionSizeError, (int)this._ctxDataPkg.getOwnedClasses().size(), (int)this._laDataPkg.getOwnedClasses().size());
        DataTransition.assertEquals((String)Messages.ProjectionSizeError, (int)this._ctxDataPkg.getOwnedDataTypes().size(), (int)this._laDataPkg.getOwnedDataTypes().size());
    }

    public void performTest5() throws Exception {
        this.getExecutionManager((EObject)this._ctxDataPkg).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                DataTransition.this._ctxService1.destroy();
                DataTransition.this._ctxUnion = (Class)InformationFactory.eINSTANCE.createUnion("Union1");
                DataTransition.this._ctxDataPkg.getOwnedClasses().add((Object)DataTransition.this._ctxUnion);
                DataTransition.this._ctxParameter2 = InformationFactory.eINSTANCE.createParameter("Parameter2");
                DataTransition.this._ctxParameter2.setAbstractType((AbstractType)DataTransition.this._ctxUnion);
                DataTransition.this._ctxService2.getOwnedParameters().add((Object)DataTransition.this._ctxParameter2);
            }
        });
        this.performDataTransition(Collections.singletonList(this._ctxSubClass));
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laService1);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laService1.getName(), null), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laService1) == null ? 1 : 0) != 0);
        this._laParameter2 = (Parameter)this._laService2.getOwnedParameters().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laParameter2);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laParameter2.getName(), (Object)this._ctxParameter2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laParameter2) == this._ctxParameter2 ? 1 : 0) != 0);
        this._laUnion = ProjectionTestUtils.getRecentlyAddedClass(this._laDataPkg);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._laUnion);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laUnion.getName(), (Object)this._ctxUnion.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laUnion) == this._ctxUnion ? 1 : 0) != 0);
    }
}

