/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.sa;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelCtxLa;

public class ScenarioTransition
extends TopDownTransitionTestCase {
    private Capability _saMyCapability;
    private Scenario _saFSMyCapability;
    private Scenario _saESMyCapability;
    private Scenario _saFSMyCapabilityES;
    private Scenario _saESMyCapabilityIS;
    private Scenario _saESMyCapabilityES;
    private InstanceRole _saFS_SF_3;
    private InstanceRole _saFS_SF_4;
    private InstanceRole _saES_System;
    private InstanceRole _saES_Actor3;
    private InstanceRole _saESMyCapabilityES_System;
    private InstanceRole _saESMyCapabilityES_Actor3;
    private SequenceMessage _saFS_SF3SF4Exchange;
    private SequenceMessage _saFS_SF3SF4ExchangeReturn;
    private SequenceMessage _saES_SF2SF11Exchange;
    private SequenceMessage _saES_SF2SF11ExchangeReturn;
    private SequenceMessage _saESMyCapabilityES_SF2SF11Exchange;
    private SequenceMessage _saESMyCapabilityES_SF2SF11ExchangeReturn;
    private CapabilityRealizationPkg _laCapabilitiesPkg;
    private CapabilityRealization _laMyCapability;
    private Scenario _laFSMyCapability;
    private Scenario _laESMyCapability;
    private InstanceRole _laFS_SF_3;
    private InstanceRole _laFS_SF_4;
    private InstanceRole _laES_System;
    private InstanceRole _laES_Actor3;
    private SequenceMessage _laFS_SF3SF4Exchange;
    private SequenceMessage _laFS_SF3SF4ExchangeReturn;

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this._saMyCapability = (Capability)this.getObject(ModelCtxLa.MyCapabilityId);
        this._saFSMyCapability = (Scenario)this.getObject(ModelCtxLa.FSMyCapabilityId);
        this._saFS_SF_3 = (InstanceRole)this.getObject(ModelCtxLa.SF_3Id);
        this._saFS_SF_4 = (InstanceRole)this.getObject(ModelCtxLa.SF_4Id);
        this._saFS_SF3SF4Exchange = (SequenceMessage)this.getObject(ModelCtxLa.SF3SF4ExchangeId);
        this._saFS_SF3SF4ExchangeReturn = (SequenceMessage)this.getObject(ModelCtxLa.SF3SF4ExchangeReturnId);
        this._saESMyCapability = (Scenario)this.getObject(ModelCtxLa.ESMyCapabilityId);
        this._saES_System = (InstanceRole)this.getObject(ModelCtxLa.SystemId);
        this._saES_Actor3 = (InstanceRole)this.getObject(ModelCtxLa.Actor3Id);
        this._saES_SF2SF11Exchange = (SequenceMessage)this.getObject(ModelCtxLa.SF2SF11ExchangeId);
        this._saES_SF2SF11ExchangeReturn = (SequenceMessage)this.getObject(ModelCtxLa.SF2SF11ExchangeReturnId);
        this._laCapabilitiesPkg = (CapabilityRealizationPkg)this.getObject(ModelCtxLa.laCapabilitiesPkgId);
        this.performTest1();
        this.performTest2();
        this.performTest3();
        this.performTest4();
        this.performTest5();
    }

    public void performTest1() throws Exception {
        this.performFStoFSTransition(Collections.singletonList(this._saFSMyCapability));
        this._laMyCapability = (CapabilityRealization)this._laCapabilitiesPkg.getOwnedCapabilityRealizations().get(0);
        this._laFSMyCapability = (Scenario)this._laMyCapability.getOwnedScenarios().get(0);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._laFSMyCapability);
        String name = this._laFSMyCapability.getName();
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)name, (Object)this._saFSMyCapability.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laFSMyCapability) == this._saFSMyCapability ? 1 : 0) != 0);
        ScenarioKind actualKind = this._saFSMyCapability.getKind();
        ScenarioKind expectedKind = ScenarioKind.FUNCTIONAL;
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualKind.getName(), expectedKind.getName()), (boolean)actualKind.equals((Object)expectedKind));
        int actualIRNumber = this._laFSMyCapability.getOwnedInstanceRoles().size();
        int expectedIRNumber = this._saFSMyCapability.getOwnedInstanceRoles().size();
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualIRNumber, expectedIRNumber), (actualIRNumber == expectedIRNumber ? 1 : 0) != 0);
        int actualIFNumber = this._laFSMyCapability.getOwnedInteractionFragments().size();
        int expectedIFNumber = this._saFSMyCapability.getOwnedInteractionFragments().size();
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualIFNumber, expectedIFNumber), (actualIFNumber == expectedIFNumber ? 1 : 0) != 0);
        int actualMsgNumber = this._laFSMyCapability.getOwnedMessages().size();
        int expectedMsgNumber = this._saFSMyCapability.getOwnedMessages().size();
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualMsgNumber, expectedMsgNumber), (actualMsgNumber == expectedMsgNumber ? 1 : 0) != 0);
        this._laFS_SF_3 = (InstanceRole)this._laFSMyCapability.getOwnedInstanceRoles().get(1);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._laFS_SF_3);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laFS_SF_3.getName(), (Object)this._saFS_SF_3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laFS_SF_3) == this._saFS_SF_3 ? 1 : 0) != 0);
        this._laFS_SF_4 = (InstanceRole)this._laFSMyCapability.getOwnedInstanceRoles().get(0);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._laFS_SF_4);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laFS_SF_4.getName(), (Object)this._saFS_SF_4.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laFS_SF_4) == this._saFS_SF_4 ? 1 : 0) != 0);
        this._laFS_SF3SF4Exchange = (SequenceMessage)this._laFSMyCapability.getOwnedMessages().get(0);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._laFS_SF3SF4Exchange);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laFS_SF3SF4Exchange.getName(), (Object)this._saFS_SF3SF4Exchange.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laFS_SF3SF4Exchange) == this._saFS_SF3SF4Exchange ? 1 : 0) != 0);
        this._laFS_SF3SF4ExchangeReturn = (SequenceMessage)this._laFSMyCapability.getOwnedMessages().get(1);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._laFS_SF3SF4ExchangeReturn);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laFS_SF3SF4ExchangeReturn.getName(), (Object)this._saFS_SF3SF4ExchangeReturn.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laFS_SF3SF4ExchangeReturn) == this._saFS_SF3SF4ExchangeReturn ? 1 : 0) != 0);
    }

    public void performTest2() throws Exception {
        this.performEStoESTransition(Collections.singletonList(this._saESMyCapability));
        this._laESMyCapability = (Scenario)this._laMyCapability.getOwnedScenarios().get(1);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._laESMyCapability);
        String name = this._laESMyCapability.getName();
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)name, (Object)this._saESMyCapability.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laESMyCapability) == this._saESMyCapability ? 1 : 0) != 0);
        ScenarioKind actualKind = this._saESMyCapability.getKind();
        ScenarioKind expectedKind = ScenarioKind.DATA_FLOW;
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualKind.getName(), expectedKind.getName()), (boolean)actualKind.equals((Object)expectedKind));
        int actualIRNumber = this._laESMyCapability.getOwnedInstanceRoles().size();
        int expectedIRNumber = this._saESMyCapability.getOwnedInstanceRoles().size();
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualIRNumber, expectedIRNumber), (actualIRNumber == expectedIRNumber ? 1 : 0) != 0);
        this._laES_System = (InstanceRole)this._laESMyCapability.getOwnedInstanceRoles().get(0);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._laES_System);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laES_System.getName(), (Object)this._saES_System.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laES_System) == this._saES_System ? 1 : 0) != 0);
        this._laES_Actor3 = (InstanceRole)this._laESMyCapability.getOwnedInstanceRoles().get(1);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._laES_Actor3);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laES_Actor3.getName(), (Object)this._saES_Actor3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laES_Actor3) == this._saES_Actor3 ? 1 : 0) != 0);
    }

    public void performTest3() throws Exception {
        this.performFStoESTransition(Collections.singletonList(this._saFSMyCapability));
        this._saFSMyCapabilityES = (Scenario)this._saMyCapability.getOwnedScenarios().get(2);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._saFSMyCapabilityES);
        String name = this._saFSMyCapabilityES.getName();
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)name, (Object)this._saFSMyCapability.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saFSMyCapabilityES) == this._saFSMyCapability ? 1 : 0) != 0);
        ScenarioKind actualKind = this._saFSMyCapabilityES.getKind();
        ScenarioKind expectedKind = ScenarioKind.DATA_FLOW;
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualKind.getName(), expectedKind.getName()), (boolean)actualKind.equals((Object)expectedKind));
    }

    public void performTest4() throws Exception {
        this.performEStoISTransition(Collections.singletonList(this._saESMyCapability));
        this._saESMyCapabilityIS = (Scenario)this._saMyCapability.getOwnedScenarios().get(3);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._saESMyCapabilityIS);
        String name = this._saESMyCapabilityIS.getName();
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)name, (Object)this._saESMyCapability.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saESMyCapabilityIS) == this._saESMyCapability ? 1 : 0) != 0);
        ScenarioKind actualKind = this._saESMyCapabilityIS.getKind();
        ScenarioKind expectedKind = ScenarioKind.INTERFACE;
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualKind.getName(), expectedKind.getName()), (boolean)actualKind.equals((Object)expectedKind));
    }

    public void performTest5() throws Exception {
        this.performESFtoESBTransition(Collections.singletonList(this._saESMyCapability));
        this._saESMyCapabilityES = (Scenario)this._saMyCapability.getOwnedScenarios().get(4);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._saESMyCapabilityES);
        String name = this._saESMyCapabilityES.getName();
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)name, (Object)this._saESMyCapability.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saESMyCapabilityES) == this._saESMyCapability ? 1 : 0) != 0);
        ScenarioKind actualKind = this._saESMyCapabilityES.getKind();
        ScenarioKind expectedKind = ScenarioKind.DATA_FLOW;
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualKind.getName(), expectedKind.getName()), (boolean)actualKind.equals((Object)expectedKind));
        int actualIRNumber = this._saESMyCapabilityES.getOwnedInstanceRoles().size();
        int expectedIRNumber = this._saESMyCapability.getOwnedInstanceRoles().size();
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualIRNumber, expectedIRNumber), (actualIRNumber == expectedIRNumber ? 1 : 0) != 0);
        int actualIFNumber = this._saESMyCapabilityES.getOwnedInteractionFragments().size();
        int expectedIFNumber = this._saESMyCapability.getOwnedInteractionFragments().size();
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualIFNumber, expectedIFNumber), (actualIFNumber == expectedIFNumber ? 1 : 0) != 0);
        int actualMsgNumber = this._saESMyCapabilityES.getOwnedMessages().size();
        int expectedMsgNumber = this._saESMyCapability.getOwnedMessages().size();
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualMsgNumber, expectedMsgNumber), (actualMsgNumber == expectedMsgNumber ? 1 : 0) != 0);
        this._saESMyCapabilityES_System = (InstanceRole)this._saESMyCapabilityES.getOwnedInstanceRoles().get(0);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._saESMyCapabilityES_System);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saESMyCapabilityES_System.getName(), (Object)this._saES_System.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saESMyCapabilityES_System) == this._saES_System ? 1 : 0) != 0);
        this._saESMyCapabilityES_Actor3 = (InstanceRole)this._saESMyCapabilityES.getOwnedInstanceRoles().get(1);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._saESMyCapabilityES_Actor3);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saESMyCapabilityES_Actor3.getName(), (Object)this._saES_Actor3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saESMyCapabilityES_Actor3) == this._saES_Actor3 ? 1 : 0) != 0);
        this._saESMyCapabilityES_SF2SF11Exchange = (SequenceMessage)this._saESMyCapabilityES.getOwnedMessages().get(0);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._saESMyCapabilityES_SF2SF11Exchange);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saESMyCapabilityES_SF2SF11Exchange.getName(), (Object)this._saES_SF2SF11Exchange.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saESMyCapabilityES_SF2SF11Exchange) == this._saES_SF2SF11Exchange ? 1 : 0) != 0);
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, this._saESMyCapabilityES_SF2SF11Exchange.getName()), (boolean)(this._saESMyCapabilityES_SF2SF11Exchange.getInvokedOperation() instanceof ComponentExchange));
        this._saESMyCapabilityES_SF2SF11ExchangeReturn = (SequenceMessage)this._saESMyCapabilityES.getOwnedMessages().get(1);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this._saESMyCapabilityES_SF2SF11ExchangeReturn);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saESMyCapabilityES_SF2SF11ExchangeReturn.getName(), (Object)this._saES_SF2SF11ExchangeReturn.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saESMyCapabilityES_SF2SF11ExchangeReturn) == this._saES_SF2SF11ExchangeReturn ? 1 : 0) != 0);
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, this._saESMyCapabilityES_SF2SF11ExchangeReturn.getName()), (boolean)(this._saESMyCapabilityES_SF2SF11ExchangeReturn.getInvokedOperation() instanceof ComponentExchange));
    }
}

