/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ef.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.polarsys.capella.common.ef.command.AbstractCommand;
import org.polarsys.capella.common.ef.command.ICommand;

public abstract class AbstractCompoundCommand
extends AbstractCommand {
    private List<ICommand> _commands;

    protected AbstractCompoundCommand() {
        this(new ArrayList<ICommand>(0));
    }

    protected AbstractCompoundCommand(List<ICommand> commands) {
        Assert.isNotNull(commands);
        this._commands = commands;
    }

    public void append(ICommand command) {
        this._commands.add(command);
    }

    public void prepend(ICommand command) {
        this._commands.add(0, command);
    }

    public void insert(int index, ICommand command) {
        this._commands.add(index, command);
    }

    public int getContainedCommandsSize() {
        return this._commands.size();
    }

    public List<ICommand> getContainedCommands() {
        return Collections.unmodifiableList(this._commands);
    }

    @Override
    public boolean isReadOnly() {
        boolean isReadOnly = true;
        Iterator<ICommand> commands = this._commands.iterator();
        while (isReadOnly && commands.hasNext()) {
            ICommand command = commands.next();
            isReadOnly = command.isReadOnly();
        }
        return isReadOnly;
    }

    @Override
    public void run() {
        for (ICommand command : this._commands) {
            this.doRunContainedCommand(command);
        }
    }

    protected void doRunContainedCommand(ICommand aContainedCommand) {
        aContainedCommand.run();
    }
}

