/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.handlers.log;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.tools.report.util.LogExt;
import org.polarsys.capella.core.transition.common.handlers.log.ILogHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DefaultLogHandler
implements ILogHandler {
    protected Logger logger;
    protected List<TransitionMessage> logs;
    String reportComponent;

    public DefaultLogHandler(String reportComponent) {
        this.reportComponent = reportComponent;
    }

    @Override
    public IStatus init(IContext context) {
        this.logger = ReportManagerRegistry.getInstance().subscribe(this.reportComponent);
        this.logs = new ArrayList<TransitionMessage>();
        return Status.OK_STATUS;
    }

    @Override
    public void flush() {
        for (TransitionMessage message : this.logs) {
            this.log(message);
        }
        this.logs.clear();
    }

    @Override
    public IStatus dispose(IContext context) {
        this.flush();
        this.logs = null;
        return Status.OK_STATUS;
    }

    protected TransitionMessage createEmbeddedMessage(String message, String priority, Object relatedObjects, String source) {
        return new TransitionMessage(message, priority, relatedObjects, source);
    }

    protected TransitionMessage createEmbeddedMessage(String message, String priority, String source) {
        return new TransitionMessage(message, priority, source);
    }

    public void log(String message, String priority, Object relatedObjects, String source) {
        TransitionMessage transitionMessage = this.createEmbeddedMessage(message, priority, relatedObjects, source);
        this.logs.add(transitionMessage);
    }

    public void log(String message, String priority, String source) {
        TransitionMessage transitionMessage = this.createEmbeddedMessage(message, priority, source);
        this.logs.add(transitionMessage);
    }

    @Override
    public void log(String message, IStatus status, Object relatedObjects, String source) {
        String priority = this.toPriority(status);
        this.log(message, priority, relatedObjects, source);
    }

    @Override
    public void log(String message, IStatus status, String source) {
        String priority = this.toPriority(status);
        this.log(message, priority, source);
    }

    protected String toPriority(IStatus status) {
        return LogExt.toPriority((IStatus)status);
    }

    protected void log(TransitionMessage message) {
        this.logger.log((Priority)Level.toLevel((String)message.priority), (Object)message);
    }

    @Override
    public void debug(String message, Object relatedObjects, String source) {
        if (this.hasDebug()) {
            this.log(message, "DEBUG", relatedObjects, source);
        }
    }

    @Override
    public void debug(String message, String source) {
        if (this.hasDebug()) {
            this.log(message, "DEBUG", source);
        }
    }

    @Override
    public void info(String message, Object relatedObjects, String source) {
        if (this.hasInfo()) {
            this.log(message, "INFO", relatedObjects, source);
        }
    }

    @Override
    public void info(String message, String source) {
        if (this.hasInfo()) {
            this.log(message, "INFO", source);
        }
    }

    @Override
    public void warn(String message, Object relatedObjects, String source) {
        if (this.hasWarn()) {
            this.log(message, "WARN", relatedObjects, source);
        }
    }

    @Override
    public void warn(String message, String source) {
        if (this.hasWarn()) {
            this.log(message, "WARN", source);
        }
    }

    @Override
    public void error(String message, Object relatedObjects, String source) {
        if (this.hasError()) {
            this.log(message, "ERROR", relatedObjects, source);
        }
    }

    @Override
    public void error(String message, String source) {
        if (this.hasError()) {
            this.log(message, "ERROR", source);
        }
    }

    @Override
    public void fatal(String message, Object relatedObjects, String source) {
        if (this.hasFatal()) {
            this.log(message, "FATAL", relatedObjects, source);
        }
    }

    @Override
    public void fatal(String message, String source) {
        if (this.hasFatal()) {
            this.log(message, "FATAL", source);
        }
    }

    @Override
    public String getText(Object object) {
        if (object != null) {
            if (object instanceof EClass) {
                return ((EClass)object).getName();
            }
            if (object instanceof EObject) {
                return EObjectLabelProviderHelper.getText((Object)((EObject)object));
            }
            return object.toString();
        }
        return "null";
    }

    protected String getReadableText(EObject object) {
        return this.getText(object);
    }

    @Override
    public boolean hasDebug() {
        if (this.logger == null) {
            return false;
        }
        Level level = this.logger.getLevel();
        if (level == null) {
            return false;
        }
        return Level.DEBUG.isGreaterOrEqual((Priority)this.logger.getLevel());
    }

    @Override
    public boolean hasInfo() {
        if (this.logger == null) {
            return false;
        }
        Level level = this.logger.getLevel();
        if (level == null) {
            return false;
        }
        return Level.INFO.isGreaterOrEqual((Priority)this.logger.getLevel());
    }

    @Override
    public boolean hasWarn() {
        if (this.logger == null) {
            return false;
        }
        Level level = this.logger.getLevel();
        if (level == null) {
            return false;
        }
        return Level.WARN.isGreaterOrEqual((Priority)this.logger.getLevel());
    }

    @Override
    public boolean hasError() {
        if (this.logger == null) {
            return false;
        }
        Level level = this.logger.getLevel();
        if (level == null) {
            return true;
        }
        return Level.ERROR.isGreaterOrEqual((Priority)this.logger.getLevel());
    }

    @Override
    public boolean hasFatal() {
        if (this.logger == null) {
            return false;
        }
        Level level = this.logger.getLevel();
        if (level == null) {
            return true;
        }
        return Level.FATAL.isGreaterOrEqual((Priority)this.logger.getLevel());
    }

    @Override
    public void setLevel(Level level) {
        if (this.logger != null) {
            this.logger.setLevel(level);
        }
    }

    @Override
    public String getIdentifier(EObject me) {
        return me.eClass().getName();
    }

    protected class TransitionMessage
    extends EmbeddedMessage {
        String priority;

        public TransitionMessage(String message, String priority, String info) {
            super(message, info);
            this.priority = priority;
            this.setSource(info);
        }

        public TransitionMessage(String message, String priority, Object affectedObjects, String info) {
            super(message, info, affectedObjects);
            this.priority = priority;
            this.setSource(info);
        }
    }
}

