/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.handlers.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.transition.common.handlers.merge.CategorySet;
import org.polarsys.capella.core.transition.common.handlers.merge.ICategoryItem;
import org.polarsys.capella.core.transition.common.handlers.merge.ICategorySet;
import org.polarsys.capella.core.transition.common.handlers.merge.IMergeHandler;
import org.polarsys.capella.core.transition.common.handlers.merge.Messages;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DefaultMergeHandler
implements IMergeHandler {
    protected Collection<ICategorySet> categorySets = new LinkedList<ICategorySet>();
    protected Collection<ICategoryItem> categories = new LinkedList<ICategoryItem>();
    protected final boolean processTargetDifferences;

    public DefaultMergeHandler() {
        this(false);
    }

    public DefaultMergeHandler(boolean processTargetDifferences) {
        this.processTargetDifferences = processTargetDifferences;
    }

    @Override
    public void addCategorySet(ICategorySet set, IContext context) {
        this.categorySets.add(set);
    }

    @Override
    public void addCategory(ICategoryItem filter, IContext context) {
        this.categories.add(filter);
    }

    @Override
    public IStatus processDifferences(IContext context, Collection<IDifference<EObject>> diffSource, Collection<IDifference<EObject>> diffTarget) {
        Collection<IDifference<EObject>> differences = diffSource;
        if (this.processTargetDifferences) {
            differences = new ArrayList<IDifference<EObject>>(differences);
            differences.addAll(diffTarget);
        }
        EComparison comparison = (EComparison)context.get((Object)"MERGE_COMPARISON");
        this.mergeDifferences(comparison, this.filterDifferences(context, differences));
        return Status.OK_STATUS;
    }

    protected Collection<IDifference<EObject>> filterDifferences(IContext context, Collection<IDifference<EObject>> differences) {
        ArrayList<IDifference<EObject>> result = new ArrayList<IDifference<EObject>>();
        for (IDifference<EObject> difference : differences) {
            if (this.isFiltered(difference)) continue;
            result.add(difference);
        }
        return result;
    }

    protected void mergeDifferences(EComparison comparison, Collection<IDifference<EObject>> differences) {
        comparison.merge(differences, Role.TARGET, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isFiltered(IDifference<EObject> difference) {
        boolean globalFocus = false;
        boolean diffFocus = false;
        for (ICategoryItem category : this.categories) {
            if (!category.isActive()) continue;
            boolean catFocus = category.isInFocusMode();
            globalFocus = globalFocus || catFocus;
            boolean covered = category.covers(difference);
            if (!covered) continue;
            if (!catFocus) {
                return true;
            }
            diffFocus = true;
        }
        return globalFocus && !diffFocus;
    }

    @Override
    public IStatus init(IContext context) {
        this.categories = new LinkedList<ICategoryItem>();
        this.addCategorySet(new CategorySet("category.business", Messages.DefaultMergeHandler_CategoryBusiness_Name, Messages.DefaultMergeHandler_CategoryBusiness_Description), context);
        this.addCategorySet(new CategorySet("category.semantic", Messages.DefaultMergeHandler_CategorySemantic_Name, Messages.DefaultMergeHandler_CategorySemantic_Description), context);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus dispose(IContext context) {
        if (this.categories != null) {
            this.categories.clear();
            this.categories = null;
        }
        return Status.OK_STATUS;
    }

    @Override
    public Collection<ICategorySet> getCategoriesSet(IContext context) {
        return Collections.unmodifiableCollection(this.categorySets);
    }

    @Override
    public Collection<ICategoryItem> getCategories(IContext context) {
        return Collections.unmodifiableCollection(this.categories);
    }

    @Override
    public ICategoryItem getCategory(IContext context, String id) {
        for (ICategoryItem category : this.getCategories(context)) {
            String currentId = category.getId();
            if (currentId == null || !currentId.equals(id)) continue;
            return category;
        }
        return null;
    }
}

