/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.browser.category;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.mdsofa.common.misc.ExtensionClassDescriptor;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryImpl;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;
import org.polarsys.capella.common.ui.toolkit.browser.category.Messages;

public class CategoryRegistry {
    private static final String CONTENT_PROVIDER_CATEGORY = Messages.getString("CategoryRegistry.ContentProvider");
    protected static CategoryRegistry categoryRegistry;
    protected List<ICategory> categoriesCache = new ArrayList<ICategory>();
    protected HashMap<String, ICategory> currentElementRegistry;
    protected HashMap<String, ICategory> diagramElementRegistry;
    protected HashMap<String, ICategory> referencedElementRegistry;
    protected HashMap<String, ICategory> referencingElementRegistry;
    protected HashMap<String, ICategory> relatedElementsRegistry;
    private Collection<ExtensionClassDescriptor> availableForTypeClassDescriptors;

    private CategoryRegistry() {
        this.initRegistry();
    }

    public Set<ICategory> gatherCategories(String viewerId, EObject currentElement) {
        return this.gatherCategories(viewerId, currentElement, e -> !e.isTechnical());
    }

    public Set<ICategory> gatherCategories(String viewerId, EObject currentElement, Function<ICategory, Boolean> filter) {
        HashMap<String, ICategory> elementRegistry = this.getRegistry(viewerId);
        HashSet<ICategory> categories = new HashSet<ICategory>();
        Set<Map.Entry<String, ICategory>> entrySet = elementRegistry.entrySet();
        for (Map.Entry<String, ICategory> entry : entrySet) {
            ICategory category = entry.getValue();
            if (!category.isTopLevel() || !filter.apply(category).booleanValue() || !category.isAvailableForType(currentElement)) continue;
            categories.add(category);
        }
        this.removeOverriddenCategories(categories, currentElement);
        return categories;
    }

    private void removeOverriddenCategories(Set<ICategory> categories, EObject current) {
        Set overriddenCategories = categories.stream().filter(x -> categories.stream().anyMatch(y -> y != x && y.overrides((ICategory)x, current))).collect(Collectors.toSet());
        categories.removeAll(overriddenCategories);
    }

    public Set<ICategory> gatherFilteredCategories(EObject currentElement, Function<ICategory, Boolean> filter) {
        Set<ICategory> referencedCategories = this.gatherCategories("ReferencedElementBrowser", currentElement, filter);
        Set<ICategory> referencingCategories = this.gatherCategories("ReferencingElementBrowser", currentElement, filter);
        Set<ICategory> currentCategories = this.gatherCategories("CurrentElementBrowser", currentElement, filter);
        HashSet<ICategory> categories = new HashSet<ICategory>();
        categories.addAll(referencedCategories);
        categories.addAll(referencingCategories);
        categories.addAll(currentCategories);
        return categories;
    }

    public Set<ICategory> gatherCategories(EObject currentElement) {
        return this.gatherFilteredCategories(currentElement, e -> !e.isTechnical());
    }

    public List<ICategory> gatherSubCategories(String viewerId, EObject currentElement, ICategory category) {
        HashMap<String, ICategory> elementRegistry = this.getRegistry(viewerId);
        ArrayList<ICategory> subCategories = new ArrayList<ICategory>();
        for (String subCategoryId : category.getSubCategoryIds()) {
            ICategory subCategory = elementRegistry.get(subCategoryId);
            if (subCategory == null || !subCategory.isAvailableForType(currentElement)) continue;
            subCategories.add(subCategory);
        }
        return subCategories;
    }

    public List<ICategory> gatherRelatedElementsCategories(EObject currentElement) {
        return this.relatedElementsRegistry.values().stream().filter(category -> category.isTopLevel() && category.isAvailableForType(currentElement)).collect(Collectors.toList());
    }

    public Set<ICategory> gatherTechnicalCategories(String viewerId, EObject currentElement) {
        HashMap<String, ICategory> elementRegistry = this.getRegistry(viewerId);
        HashSet<ICategory> categories = new HashSet<ICategory>();
        Set<Map.Entry<String, ICategory>> entrySet = elementRegistry.entrySet();
        for (Map.Entry<String, ICategory> entry : entrySet) {
            ICategory category = entry.getValue();
            if (!category.isTopLevel() || !category.isAvailableForType(currentElement) || !category.isTechnical()) continue;
            categories.add(category);
        }
        this.removeOverriddenCategories(categories, currentElement);
        return categories;
    }

    protected HashMap<String, ICategory> getRegistry(String viewerId) {
        if (viewerId.equalsIgnoreCase("CurrentElementBrowser")) {
            return this.currentElementRegistry;
        }
        if (viewerId.equalsIgnoreCase("ReferencedElementBrowser")) {
            return this.referencedElementRegistry;
        }
        if (viewerId.equalsIgnoreCase("ReferencingElementBrowser")) {
            return this.referencingElementRegistry;
        }
        return this.diagramElementRegistry;
    }

    public ICategory getCategory(String categoryId) {
        ICategory category = null;
        if (this.getRegistry("ReferencedElementBrowser").containsKey(categoryId)) {
            category = this.getRegistry("ReferencedElementBrowser").get(categoryId);
        } else if (this.getRegistry("ReferencingElementBrowser").containsKey(categoryId)) {
            category = this.getRegistry("ReferencingElementBrowser").get(categoryId);
        } else if (this.getRegistry("CurrentElementBrowser").containsKey(categoryId)) {
            category = this.getRegistry("CurrentElementBrowser").get(categoryId);
        }
        return category;
    }

    private void initRegistry() {
        IConfigurationElement[] categories;
        this.currentElementRegistry = new HashMap();
        this.referencedElementRegistry = new HashMap();
        this.referencingElementRegistry = new HashMap();
        this.diagramElementRegistry = new HashMap();
        this.relatedElementsRegistry = new HashMap();
        this.availableForTypeClassDescriptors = new HashSet<ExtensionClassDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = categories = ExtensionPointHelper.getConfigurationElements((String)"org.polarsys.capella.common.ui.toolkit.browser", (String)CONTENT_PROVIDER_CATEGORY);
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] targetBrowserIdNode;
            IConfigurationElement[] typeConfigurationElement;
            IConfigurationElement[] queryConfigurationElements;
            IConfigurationElement[] itemQueriesNode;
            IConfigurationElement[] subCategoriesNodes;
            IConfigurationElement categoryConfigurationElement = iConfigurationElementArray[n2];
            CategoryImpl category = new CategoryImpl();
            String categoryId = categoryConfigurationElement.getAttribute("id");
            category.setId(categoryId);
            String categoryName = categoryConfigurationElement.getAttribute("name");
            category.setName(categoryName);
            String isTopLevelCategory = categoryConfigurationElement.getAttribute(Messages.getString("CategoryRegistry.TopLevel"));
            if (isTopLevelCategory != null) {
                category.setIsTopLevel(Boolean.parseBoolean(isTopLevelCategory));
            } else {
                category.setIsTopLevel(false);
            }
            String isTechnicalCategory = categoryConfigurationElement.getAttribute(Messages.getString("CategoryRegistry.Technical"));
            if (isTechnicalCategory != null) {
                category.setIsTechnical(Boolean.parseBoolean(isTechnicalCategory));
            } else {
                category.setIsTechnical(false);
            }
            String usedInShowRelated = categoryConfigurationElement.getAttribute(Messages.getString("CategoryRegistry.UsedInShowRelated"));
            if (usedInShowRelated != null) {
                boolean isUsedInShowRelated = Boolean.parseBoolean(usedInShowRelated);
                category.setIsUsedInShowRelated(isUsedInShowRelated);
                if (isUsedInShowRelated) {
                    this.relatedElementsRegistry.put(categoryId, category);
                }
            } else {
                category.setIsUsedInShowRelated(false);
            }
            if ((subCategoriesNodes = categoryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.SubCategory"))).length > 0) {
                IConfigurationElement[] subCategoryConfigurationElements;
                IConfigurationElement[] iConfigurationElementArray2 = subCategoryConfigurationElements = subCategoriesNodes[0].getChildren(Messages.getString("CategoryRegistry.Category"));
                int n3 = subCategoryConfigurationElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement subCategoryConfigurationElement = iConfigurationElementArray2[n4];
                    category.addSubCategoryId(subCategoryConfigurationElement.getAttribute("id"));
                    ++n4;
                }
            }
            if ((itemQueriesNode = categoryConfigurationElement.getChildren(Messages.getString("ItemQueries"))).length > 0) {
                IConfigurationElement[] itemQueries = itemQueriesNode[0].getChildren(Messages.getString("basicQuery"));
                List<IConfigurationElement> basicQueryCollection = Arrays.asList(itemQueries);
                List<IConfigurationElement> navigationQueryCollection = Arrays.asList(itemQueriesNode[0].getChildren(Messages.getString("CategoryRegistry.NavigationQuery")));
                basicQueryCollection.addAll(navigationQueryCollection);
                basicQueryCollection.forEach(itemQueryConfigurationElement -> {
                    Object queryInstance = ExtensionPointHelper.createInstance((IConfigurationElement)itemQueryConfigurationElement, (String)"class");
                    category.addItemQuery(queryInstance);
                });
            }
            if ((queryConfigurationElements = categoryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.CategoryQuery"))).length > 0) {
                Object query = null;
                IConfigurationElement queryConfigurationElement = queryConfigurationElements[0];
                IConfigurationElement[] categoryQueries = queryConfigurationElement.getChildren(Messages.getString("basicQuery"));
                if (categoryQueries.length == 0) {
                    categoryQueries = queryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.NavigationQuery"));
                }
                if (categoryQueries.length > 0) {
                    query = ExtensionPointHelper.createInstance((IConfigurationElement)categoryQueries[0], (String)"class");
                }
                category.setQuery(query);
            }
            if ((typeConfigurationElement = categoryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.AvailableForType"))).length > 0) {
                String qualifiedClassName = typeConfigurationElement[0].getAttribute("class");
                category.setTypeFullyQualifiedName(qualifiedClassName);
                this.availableForTypeClassDescriptors.add(new ExtensionClassDescriptor(typeConfigurationElement[0]));
            }
            if ((targetBrowserIdNode = categoryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.TargetBrowserId"))).length > 0) {
                IConfigurationElement browserIdConfigurationElement = targetBrowserIdNode[0];
                String id = browserIdConfigurationElement.getAttribute("id");
                if (id.equalsIgnoreCase("CurrentElementBrowser")) {
                    this.currentElementRegistry.put(categoryId, category);
                } else if (id.equalsIgnoreCase("ReferencingElementBrowser")) {
                    this.referencingElementRegistry.put(categoryId, category);
                } else if (id.equalsIgnoreCase("ReferencedElementBrowser")) {
                    this.referencedElementRegistry.put(categoryId, category);
                } else {
                    this.diagramElementRegistry.put(categoryId, category);
                }
            }
            ++n2;
        }
    }

    public Collection<ExtensionClassDescriptor> getAvailableForTypeClassDescriptors() {
        return this.availableForTypeClassDescriptors;
    }

    public static CategoryRegistry getInstance() {
        if (categoryRegistry == null) {
            categoryRegistry = new CategoryRegistry();
        }
        return categoryRegistry;
    }
}

