/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.commandline.ju.testcases;

import java.io.File;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplicationContext;
import org.polarsys.capella.core.sirius.ui.commandline.RemoveHiddenElementsCommandLine;
import org.polarsys.capella.test.commandline.ju.utils.MockApplicationContext;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.api.ModelProviderHelper;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.log.StatusValidator;

public class CommandLineRemoveHiddenElementsTest
extends BasicTestCase {
    public void test() {
        String projectName = "RefreshRemoveExport";
        File sourceFolder = this.getFolderInTestModelRepository(projectName);
        ModelProviderHelper.getInstance().importCapellaProject(projectName, sourceFolder);
        try {
            StatusValidator removeSomething = new StatusValidator(s -> s.getMessage().contains("diagram(s) updated"));
            Platform.addLogListener((ILogListener)removeSomething);
            this.removeElements(projectName);
            Platform.removeLogListener((ILogListener)removeSomething);
            CommandLineRemoveHiddenElementsTest.assertTrue((String)"Remove hidden elements shall have removed something", (boolean)removeSomething.isValid());
        }
        catch (Exception e) {
            CommandLineRemoveHiddenElementsTest.assertFalse((String)e.getMessage(), (boolean)true);
        }
        try {
            StatusValidator removeNothing = new StatusValidator(s -> s.getMessage().contains("Nothing to do"));
            Platform.addLogListener((ILogListener)removeNothing);
            this.removeElements(projectName);
            Platform.removeLogListener((ILogListener)removeNothing);
            CommandLineRemoveHiddenElementsTest.assertTrue((String)"Remove hidden elements shall have removed nothing", (boolean)removeNothing.isValid());
        }
        catch (Exception e) {
            e.printStackTrace();
            CommandLineRemoveHiddenElementsTest.assertFalse((String)e.getMessage(), (boolean)true);
        }
    }

    private void removeElements(String project) throws Exception {
        String[] arguments = new String[]{"-appid", "org.polarsys.capella.removeHiddenElements", "-input", String.valueOf(project) + "/" + project + ".aird", "-outputfolder", String.valueOf(project) + "/output", "-forceoutputfoldercreation"};
        MockApplicationContext mockApplicationContext = new MockApplicationContext(arguments);
        RemoveHiddenElementsCommandLine commandLine = new RemoveHiddenElementsCommandLine();
        commandLine.parseContext((IApplicationContext)mockApplicationContext);
        commandLine.checkArgs((IApplicationContext)mockApplicationContext);
        commandLine.prepare((IApplicationContext)mockApplicationContext);
        commandLine.execute((IApplicationContext)mockApplicationContext);
        GuiActions.flushASyncGuiJobs();
    }
}

