/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju;

import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.polarsys.capella.test.diagram.common.ju.headless.HeadlessJavaActionsProvider;

public class TestDiagramCommonPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.polarsys.capella.test.diagram.common.ju";
    private static TestDiagramCommonPlugin plugin;
    private boolean externalJavaActionReseted = false;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Bundle siriusBundle = SiriusPlugin.getDefault().getBundle();
        this.addStartedListener(siriusBundle);
        if (siriusBundle.getState() == 32) {
            this.resetExternalJavaAction();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    protected void addStartedListener(final Bundle bundle) {
        bundle.getBundleContext().addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle().equals(bundle)) {
                    switch (event.getType()) {
                        case 2: 
                        case 8: 
                        case 512: {
                            TestDiagramCommonPlugin.this.resetExternalJavaAction();
                            break;
                        }
                    }
                }
            }
        });
    }

    protected synchronized void resetExternalJavaAction() {
        if (!this.externalJavaActionReseted) {
            new HeadlessJavaActionsProvider().init();
            this.externalJavaActionReseted = true;
        }
    }

    public static TestDiagramCommonPlugin getDefault() {
        return plugin;
    }
}

