/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.Parameter;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.Service;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeWithSelectionTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateNodeElementTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.ReconnectTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CDBDiagram
extends CommonDiagram {
    public CDBDiagram(SessionContext context, DDiagram diagram) {
        super(context, diagram);
    }

    public static CDBDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        return (CDBDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, "Class Diagram Blank"){

            @Override
            public DiagramContext getResult() {
                return new CDBDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static CDBDiagram openDiagram(SessionContext executionContext, String name) {
        return (CDBDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new CDBDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public String createDataPackage() {
        return this.createDataPackage(this.getDiagramId());
    }

    public String createDataPackage(String containerId) {
        return this.createContainerElement(containerId, "data.package");
    }

    public String createClass() {
        return this.createClass(this.getDiagramId());
    }

    public String createClass(String containerId) {
        return this.createContainerElement(containerId, "class");
    }

    public String createUnion() {
        return this.createUnion(this.getDiagramId());
    }

    public String createUnion(String containerId) {
        return this.createContainerElement(containerId, "union");
    }

    public String createCollection() {
        return this.createCollection(this.getDiagramId());
    }

    public String createCollection(String containerId) {
        return this.createContainerElement(containerId, "collection");
    }

    public String createNodeDataType(DataType dataType) {
        return this.createNodeElement(this.getDiagramId(), this.getDataTypeName(dataType));
    }

    public String createDataType(DataType dataType) {
        return this.createContainerElement(this.getDiagramId(), this.getDataTypeName(dataType));
    }

    public String createDataLiteral(String containerId, DataLiteral literal) {
        return this.createNodeListElement(containerId, this.getDataLiteralName(literal));
    }

    public String createReference(ReferenceType reference) {
        return this.createNodeElement(this.getDiagramId(), this.getReferenceName(reference));
    }

    public String createProperty(String containerId, String dataTypeId) {
        DNodeListElement graphicalElement = (DNodeListElement)new CreateAbstractDNodeWithSelectionTool<DNodeListElement>(this, "property", containerId, containerId, dataTypeId, DNodeListElement.class, Property.class).run();
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    public String createOperation(String containerId) {
        return this.createNodeListElement(containerId, "class.operation");
    }

    public void createParameter(String containerId, String dataTypeId) {
        new CreateParameterTool(this, "parameter", containerId, containerId, dataTypeId).run();
    }

    public String createRelationship(String sourceId, String targetId, RelationshipType relationship) {
        return this.createEdgeElement(sourceId, targetId, this.getRelationshipName(relationship));
    }

    public String createCollectionType(String sourceId, String targetId) {
        DEdge graphicalElement = (DEdge)new CreateCollectionTypeTool(this, "collection.type", sourceId, targetId).run();
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    public void reconnectRelationshipSource(String id, String oldSourceId, String newSourceId, RelationshipType relationship) {
        new ReconnectTool(this, this.getReconnectSourceRelationshipName(relationship), id, oldSourceId, newSourceId).run();
    }

    public void reconnectRelationshipTarget(String id, String oldTargetId, String newTargetId, RelationshipType relationship) {
        new ReconnectTool(this, this.getReconnectTargetRelationshipName(relationship), id, oldTargetId, newTargetId).run();
    }

    public void cannotReconnectRelationshipSource(String id, String oldSourceId, String newSourceId, RelationshipType relationship) {
        new ReconnectTool(this, this.getReconnectSourceRelationshipName(relationship), id, oldSourceId, newSourceId).shouldFail();
    }

    public void cannotReconnectRelationshipTarget(String id, String oldTargetId, String newTargetId, RelationshipType relationship) {
        new ReconnectTool(this, this.getReconnectTargetRelationshipName(relationship), id, oldTargetId, newTargetId).shouldFail();
    }

    public String createInterfacePackage() {
        return this.createInterfacePackage(this.getDiagramId());
    }

    public String createInterfacePackage(String containerId) {
        return this.createContainerElement(containerId, "interface.package");
    }

    public String createInterface() {
        return this.createInterface(this.getDiagramId());
    }

    public String createInterface(String containerId) {
        return this.createContainerElement(containerId, "interface");
    }

    public String createNodeExchangeItem(ExchangeItemType eiType) {
        return this.createNodeExchangeItem(this.getDiagramId(), eiType);
    }

    public String createNodeExchangeItem(String containerId, ExchangeItemType eiType) {
        return this.createNodeElement(containerId, this.getExchangeItemName(eiType));
    }

    public String createExchangeItem(ExchangeItemType eiType) {
        return this.createExchangeItemNode(this.getDiagramId(), eiType);
    }

    public String createExchangeItemNode(String containerId, ExchangeItemType eiType) {
        return this.createNodeElement(containerId, this.getExchangeItemName(eiType));
    }

    public String createExchangeItem(String containerId, ExchangeItemType eiType) {
        return this.createNodeListElement(containerId, this.getExchangeItemName(eiType));
    }

    public String createExchangeItemElement(String sourceId, String targetId) {
        DEdge graphicalElement = (DEdge)new CreateExchangeItemElementTool(this, "exchange.item.element", sourceId, targetId).run();
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    public void removeDataPkg(String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "data.packages").remove(ids);
    }

    public void insertDataPkg(String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "data.packages").insert(ids);
    }

    public void removeType(String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "types").remove(ids);
    }

    public void insertType(String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "types").insert(ids);
    }

    public void removeDataValue(String container, String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "Show/Hide DataValues", container).remove(ids);
    }

    public void insertDataValue(String container, String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "Show/Hide DataValues", container).insert(ids);
    }

    public void removeDataValues(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "data.values", containerId).remove(id);
    }

    public void insertDataValues(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "data.values", containerId).insert(id);
    }

    public void removeRelationship(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "relationships", containerId).remove(id);
    }

    public void insertRelationship(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "relationships", containerId).insert(id);
    }

    public void removeProperty(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "properties", containerId).remove(id);
    }

    public void insertProperty(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "properties", containerId).insert(id);
    }

    public void removeOperation(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "operations", containerId).remove(id);
    }

    public void insertOperation(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "operations", containerId).insert(id);
    }

    public void removeInterfacePkg(String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "interface.packages").remove(ids);
    }

    public void insertInterfacePkg(String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "interface.packages").insert(ids);
    }

    public void removeInterface(String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "interfaces").remove(ids);
    }

    public void insertInterface(String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "interfaces").insert(ids);
    }

    public void removeExchangeItem(String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "exchange.items").remove(ids);
    }

    public void insertExchangeItem(String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "exchange.items").insert(ids);
    }

    public void removeExchangeItemAllocations(String containerId, String ... ids) {
        new ManageExchangeItemAllocationTools(this, "manage.exchange.item.allocations", containerId).remove(ids);
    }

    public void insertExchangeItemAllocations(String containerId, String ... ids) {
        new ManageExchangeItemAllocationTools(this, "manage.exchange.item.allocations", containerId).insert(ids);
    }

    public void insertExchangeItemElement(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "exchange.item.element.links", containerId).insert(id);
    }

    public void removeExchangeItemElement(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "exchange.item.element.links", containerId).remove(id);
    }

    public void dragAndDropDataTypeFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D DataType From Project Explorer");
    }

    public void dragAndDropBooleanTypeFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D BooleanType From Project Explorer");
    }

    public void dragAndDropClassFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Class From Project Explorer");
    }

    public void dragAndDropCollectionFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Collection From Project Explorer");
    }

    public void dragAndDropEnumerationFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Enumeration From Project Explorer");
    }

    @Override
    public void dragAndDropConstraintFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Constraint From Project Explorer");
    }

    public void dragAndDropDataPkgFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D DataPkg From Project Explorer");
    }

    public void dragAndDropUnitFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Unit from Project Explorer");
    }

    public void dragAndDropClassIntoDataPkg(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "Class Into DataPkg");
    }

    public void dragAndDropCollectionIntoDataPkg(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "Collection Into DataPkg");
    }

    public void dragAndDropDataTypeIntoDataPkg(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "DataType Into DataPkg");
    }

    public void dragAndDropDataPkgIntoDataPkg(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "DataPkg Into DataPkg");
    }

    public void dragAndDropDataValueFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D DataValue From Project Explorer");
    }

    public void dragAndDropDataValueIntoDataPkg(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "DataValue Into DataPkg");
    }

    public void dragAndDropDataValueIntoClass(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "DataValue Into Class");
    }

    public void dragAndDropUnitIntoDataPkg(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "Unit Into DataPkg");
    }

    public void dragAndDropInterfaceFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Interface From Project Explorer");
    }

    public void dragAndDropExchangeItemFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D ExchangeItem From Project Explorer");
    }

    public void dragAndDropInterfacePkgFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D InterfacePkg From Project Explorer");
    }

    public void dragAndDropInterfaceIntoInterfacePkg(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "Interface Into InterfacePkg");
    }

    public void dragAndDropExchangeItemIntoInterfacePkg(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "AbstractExchangeItem Into AbstractExchangeItemPkg");
    }

    public void dragAndDropInterfacePkgIntoInterfacePkg(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "InterfacePkg Into InterfacePkg");
    }

    public void dragAndDropComponentFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D DataType From Project Explorer");
    }

    private String getDataTypeName(DataType dataType) {
        switch (dataType) {
            case BOOLEAN_TYPE: {
                return "boolean.type";
            }
            case ENUMERATION: {
                return "enumeration";
            }
            case NUMERIC_TYPE: {
                return "numeric.type";
            }
            case STRING_TYPE: {
                return "string.type";
            }
            case PHYSICAL_QUANTITY: {
                return "physical.quantity";
            }
            case UNIT: {
                return "unit";
            }
        }
        return null;
    }

    private String getDataLiteralName(DataLiteral literal) {
        switch (literal) {
            case BOOLEAN_LITERAL: {
                return "boolean.literal";
            }
            case ENUMERATION_LITERAL: {
                return "enumeration.literal";
            }
        }
        return null;
    }

    private String getReferenceName(ReferenceType reference) {
        switch (reference) {
            case NUMERIC_REFERENCE: {
                return "numeric.reference";
            }
            case LITERAL_NUMERIC_VALUE: {
                return "literal.numeric.value";
            }
            case UNARY_EXPRESSION: {
                return "unary.expression";
            }
            case BINARY_EXPRESSION: {
                return "binary.expression";
            }
            case LITERAL_STRING_VALUE: {
                return "literal.string.value";
            }
            case STRING_REFERENCE: {
                return "string.reference";
            }
            case BOOLEAN_REFERENCE: {
                return "boolean.reference";
            }
            case COMPLEX_VALUE: {
                return "complex.value";
            }
            case COMPLEX_VALUE_REFERENCE: {
                return "complex.value.reference";
            }
            case ENUMERATION_REFERENCE: {
                return "enumeration.reference";
            }
            case COLLECTION_VALUE: {
                return "collection.value";
            }
            case COLLECTION_VALUE_REFERENCE: {
                return "collection.value.reference";
            }
        }
        return "";
    }

    private String getRelationshipName(RelationshipType relationship) {
        switch (relationship) {
            case ASSOCIATION: {
                return "association";
            }
            case AGGREGATION: {
                return "aggregation";
            }
            case COMPOSITION: {
                return "composition";
            }
            case GENERALIZATION: {
                return "generalization";
            }
        }
        return null;
    }

    private String getReconnectSourceRelationshipName(RelationshipType relationship) {
        switch (relationship) {
            case ASSOCIATION: {
                return "CB Reconnect Association Source";
            }
            case GENERALIZATION: {
                return "CB Reconnect Generalization Source";
            }
            case COLLECTION_TYPE: {
                return "CB Reconnect Collection Type";
            }
        }
        return null;
    }

    private String getReconnectTargetRelationshipName(RelationshipType relationship) {
        switch (relationship) {
            case ASSOCIATION: {
                return "CB Reconnect Association Target";
            }
            case GENERALIZATION: {
                return "CB Reconnect Generalization Target";
            }
            case COLLECTION_TYPE: {
                return "CB Reconnect Collection Type";
            }
        }
        return null;
    }

    private String getExchangeItemName(ExchangeItemType eiType) {
        switch (eiType) {
            case EVENT: {
                return "event";
            }
            case OPERATION: {
                return "operation";
            }
            case FLOW: {
                return "flow";
            }
            case DATA: {
                return "data";
            }
            case UNDEFINED: {
                return "undefined.exchange.item";
            }
        }
        return null;
    }

    @Deprecated
    public void createAssociation(String classSourceId, String classTargetId, String id) {
        new CreateDEdgeTool(this, "association", classSourceId, classTargetId, id).run();
    }

    @Deprecated
    public void createEnumeration(String id) {
        new CreateContainerTool((DiagramContext)this, "enumeration", this.getDiagramId(), id).run();
    }

    @Deprecated
    public void createEnumerationLiteral(String id, String containerId) {
        new CreateNodeElementTool((DiagramContext)this, "enumeration.literal", containerId, id).run();
    }

    @Deprecated
    public void createBooleanType(String id) {
        new CreateContainerTool((DiagramContext)this, "boolean.type", this.getDiagramId(), id).run();
    }

    @Deprecated
    public void createLiteralBooleanValue(String id, String containerId) {
        new CreateNodeElementTool((DiagramContext)this, "boolean.literal", containerId, id).run();
    }

    protected class CreateCollectionTypeTool
    extends CreateDEdgeTool {
        public CreateCollectionTypeTool(DiagramContext context, String toolName, String sourceViewId, String targetViewId) {
            super(context, toolName, sourceViewId, targetViewId);
        }

        @Override
        protected void postRunTest() {
            super.postRunTest();
            Assert.assertTrue((this._newEdgesElements.size() == 1 ? 1 : 0) != 0);
            Collection collection = (Collection)((DDiagramElement)this._newEdgesElements.iterator().next()).getTarget();
            Assert.assertTrue((boolean)collection.getId().equals(this._sourceView));
            Assert.assertTrue((boolean)collection.getType().getId().equals(this._targetView));
        }
    }

    protected class CreateExchangeItemElementTool
    extends CreateDEdgeTool {
        public CreateExchangeItemElementTool(DiagramContext context, String toolName, String sourceViewId, String targetViewId) {
            super(context, toolName, sourceViewId, targetViewId);
        }

        @Override
        protected void postRunTest() {
            super.postRunTest();
            Assert.assertTrue((this._newEdgesElements.size() == 1 ? 1 : 0) != 0);
            ExchangeItemElement eiElement = (ExchangeItemElement)((DDiagramElement)this._newEdgesElements.iterator().next()).getTarget();
            ExchangeItem ei = (ExchangeItem)this.getExecutionContext().getSemanticElement(this._sourceView);
            Assert.assertTrue((boolean)ei.getOwnedElements().contains((Object)eiElement));
            Assert.assertTrue((boolean)eiElement.getType().getId().equals(this._targetView));
        }
    }

    protected class CreateParameterTool
    extends CreateAbstractDNodeWithSelectionTool<DNodeListElement> {
        protected List<Parameter> ownedParameters;
        protected Service service;

        public CreateParameterTool(DiagramContext context, String toolName, String targetContainerId, String containerId, String selectedId) {
            super(context, toolName, targetContainerId, containerId, selectedId, null, null);
        }

        @Override
        protected void preRunTest() {
            super.preRunTest();
            DSemanticDecorator element = this.getContainerView();
            Assert.assertTrue((boolean)(element.getTarget() instanceof Service));
            this.service = (Service)element.getTarget();
            this.ownedParameters = new ArrayList<Parameter>();
            this.ownedParameters.addAll((java.util.Collection<Parameter>)this.service.getOwnedParameters());
        }

        @Override
        protected void postRunTest() {
            ArrayList newOwnedParameters = new ArrayList();
            newOwnedParameters.addAll(this.service.getOwnedParameters());
            newOwnedParameters.removeAll(this.ownedParameters);
            Assert.assertTrue((newOwnedParameters.size() == 1 ? 1 : 0) != 0);
        }

        @Override
        public DNodeListElement getResult() {
            return null;
        }
    }

    public static enum DataLiteral {
        BOOLEAN_LITERAL,
        ENUMERATION_LITERAL;

    }

    public static enum DataType {
        BOOLEAN_TYPE,
        BOOLEAN_LITERAL,
        ENUMERATION,
        ENUMERATION_LITERAL,
        NUMERIC_TYPE,
        STRING_TYPE,
        PHYSICAL_QUANTITY,
        UNIT;

    }

    public static enum ExchangeItemType {
        EVENT,
        OPERATION,
        FLOW,
        DATA,
        UNDEFINED;

    }

    protected class ManageExchangeItemAllocationTools
    extends InsertRemoveTool {
        Interface interf;
        ArrayList<ExchangeItemAllocation> ownedEIAllocations;

        public ManageExchangeItemAllocationTools(DiagramContext context, String toolName, String containerId) {
            super(context, toolName, containerId);
        }

        @Override
        protected void preRunTest() {
            super.preRunTest();
            DSemanticDecorator element = this.getDiagramContext().getView(this.containerId);
            Assert.assertTrue((boolean)(element.getTarget() instanceof Interface));
            this.interf = (Interface)element.getTarget();
            this.ownedEIAllocations = new ArrayList();
            this.ownedEIAllocations.addAll((java.util.Collection<ExchangeItemAllocation>)this.interf.getOwnedExchangeItemAllocations());
        }

        @Override
        protected void checkPreconditions() {
        }

        @Override
        protected void postRunTest() {
            String id;
            ArrayList insertedEIAllocations = new ArrayList();
            insertedEIAllocations.addAll(this.interf.getOwnedExchangeItemAllocations());
            insertedEIAllocations.removeAll(this.ownedEIAllocations);
            ArrayList<ExchangeItemAllocation> removedEIAllocations = new ArrayList<ExchangeItemAllocation>();
            removedEIAllocations.addAll(this.ownedEIAllocations);
            removedEIAllocations.removeAll((java.util.Collection<?>)this.interf.getOwnedExchangeItemAllocations());
            String[] stringArray = this.insertedElements;
            int n = this.insertedElements.length;
            int n2 = 0;
            while (n2 < n) {
                id = stringArray[n2];
                Assert.assertTrue((boolean)insertedEIAllocations.stream().anyMatch(x -> x.getAllocatedItem().getId().equals(id)));
                ++n2;
            }
            stringArray = this.removedElements;
            n = this.removedElements.length;
            n2 = 0;
            while (n2 < n) {
                id = stringArray[n2];
                Assert.assertTrue((boolean)removedEIAllocations.stream().anyMatch(x -> x.getAllocatedItem().getId().equals(id)));
                ++n2;
            }
        }
    }

    public static enum ReferenceType {
        NUMERIC_REFERENCE,
        LITERAL_NUMERIC_VALUE,
        UNARY_EXPRESSION,
        BINARY_EXPRESSION,
        LITERAL_STRING_VALUE,
        STRING_REFERENCE,
        BOOLEAN_REFERENCE,
        COMPLEX_VALUE,
        COMPLEX_VALUE_REFERENCE,
        ENUMERATION_REFERENCE,
        COLLECTION_VALUE,
        COLLECTION_VALUE_REFERENCE;

    }

    public static enum RelationshipType {
        ASSOCIATION,
        AGGREGATION,
        COMPOSITION,
        GENERALIZATION,
        COLLECTION_TYPE;

    }
}

