/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.DeleteElementTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.DragAndDropFromProjectExplorerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.DragAndDropTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.SelectTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks.CreateDiagramTitleBlockTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks.CreateElementTitleBlockTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks.InsertColumnInTitleBlockTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks.InsertLineInTitleBlockTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks.InsertRemoveTitleBlockTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks.RemoveColumnFromTitleBlockTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks.RemoveLineFromTitleBlockTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CommonDiagram
extends DiagramContext {
    public CommonDiagram(SessionContext context, DDiagram diagram) {
        super(context, diagram);
    }

    public String createConstraint(String id) {
        return this.createConstraint(id, this.getDiagramId());
    }

    public String createConstraint(String id, String containerId) {
        String name = "constraint";
        DNode createdConstraint = (DNode)new CreateAbstractDNodeTool((DiagramContext)this, name, containerId, id).run();
        return this.getSemanticIdFromView((DDiagramElement)createdConstraint);
    }

    public DDiagramElement createDiagramTitleBlock() {
        DDiagramElementContainer createdTB = (DDiagramElementContainer)new CreateDiagramTitleBlockTool((DiagramContext)this, "title.block", this.getDiagramId()).run();
        return createdTB;
    }

    public DDiagramElement createElementTitleBlock(String containerId) {
        DDiagramElementContainer createdTB = (DDiagramElementContainer)new CreateElementTitleBlockTool((DiagramContext)this, "title.block", containerId, this.getDiagramId()).run();
        return createdTB;
    }

    public void checkCreateElementTitleBlock(String containerId) {
        new CreateElementTitleBlockTool((DiagramContext)this, "title.block", containerId, this.getDiagramId()).contextOk();
    }

    public void checkCreateDiagramTitleBlock() {
        new CreateDiagramTitleBlockTool((DiagramContext)this, "title.block", this.getDiagramId()).contextOk();
    }

    public void checkAutocreateDiagramTitleBlock() {
        new CreateDiagramTitleBlockTool((DiagramContext)this, "title.block", this.getDiagramId()).checkAutocreate();
    }

    public void removeElementTitleBlock(String id) {
        new InsertRemoveTitleBlockTool((DiagramContext)this, "title.blocks").remove(id);
    }

    public void insertElementTitleBlock(String id) {
        new InsertRemoveTitleBlockTool((DiagramContext)this, "title.blocks").insert(id);
    }

    public void removeDiagramTitleBlock(String id) {
        new InsertRemoveTitleBlockTool((DiagramContext)this, "title.blocks").remove(id);
    }

    public void insertDiagramTitleBlock(String id) {
        new InsertRemoveTitleBlockTool((DiagramContext)this, "title.blocks").insert(id);
    }

    public DAnnotation insertLineInTitleBlock(DAnnotation titleBlock, int lineNo) {
        DDiagramElementContainer createdTB = (DDiagramElementContainer)new InsertLineInTitleBlockTool((DiagramContext)this, "title.block.line", this.getDiagramId(), titleBlock, lineNo).run();
        return (DAnnotation)createdTB.getTarget();
    }

    public DAnnotation insertColumnInTitleBlock(DAnnotation titleBlock, int colNo) {
        DDiagramElementContainer createdTB = (DDiagramElementContainer)new InsertColumnInTitleBlockTool((DiagramContext)this, "title.block.column", this.getDiagramId(), titleBlock, colNo).run();
        return (DAnnotation)createdTB.getTarget();
    }

    public DAnnotation removeLineFromTitleBlock(DAnnotation titleBlock, int lineNo) {
        DDiagramElementContainer createdTB = (DDiagramElementContainer)new RemoveLineFromTitleBlockTool((DiagramContext)this, "remove.title.block.line", this.getDiagramId(), titleBlock, lineNo).run();
        return (DAnnotation)createdTB.getTarget();
    }

    public DAnnotation removeColumnFromTitleBlock(DAnnotation titleBlock, int colNo) {
        DDiagramElementContainer createdTB = (DDiagramElementContainer)new RemoveColumnFromTitleBlockTool((DiagramContext)this, "remove.title.block.column", this.getDiagramId(), titleBlock, colNo).run();
        return (DAnnotation)createdTB.getTarget();
    }

    public void deleteSemantic(DDiagramElement view) {
        new DeleteElementTool(this).delete(view);
    }

    public void deleteAllSemantic() {
        new DeleteElementTool(this).deleteAll();
    }

    public void createConstrainedElement(String sourceId, String targetId) {
        String name = "constraint.element";
        new CreateDEdgeTool(this, name, sourceId, targetId).run();
    }

    public void removeConstraint(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "constraints", containerId).remove(id);
    }

    public void insertConstraint(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "constraints", containerId).insert(id);
    }

    public void insertPV(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "applied.property.values", containerId).insert(id);
    }

    public void removePV(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "applied.property.values", containerId).remove(id);
    }

    public void insertPVG(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "applied.property.value.groups", containerId).insert(id);
    }

    public void removePVG(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "applied.property.value.groups", containerId).remove(id);
    }

    public void selectSameType(String id) {
        new SelectTool(this, "select.elements.of.same.type").ensurePrecondition(true).select(id);
    }

    public void selectSameMapping(String id) {
        new SelectTool(this, "select.resembling.elements").ensurePrecondition(true).select(id);
    }

    public void selectOwnedPorts(String id) {
        new SelectTool(this, "select.owned.ports").ensurePrecondition(true).select(id);
    }

    public void selectOwnedElements(String id) {
        new SelectTool(this, "select.owned.elements").ensurePrecondition(true).select(id);
    }

    public void selectRelatedEdges(String id) {
        new SelectTool(this, "select.related.connections").ensurePrecondition(true).select(id);
    }

    public void dragAndDropConstraintFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Constraint From Project Explorer");
    }

    public void dragAndDropConstraintsFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Constraints From Project Explorer");
    }

    public void dragAndDropCComponentFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Constraint From Project Explorer");
    }

    protected String createNodeElement(String containerId, String toolName) {
        DNode graphicalElement = (DNode)new CreateAbstractDNodeTool((DiagramContext)this, toolName, containerId).run();
        this.customVerificationOnCreatedNodeElement(toolName, graphicalElement, containerId);
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    protected String createNodeListElement(String containerId, String toolName) {
        DNodeListElement graphicalElement = (DNodeListElement)new CreateAbstractDNodeTool((DiagramContext)this, toolName, containerId).run();
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    protected String createNodeElement(String targetId, String containerId, String toolName) {
        DNode graphicalElement = (DNode)new CreateAbstractDNodeTool<DNode>((DiagramContext)this, toolName, targetId, containerId, null, DNode.class).run();
        this.customVerificationOnCreatedNodeElement(toolName, graphicalElement, containerId);
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    protected String createContainerElement(String containerId, String toolName) {
        DDiagramElementContainer graphicalElement = (DDiagramElementContainer)new CreateContainerTool((DiagramContext)this, toolName, containerId).run();
        this.customVerificationOnCreatedContainerElement(toolName, graphicalElement, containerId);
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    protected String createEdgeElement(String sourceViewId, String targetViewId, String toolName) {
        DEdge graphicalElement = (DEdge)new CreateDEdgeTool(this, toolName, sourceViewId, targetViewId).run();
        this.customVerificationOnCreatedEdgeElement(toolName, (DDiagramElement)graphicalElement, sourceViewId, targetViewId);
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    protected String createEdgeElement(String sourceViewId, String targetViewId, String toolName, int newEdgesNumber) {
        DEdge graphicalElement = (DEdge)new CreateDEdgeTool((DiagramContext)this, toolName, sourceViewId, targetViewId, newEdgesNumber, 0, 0).run();
        this.customVerificationOnCreatedEdgeElement(toolName, (DDiagramElement)graphicalElement, sourceViewId, targetViewId);
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    protected void insertElements(String containerId, String toolName, String ... elementsToBeInsertedIds) {
        new InsertRemoveTool((DiagramContext)this, toolName, containerId).insert(elementsToBeInsertedIds);
    }

    protected void removeElements(String containerId, String toolName, String ... elementsToBeRemovedIds) {
        new InsertRemoveTool((DiagramContext)this, toolName, containerId).remove(elementsToBeRemovedIds);
    }

    protected void dragAndDrop(String idDraggedElement, String containerId, String toolName) {
        new DragAndDropTool(this, toolName, idDraggedElement, containerId).run();
    }

    protected String dragAndDropFromExplorer(String idDraggedElement, String containerId, String toolName) {
        EObject droppedElementSemantic = this.getSessionContext().getSemanticElement(idDraggedElement);
        DDiagramElement elem = (DDiagramElement)new DragAndDropFromProjectExplorerTool((DiagramContext)this, toolName, droppedElementSemantic, containerId).run();
        return this.getSemanticIdFromView(elem);
    }

    protected void customVerificationOnCreatedNodeElement(String toolName, DNode graphicalElement, String containerId) {
    }

    protected void customVerificationOnCreatedEdgeElement(String toolName, DDiagramElement view, String sourceId, String targetId) {
    }

    protected void customVerificationOnCreatedContainerElement(String toolName, DDiagramElementContainer graphicalElement, String containerId) {
    }

    @Override
    protected String getSemanticIdFromView(DDiagramElement view) {
        EObject semanticElement = view.getTarget();
        return ((CapellaElement)semanticElement).getId();
    }
}

