/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.xab.ReuseComponentTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class EABDiagram
extends XABDiagram {
    public EABDiagram(SessionContext context, DDiagram diagram) {
        super(BlockArchitectureExt.Type.EPBS, context, diagram);
    }

    public static EABDiagram openDiagram(SessionContext executionContext, String name) {
        return (EABDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new EABDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static EABDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        return (EABDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, "EPBS Architecture Blank"){

            @Override
            public DiagramContext getResult() {
                return new EABDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public String createConfigurationItem(String id, String containerId, BlockArchitectureExt.ConfigurationItemType ciType) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.EPBS) {
            switch (ciType) {
                case COTS: {
                    name = "cots";
                    break;
                }
                case CS: {
                    name = "cs";
                    break;
                }
                case HW: {
                    name = "hw";
                    break;
                }
                case INTERFACE: {
                    name = "interface";
                    break;
                }
                case NDI: {
                    name = "ndi";
                    break;
                }
                case PRIME_ITEM: {
                    name = "prime.item";
                    break;
                }
                case SYSTEM: {
                    name = "system";
                    break;
                }
            }
        }
        DDiagramElementContainer element = (DDiagramElementContainer)new CreateContainerTool((DiagramContext)this, name, containerId, id).run();
        return ((CapellaElement)element.getTarget()).getId();
    }

    public void reuseConfigurationItem(String containerId, String ... ids) {
        new ReuseComponentTool(this, "reuse.configuration.item", containerId).select(ids);
    }

    public void manageRealizedPhysicalArtifacts(String containerId, String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "manage.realized.physical.artifacts", containerId).insert(ids);
    }

    public void insertConfigurationItems(String containerId, String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "configuration.items", containerId).insert(ids);
    }

    public void removeConfigurationItems(String containerId, String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "configuration.items", containerId).remove(ids);
    }

    public void insertRealizedPhysicalArtifacts(String containerId, String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "realized.physical.artifacts", containerId).insert(ids);
    }

    public void removeRealizedPhysicalArtifacts(String containerId, String ... ids) {
        new InsertRemoveTool((DiagramContext)this, "realized.physical.artifacts", containerId).remove(ids);
    }

    public void dragAndDropConfigurationItemFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Components From Project Explorer");
    }

    public void dragAndDropPhysicalAtifacts(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "DnD AB Physical Artifacts");
    }
}

