/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.SequenceDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.framework.context.SessionContext;

public class FSDiagram
extends SequenceDiagram {
    public FSDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(type, context, diagram);
    }

    public static FSDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        String name = "Functional Scenario";
        if (type == BlockArchitectureExt.Type.OA) {
            name = "Activity Interaction Scenario";
        }
        return (FSDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new FSDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static FSDiagram openDiagram(SessionContext executionContext, String name, final BlockArchitectureExt.Type type) {
        return (FSDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new FSDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public String createFunction() {
        return this.createNodeElement(this.getDiagramId(), this.getFunctionToolId(this.type));
    }

    public String createFunction(String containerId) {
        return this.createNodeElement(containerId, this.getFunctionToolId(this.type));
    }

    public void insertFunction(String id) {
        new SequenceDiagram.InsertRemoveInstanceRoleTool((DiagramContext)this, "functions").insert(id);
    }

    public void removeFunction(String id) {
        new SequenceDiagram.InsertRemoveInstanceRoleTool((DiagramContext)this, "functions").remove(id);
    }

    public String createFunction(BlockArchitectureExt.FunctionType functionType) {
        String name = "";
        switch (functionType) {
            case DUPLICATE: {
                name = "duplicate";
                break;
            }
            case GATHER: {
                name = "gather";
                break;
            }
            case ROUTE: {
                name = "route";
                break;
            }
            case SELECT: {
                name = "select";
                break;
            }
            case SPLIT: {
                name = "split";
                break;
            }
            default: {
                name = this.getFunctionToolId(this.type);
            }
        }
        return this.createNodeElement(this.getDiagramId(), name);
    }

    private String getFunctionToolId(BlockArchitectureExt.Type type) {
        switch (type) {
            case SA: {
                return "system.function";
            }
            case LA: {
                return "logical.function";
            }
            case PA: {
                return "physical.function";
            }
        }
        return "function";
    }

    @Override
    public void addMultipleLifeLinesForExistingComponent(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createArmTimer(String source, String target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancelArmTimer(String source, String target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String createActor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertActor(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeActor(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String insertAllocatedFunction(String containerId, String id) {
        throw new UnsupportedOperationException();
    }
}

