/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.headless.HeadlessResultOpProvider;
import org.polarsys.capella.test.diagram.common.ju.headless.IHeadlessResult;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;

public class CreatePathTool
extends AbstractToolStep<EObject> {
    protected String element;
    protected EClass clazz;
    protected String[] links;

    public CreatePathTool(DiagramContext context, String toolName, String element, String ... links) {
        super(context, toolName);
        this.element = element;
        this.links = links;
    }

    @Override
    protected void preRunTest() {
        IHeadlessResult result = new IHeadlessResult(){

            @Override
            public Object getResult(Collection<? extends EObject> selections, Map<String, Object> parameters) {
                List scope = (List)parameters.get("scope");
                return scope.get(0);
            }
        };
        HeadlessResultOpProvider.INSTANCE.setCurrentOp(result);
        super.preRunTest();
    }

    @Override
    protected void initToolArguments() {
        ArrayList<DSemanticDecorator> views = new ArrayList<DSemanticDecorator>();
        String[] stringArray = this.links;
        int n = this.links.length;
        int n2 = 0;
        while (n2 < n) {
            String link = stringArray[n2];
            views.add(this.getDiagramContext().getView(link));
            ++n2;
        }
        this._toolWrapper.setArgumentValue(ArgumentType.COLLECTION, views);
    }

    public DDiagramElement getResult() {
        return (DDiagramElement)this.getDiagramContext().getView(this.element);
    }

    protected void postRunTest() {
        EObject previous = null;
        String[] stringArray = this.links;
        int n = this.links.length;
        int n2 = 0;
        while (n2 < n) {
            String link = stringArray[n2];
            EObject object = this.getExecutionContext().getSemanticElement(link);
            EObject element = this.getPath(object);
            if (previous == null) {
                previous = element;
            } else {
                Assert.assertTrue((previous == element ? 1 : 0) != 0);
            }
            ++n2;
        }
        this.getExecutionContext().putSemanticElement(this.element, previous);
        this.getDiagramContext().hasView(this.element);
    }

    protected EObject getPath(EObject object) {
        PhysicalPath element = null;
        if (object instanceof PhysicalLink) {
            element = (PhysicalPath)((Involvement)((PhysicalLink)object).getInvolvingInvolvements().get(((PhysicalLink)object).getInvolvingInvolvements().size() - 1)).getInvolver();
        } else if (object instanceof FunctionalExchange) {
            element = (EObject)((FunctionalExchange)object).getInvolvingFunctionalChains().get(((FunctionalExchange)object).getInvolvingFunctionalChains().size() - 1);
        }
        return element;
    }
}

