/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools.sequence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.headless.HeadlessResultOpProvider;
import org.polarsys.capella.test.diagram.common.ju.headless.IHeadlessResult;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;

public class LostFoundMessageCreationTool
extends AbstractToolStep {
    protected String containerId;
    protected String edgeId;
    protected Collection<SequenceMessage> messages;
    protected String sourceId;
    protected String targetId;

    public LostFoundMessageCreationTool(DiagramContext context, String toolName, String containerId, String edgeId, String sourceId, String targetId) {
        super(context, toolName);
        this.edgeId = edgeId;
        this.containerId = containerId;
        this.sourceId = sourceId;
        this.targetId = targetId;
    }

    @Override
    protected void preRunTest() {
        HeadlessResultOpProvider.INSTANCE.setCurrentOp(new IHeadlessResult(){

            @Override
            public Object getResult(Collection<? extends EObject> selections, Map<String, Object> parameters) {
                return LostFoundMessageCreationTool.this.getExecutionContext().getSemanticElement(LostFoundMessageCreationTool.this.edgeId);
            }
        });
        super.preRunTest();
        this.messages = this.getSequenceMessages();
    }

    protected void postRunTest() {
        Collection<SequenceMessage> addedMessages = this.getSequenceMessages();
        addedMessages.removeAll(this.messages);
        EObject source = this.sourceId == null ? null : this.getExecutionContext().getSemanticElement(this.sourceId);
        EObject target = this.targetId == null ? null : this.getExecutionContext().getSemanticElement(this.targetId);
        for (SequenceMessage message : addedMessages) {
            System.out.println(message);
            if (source != null) {
                Assert.assertTrue((String)("SequenceMessage does not have sending part " + source.getClass()), (boolean)message.getSendingPart().getRepresentingInstanceRoles().contains((Object)source));
            }
            if (target == null) continue;
            Assert.assertTrue((String)("SequenceMessage does not have receiving part " + target.getClass()), (boolean)message.getReceivingPart().getRepresentingInstanceRoles().contains((Object)target));
        }
    }

    private Collection<SequenceMessage> getSequenceMessages() {
        ArrayList<SequenceMessage> messages = new ArrayList<SequenceMessage>();
        if (this.getDiagramContext().getDiagram() instanceof SequenceDDiagram && ((SequenceDDiagram)this.getDiagramContext().getDiagram()).getTarget() instanceof Scenario) {
            Scenario scen = (Scenario)((SequenceDDiagram)this.getDiagramContext().getDiagram()).getTarget();
            messages.addAll((Collection<SequenceMessage>)scen.getOwnedMessages());
        }
        return messages;
    }

    @Override
    protected void initToolArguments() {
        DSemanticDecorator containerView = this.getDiagramContext().getView(this.containerId);
        this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER, containerView.getTarget());
        this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, containerView);
    }

    public Object getResult() {
        return null;
    }
}

