/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.junit.Assert;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;

public class CreateElementTitleBlockTool
extends CreateAbstractDNodeTool<DDiagramElementContainer> {
    String diagramID;

    public CreateElementTitleBlockTool(DiagramContext context, String toolName, String containerView, String diagramID) {
        super(context, toolName, containerView);
        this.diagramID = diagramID;
    }

    @Override
    protected void preRunTest() {
        super.preRunTest();
    }

    @Override
    protected DSemanticDecorator getContainerView() {
        return this.getDiagramContext().getView(this.diagramID);
    }

    @Override
    protected void postRunTest() {
        DiagramHelper.refreshDiagram(this.getDiagramContext().getDiagram());
        this.newElements = DiagramHelper.getOwnedElements(this.getContainerView());
        this.newElements.removeAll(this.elements);
        Assert.assertTrue((this.newElements.size() == 2 ? 1 : 0) != 0);
        Iterator it = this.newElements.iterator();
        DDiagramElement element = (DDiagramElement)it.next();
        Assert.assertTrue((boolean)(element.getTarget() instanceof DAnnotation));
        DAnnotation elementTB = (DAnnotation)element.getTarget();
        DAnnotation line = (DAnnotation)elementTB.getReferences().get(1);
        DAnnotation cell = (DAnnotation)line.getReferences().get(0);
        DNodeList cellNode = (DNodeList)DiagramServices.getDiagramServices().getDiagramElement(this.getDiagramContext().getDiagram(), (EObject)cell);
        Assert.assertTrue((String)"Cell view should contain content view", (cellNode.eContents().size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"A new Element Title Block should have been created.", (boolean)elementTB.getSource().equals("ElementTitleBlock"));
        DSemanticDecorator elementView = this.getDiagramContext().getView(this.containerView);
        Assert.assertTrue((String)("The created Element Title Block does not have a reference to " + this.containerView), (boolean)elementTB.getReferences().contains((Object)elementView.getTarget()));
        DEdge edge = (DEdge)it.next();
        Assert.assertTrue((String)("An edge to " + this.containerView + " should have been created."), (boolean)this.containerView.equals(((CapellaElement)((DSemanticDecorator)edge.getTargetNode()).getTarget()).getId()));
    }

    @Override
    public DDiagramElementContainer getResult() {
        return (DDiagramElementContainer)this.newElements.iterator().next();
    }
}

