/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.junit.Assert;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.AbstractExternalJavaAction;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.headless.IHeadlessResult;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;

public class InsertRemoveTitleBlockTool
extends InsertRemoveTool {
    public InsertRemoveTitleBlockTool(DiagramContext context, String toolName) {
        super(context, toolName);
    }

    private DAnnotation getAnnotation(String uid) {
        DDiagram diagram = this.getDiagramContext().getDiagram();
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
        Optional<DAnnotation> op = descriptor.getEAnnotations().stream().filter(x -> x.getUid().equals(uid)).findFirst();
        if (op.isPresent()) {
            return op.get();
        }
        return null;
    }

    private boolean hasView(DAnnotation titleBlock) {
        DDiagram diagram = this.getDiagramContext().getDiagram();
        DDiagramElement graphicalElement = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)titleBlock);
        return graphicalElement != null;
    }

    private List<EObject> getDAnnotationElements(String ... ids) {
        ArrayList<EObject> objList = new ArrayList<EObject>();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            objList.add((EObject)this.getAnnotation(id));
            ++n2;
        }
        return objList;
    }

    @Override
    protected void checkPreconditions() {
        String uid;
        String[] stringArray = this.insertedElements;
        int n = this.insertedElements.length;
        int n2 = 0;
        while (n2 < n) {
            uid = stringArray[n2];
            Assert.assertFalse((boolean)this.hasView(this.getAnnotation(uid)));
            ++n2;
        }
        stringArray = this.removedElements;
        n = this.removedElements.length;
        n2 = 0;
        while (n2 < n) {
            uid = stringArray[n2];
            Assert.assertTrue((boolean)this.hasView(this.getAnnotation(uid)));
            ++n2;
        }
    }

    @Override
    protected void postRunTest() {
        String uid;
        DiagramHelper.refreshDiagram(this.getDiagramContext().getDiagram());
        String[] stringArray = this.insertedElements;
        int n = this.insertedElements.length;
        int n2 = 0;
        while (n2 < n) {
            uid = stringArray[n2];
            Assert.assertTrue((boolean)this.hasView(this.getAnnotation(uid)));
            ++n2;
        }
        stringArray = this.removedElements;
        n = this.removedElements.length;
        n2 = 0;
        while (n2 < n) {
            uid = stringArray[n2];
            Assert.assertFalse((boolean)this.hasView(this.getAnnotation(uid)));
            ++n2;
        }
    }

    @Override
    protected IHeadlessResult createOperation() {
        return new IHeadlessResult(){

            @Override
            public Object getResult(Collection<? extends EObject> selections, Map<String, Object> parameters) {
                if (InsertRemoveTitleBlockTool.this.insertAll) {
                    return AbstractExternalJavaAction.getScope(parameters);
                }
                if (InsertRemoveTitleBlockTool.this.removeAll) {
                    return Collections.emptyList();
                }
                HashSet<EObject> objects = new HashSet<EObject>();
                DiagramContext context = InsertRemoveTitleBlockTool.this.getDiagramContext();
                Collection<EObject> inserted = context.adaptTool(InsertRemoveTitleBlockTool.this, parameters, InsertRemoveTitleBlockTool.this.getDAnnotationElements(InsertRemoveTitleBlockTool.this.insertedElements));
                Collection<EObject> removed = context.adaptTool(InsertRemoveTitleBlockTool.this, parameters, InsertRemoveTitleBlockTool.this.getDAnnotationElements(InsertRemoveTitleBlockTool.this.removedElements));
                objects.addAll(AbstractExternalJavaAction.getInitialSelection(parameters));
                objects.addAll(inserted);
                objects.removeAll(removed);
                return new ArrayList(objects);
            }
        };
    }
}

