/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.wrapper.factory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.polarsys.capella.test.diagram.common.ju.wrapper.AbstractToolWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.factory.AbstractToolWrapperFactory;
import org.polarsys.capella.test.diagram.common.ju.wrapper.factory.CommonToolWrapperFactory;
import org.polarsys.capella.test.diagram.common.ju.wrapper.factory.DiagramToolWrapperFactory;
import org.polarsys.capella.test.diagram.common.ju.wrapper.factory.SequenceToolWrapperFactory;
import org.polarsys.capella.test.diagram.common.ju.wrapper.factory.TableToolWrapperFactory;

public class ToolWrapperFactory {
    Map<EPackage, AbstractToolWrapperFactory> _factories = new HashMap<EPackage, AbstractToolWrapperFactory>();
    public static ToolWrapperFactory INSTANCE = ToolWrapperFactory.init();

    private static ToolWrapperFactory init() {
        if (INSTANCE == null) {
            INSTANCE = new ToolWrapperFactory();
        }
        return INSTANCE;
    }

    private ToolWrapperFactory() {
        HashSet<AbstractToolWrapperFactory> list = new HashSet<AbstractToolWrapperFactory>(3);
        list.add(new CommonToolWrapperFactory());
        list.add(new SequenceToolWrapperFactory());
        list.add(new TableToolWrapperFactory());
        list.add(new DiagramToolWrapperFactory());
        for (AbstractToolWrapperFactory factory : list) {
            this._factories.put(factory.getTargetEPackage(), factory);
        }
    }

    public AbstractToolWrapper createToolCommandWrapper(AbstractToolDescription tool_p) {
        Assert.isNotNull((Object)tool_p);
        EPackage ePackage = tool_p.eClass().getEPackage();
        AbstractToolWrapperFactory factory = this._factories.get(ePackage);
        return factory != null ? factory.createToolCommandWrapper(tool_p) : null;
    }
}

