/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.wrapper.utils;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ArrangeConstraint;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.Messages;

public class SiriusElementHelper {
    public static final Collection<ArrangeConstraint> PINNED_CONSTRAINTS = new ArrayList<ArrangeConstraint>();

    static {
        PINNED_CONSTRAINTS.add(ArrangeConstraint.KEEP_LOCATION);
        PINNED_CONSTRAINTS.add(ArrangeConstraint.KEEP_SIZE);
        PINNED_CONSTRAINTS.add(ArrangeConstraint.KEEP_RATIO);
    }

    public static void testComparisonEdgeTarget(EdgeTarget anEdgeTarget_p, ModelElement expectedTarget_p) {
        boolean result = false;
        result = SiriusElementHelper.compareEdgeTargetByID(anEdgeTarget_p, expectedTarget_p);
        Assert.assertTrue((String)MessageFormat.format(Messages.edgeTargetComparisonFalse, ((ModelElement)((DSemanticDecorator)anEdgeTarget_p).getTarget()).getId(), expectedTarget_p.getId()), (boolean)result);
    }

    public static boolean compareEdgeTargetByID(EdgeTarget anEdgeTarget_p, ModelElement expectedTarget_p) {
        boolean result = false;
        result = SiriusElementHelper.compareEdgeTarget(anEdgeTarget_p, (EObject)expectedTarget_p, ModellingcorePackage.Literals.MODEL_ELEMENT, (EStructuralFeature)ModellingcorePackage.Literals.MODEL_ELEMENT__ID);
        return result;
    }

    public static boolean compareEdgeTarget(EdgeTarget anEdgeTarget_p, EObject expectedTarget_p, EClass expectedSemanticMetaClass_p, EStructuralFeature featureToCompare_p) {
        boolean result = false;
        EObject semanticTarget = ((DSemanticDecorator)anEdgeTarget_p).getTarget();
        result = expectedSemanticMetaClass_p.isSuperTypeOf(expectedSemanticMetaClass_p);
        return result &= semanticTarget.eGet(featureToCompare_p).equals(expectedTarget_p.eGet(featureToCompare_p));
    }

    public static void checkDDiagramElementName(DDiagramElement element_p, String expectedName_p) {
        String actualName = element_p.getName();
        boolean hasSameName = actualName.equals(expectedName_p);
        Assert.assertTrue((String)MessageFormat.format(Messages.wrongElementName, expectedName_p, actualName), (boolean)hasSameName);
    }

    public static void checkMultiEdgesTargets(DDiagram diagram_p, CapellaElement source_p, List<CapellaElement> targetList_p) {
        EList edges = diagram_p.getEdges();
        ArrayList<CapellaElement> actualEdgeTargets = new ArrayList<CapellaElement>();
        int i = 0;
        while (i < edges.size()) {
            EdgeTarget edgeSource = ((DEdge)edges.get(i)).getSourceNode();
            EdgeTarget edgeTarget = ((DEdge)edges.get(i)).getTargetNode();
            if (SiriusElementHelper.compareEdgeTargetByID(edgeSource, (ModelElement)source_p)) {
                actualEdgeTargets.add((CapellaElement)((DSemanticDecorator)edgeTarget).getTarget());
            }
            ++i;
        }
        boolean hasSameTargets = targetList_p.containsAll(actualEdgeTargets) && actualEdgeTargets.containsAll(targetList_p);
        Assert.assertTrue((String)MessageFormat.format(Messages.multiEdgeTargetsError, source_p.getLabel()), (boolean)hasSameTargets);
    }

    public static void checkEdgeSourceAndTarget(DDiagram diagram_p, CapellaElement edge_p, CapellaElement source_p, CapellaElement target_p) {
        DDiagramElement element = DiagramHelper.getOnDiagram(diagram_p, (EObject)edge_p);
        Assert.assertTrue((String)MessageFormat.format(Messages.noEdgeDetected, source_p.getLabel()), (boolean)(element instanceof DEdge));
        DEdge edge = (DEdge)element;
        EdgeTarget edgeSource = edge.getSourceNode();
        EdgeTarget edgeTarget = edge.getTargetNode();
        SiriusElementHelper.testComparisonEdgeTarget(edgeSource, (ModelElement)source_p);
        SiriusElementHelper.testComparisonEdgeTarget(edgeTarget, (ModelElement)target_p);
    }

    public static void checkEdgeSourceAndTarget(DEdge edge_p, DNode source_p, DNode target_p) {
        EdgeTarget edgeSource = edge_p.getSourceNode();
        boolean hasSameSource = edgeSource.equals(source_p);
        Assert.assertTrue((String)"The expected source and the actual one are different.", (boolean)hasSameSource);
        EdgeTarget edgeTarget = edge_p.getTargetNode();
        boolean hasSameTarget = edgeTarget.equals(target_p);
        Assert.assertTrue((String)"The expected target and the actual one are different.", (boolean)hasSameTarget);
    }

    public static Collection<DRepresentation> getAllDSemanticDiagrams(Session session_p) {
        Collection dRepresentations = DialectManager.INSTANCE.getAllRepresentations(session_p);
        ArrayList<DRepresentation> result = new ArrayList<DRepresentation>();
        for (DRepresentation aRepresentation : dRepresentations) {
            if (!(aRepresentation instanceof DSemanticDiagram)) continue;
            result.add(aRepresentation);
        }
        return result;
    }

    public static Collection<DEdge> getDSemanticDiagramDEdge(DRepresentation representation_p) {
        DDiagram diagram = (DDiagram)representation_p;
        EList diagramElements = diagram.getDiagramElements();
        ArrayList<DEdge> result = new ArrayList<DEdge>();
        for (DDiagramElement anElement : diagramElements) {
            if (!(anElement instanceof DEdge)) continue;
            result.add((DEdge)anElement);
        }
        return result;
    }

    public static DEdge getDEdgeByIdSourceTarget(DDiagram diagram_p, String expectedId_p, EdgeTarget expectedSource_p, EdgeTarget expectedTarget_p) {
        Collection<DEdge> allDiagramEdges = SiriusElementHelper.getDSemanticDiagramDEdge((DRepresentation)diagram_p);
        for (DEdge anEdge : allDiagramEdges) {
            String id = (String)anEdge.getTarget().eGet((EStructuralFeature)ModellingcorePackage.Literals.MODEL_ELEMENT__ID);
            if (!id.equals(expectedId_p) || !anEdge.getSourceNode().equals(expectedSource_p) || !anEdge.getTargetNode().equals(expectedTarget_p)) continue;
            return anEdge;
        }
        return null;
    }

    private static List<ArrangeConstraint> getArrangeConstraints(EObject diagramElement) {
        EList constraints = null;
        if (diagramElement instanceof AbstractDNode) {
            AbstractDNode node = (AbstractDNode)diagramElement;
            constraints = node.getArrangeConstraints();
        } else if (diagramElement instanceof DEdge) {
            DEdge edge = (DEdge)diagramElement;
            constraints = edge.getArrangeConstraints();
        }
        return constraints;
    }

    public static boolean isPinned(DDiagramElement dDiagramElement) {
        boolean isPinned = false;
        List<ArrangeConstraint> constraints = SiriusElementHelper.getArrangeConstraints((EObject)dDiagramElement);
        isPinned = constraints != null && constraints.containsAll(PINNED_CONSTRAINTS);
        return isPinned;
    }
}

