/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.wrapper.utils;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.sequence.description.tool.MessageCreationTool;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.MenuItemDescription;
import org.eclipse.sirius.viewpoint.description.tool.PopupMenu;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.tool.StringUtil;
import org.polarsys.capella.test.diagram.common.ju.wrapper.OperationActionToolDescriptionWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.Messages;
import org.polarsys.capella.test.framework.helpers.GuiActions;

public class ToolHelper {
    Session _session;
    DDiagram _diagram;

    public ToolHelper(Session session, DDiagram diagram) {
        this._session = session;
        this._diagram = diagram;
    }

    public AbstractToolDescription getTool(String toolName) {
        Assert.assertNotNull((Object)this._session);
        Assert.assertNotNull((Object)this._diagram);
        AbstractToolDescription theAbstractToolDescription = null;
        block0: for (AbstractToolDescription current : this.getTools(this._diagram.getDescription())) {
            if (current.getName().equals(toolName)) {
                theAbstractToolDescription = current;
                break;
            }
            if (!(current instanceof PopupMenu)) continue;
            for (MenuItemDescription item : ((PopupMenu)current).getMenuItemDescription()) {
                if (!item.getName().equals(toolName)) continue;
                theAbstractToolDescription = item;
                continue block0;
            }
        }
        return theAbstractToolDescription;
    }

    public AbstractToolDescription getToolByLabel(String toolName) {
        Assert.assertNotNull((Object)this._session);
        Assert.assertNotNull((Object)this._diagram);
        AbstractToolDescription theAbstractToolDescription = null;
        for (AbstractToolDescription current : this.getTools(this._diagram.getDescription())) {
            if (current.getLabel() == null || !current.getLabel().equals(toolName)) continue;
            theAbstractToolDescription = current;
            break;
        }
        return theAbstractToolDescription;
    }

    public AbstractToolDescription getToolByLabel(String toolName, String toolLabel) {
        Assert.assertNotNull((Object)this._session);
        Assert.assertNotNull((Object)this._diagram);
        EList tools = new DiagramComponentizationManager().getAllTools(this._session.getSelectedViewpoints(true), this._diagram.getDescription());
        AbstractToolDescription theAbstractToolDescription = null;
        for (AbstractToolDescription current : tools) {
            if (!current.getName().equals(toolName) || current.getLabel() == null || !current.getLabel().equals(toolLabel)) continue;
            theAbstractToolDescription = current;
            break;
        }
        return theAbstractToolDescription;
    }

    protected Collection<AbstractToolDescription> getTools(DiagramDescription description) {
        ArrayList<AbstractToolDescription> tools = new ArrayList<AbstractToolDescription>();
        tools.addAll((Collection<AbstractToolDescription>)new DiagramComponentizationManager().getAllTools(this._session.getSelectedViewpoints(true), this._diagram.getDescription()));
        tools.addAll(DiagramServices.getDiagramServices().getAllMappingsByName(this._diagram.getDescription()).values().stream().map(m -> m.getLabelDirectEdit()).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        return tools;
    }

    public static Set<String> getSetOfActualTools(EList<AbstractToolDescription> tools) {
        HashSet<String> setOfActualTools = new HashSet<String>();
        ArrayList<String> listOfDuplicated = new ArrayList<String>();
        for (AbstractToolDescription toolDescription : tools) {
            if (!(toolDescription instanceof ContainerCreationDescription) && !(toolDescription instanceof NodeCreationDescription) && !(toolDescription instanceof EdgeCreationDescription) && !(toolDescription instanceof ToolDescription) && !(toolDescription instanceof MessageCreationTool)) continue;
            if (toolDescription.getLabel() == null || toolDescription.getLabel().equalsIgnoreCase("")) {
                if (setOfActualTools.add(toolDescription.getName())) continue;
                listOfDuplicated.add(toolDescription.getName());
                continue;
            }
            if (setOfActualTools.add(toolDescription.getLabel())) continue;
            listOfDuplicated.add(toolDescription.getLabel());
        }
        return setOfActualTools;
    }

    public static Set<String> getSetOfActualToolsWithoutConstraintsAccelerators(EList<AbstractToolDescription> tools) {
        HashSet<String> setOfActualTools = new HashSet<String>();
        ArrayList<String> listOfDuplicated = new ArrayList<String>();
        for (AbstractToolDescription toolDescription : tools) {
            if (ToolHelper.getGroupTools(tools, "Constraints").contains(toolDescription) || ToolHelper.getGroupTools(tools, "Accelerators").contains(toolDescription) || !(toolDescription instanceof ContainerCreationDescription) && !(toolDescription instanceof NodeCreationDescription) && !(toolDescription instanceof EdgeCreationDescription) && !(toolDescription instanceof ToolDescription) && !(toolDescription instanceof MessageCreationTool) || setOfActualTools.add(toolDescription.getName())) continue;
            listOfDuplicated.add(toolDescription.getName());
        }
        return setOfActualTools;
    }

    private static List<AbstractToolDescription> getGroupTools(EList<AbstractToolDescription> tools, String groupName) {
        ArrayList<AbstractToolDescription> listOfGroupTools = new ArrayList<AbstractToolDescription>();
        for (AbstractToolDescription toolDescription : tools) {
            IdentifiedElement container;
            if (!(toolDescription instanceof ContainerCreationDescription) && !(toolDescription instanceof NodeCreationDescription) && !(toolDescription instanceof EdgeCreationDescription) && !(toolDescription instanceof ToolDescription) && !(toolDescription instanceof MessageCreationTool) || !(toolDescription.eContainer() instanceof IdentifiedElement) || !(container = (IdentifiedElement)toolDescription.eContainer()).getName().equals(groupName)) continue;
            listOfGroupTools.add(toolDescription);
        }
        return listOfGroupTools;
    }

    public static void checkSelectionOk(OperationActionToolDescriptionWrapper toolWrapper) {
        String elementsToSelect;
        if (toolWrapper.isPreconditionOk() && (elementsToSelect = toolWrapper.getTool().getElementsToSelect()) != null && !StringUtil.isEmpty((String)elementsToSelect)) {
            Collection initialViews = (Collection)toolWrapper.getArgumentValue(ArgumentType.COLLECTION);
            EObject semantic = ((DDiagramElement)initialViews.iterator().next()).getTarget();
            InterpreterRegistry interpreterRegistry = SiriusPlugin.getDefault().getInterpreterRegistry();
            IInterpreter interpreter = interpreterRegistry.getInterpreter(semantic);
            DDiagram diagram = ((DDiagramElement)initialViews.iterator().next()).getParentDiagram();
            interpreter.setVariable("views", (Object)initialViews);
            interpreter.setVariable("diagram", (Object)diagram);
            RuntimeLoggerInterpreter decorate = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
            EAttribute attribute = ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__ELEMENTS_TO_SELECT;
            Collection result = decorate.evaluateCollection(semantic, (EObject)toolWrapper.getTool(), (EStructuralFeature)attribute);
            result = result.stream().filter(x -> DiagramHelper.isDiagramElementSelectable((DDiagramElement)x)).collect(Collectors.toList());
            if (!result.isEmpty()) {
                GuiActions.flushASyncGuiThread();
                IEditorPart part = DiagramHelper.getDiagramEditor(SessionManager.INSTANCE.getSession(semantic), diagram);
                Collection selectedViews = DialectUIManager.INSTANCE.getSelection((DialectEditor)part);
                boolean isValid = result.containsAll(selectedViews) && selectedViews.containsAll(result);
                Assert.assertTrue((String)MessageFormat.format(Messages.failedSelectedElements, EObjectExt.getText((EObject)diagram), toolWrapper.getTool().getName(), selectedViews.size()), (boolean)isValid);
            }
            interpreter.unSetVariable("diagram");
            interpreter.unSetVariable("views");
        }
    }
}

