/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.layout.ju.layout.compare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.NoteAttachmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.TextAlignment;
import org.eclipse.gmf.runtime.notation.TextStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.ui.IEditorPart;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.sirius.analysis.ShapeUtil;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.layout.ju.layout.LayoutFactory;
import org.polarsys.capella.test.diagram.layout.ju.layout.Location;
import org.polarsys.capella.test.diagram.layout.ju.layout.Size;

public class ShapeHelper {
    private static Point getDiagramOrigin(Diagram diagram_p) {
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        if (diagram_p != null && editor instanceof DiagramEditor) {
            IDiagramGraphicalViewer diagramGraphicalViewer = ((DiagramEditor)editor).getDiagramGraphicalViewer();
            Map editPartRegistry = diagramGraphicalViewer.getEditPartRegistry();
            Object currentEditPart = editPartRegistry.get(diagram_p);
            IFigure figure = ((DDiagramEditPart)currentEditPart).getFigure();
            return new Point(figure.getBounds().x, figure.getBounds().y);
        }
        return null;
    }

    private static Point getClosestPointToOrigin(List<Point> diagramPoints_p) {
        int pointsNumber = diagramPoints_p.size();
        switch (pointsNumber) {
            case 0: {
                return null;
            }
            case 1: {
                return diagramPoints_p.get(0);
            }
        }
        Point result = diagramPoints_p.get(0);
        int i = 1;
        while (i < pointsNumber) {
            if (ShapeHelper.getDistaceFromOrigin(diagramPoints_p.get(i)) < ShapeHelper.getDistaceFromOrigin(result)) {
                result = diagramPoints_p.get(i);
            }
            ++i;
        }
        return result;
    }

    public static Point getClosestPointToOriginInDiagram(DDiagram diagram_p) {
        Map<Point, DDiagramElement> map = ShapeHelper.getDiagramDraw2DPointsInMap(diagram_p);
        Set<Point> keySet = map.keySet();
        ArrayList<Point> pointsList = new ArrayList<Point>();
        for (Point key : keySet) {
            pointsList.add(key);
        }
        return ShapeHelper.getClosestPointToOrigin(pointsList);
    }

    private static Map<Point, DDiagramElement> getDiagramDraw2DPointsInMap(DDiagram diagram_p) {
        List visibleDiagramElements = DiagramHelper.getVisibleDiagramElements((DDiagram)diagram_p);
        Diagram diagram = DiagramHelper.getDiagram((DDiagram)diagram_p);
        HashMap<Point, DDiagramElement> map = new HashMap<Point, DDiagramElement>();
        for (DDiagramElement currentElement : visibleDiagramElements) {
            if (currentElement instanceof DEdge) {
                PointList edgePoints = ShapeHelper.getDraw2DPointListForDEdge(diagram, currentElement);
                if (edgePoints == null) continue;
                int i = 0;
                while (i < edgePoints.size()) {
                    Point currentPoint = edgePoints.getPoint(i);
                    if (currentPoint != null) {
                        map.put(currentPoint, currentElement);
                    }
                    ++i;
                }
                continue;
            }
            Point nodePoint = ShapeHelper.getDraw2DCoordinatesForDNode(diagram, currentElement);
            map.put(nodePoint, currentElement);
        }
        return map;
    }

    private static double getDistaceFromOrigin(Point point_p) {
        Point zero = new Point(0, 0);
        return point_p.getDistance(zero);
    }

    private static List<Point> getDDiagramElementPointsList(DDiagram diagram_p, DDiagramElement element_p) {
        ArrayList<Point> result = new ArrayList<Point>();
        Diagram diagram = DiagramHelper.getDiagram((DDiagram)diagram_p);
        Point refPoint = ShapeHelper.getClosestPointToOriginInDiagram(diagram_p);
        if (element_p instanceof DEdge) {
            PointList edgePoints = ShapeHelper.getDraw2DPointListForDEdge(diagram, element_p);
            int i = 0;
            while (i < edgePoints.size()) {
                Point currentPoint = edgePoints.getPoint(i);
                if (currentPoint != null) {
                    Point pointToAdd = new Point(currentPoint.x - refPoint.x, currentPoint.y - refPoint.y);
                    result.add(pointToAdd);
                }
                ++i;
            }
        } else {
            Point nodePoint = ShapeHelper.getDraw2DCoordinatesForDNode(diagram, element_p);
            Point pointToAdd = new Point(nodePoint.x - refPoint.x, nodePoint.y - refPoint.y);
            result.add(pointToAdd);
        }
        return result;
    }

    static Location createRelativeLocation(int x, int y) {
        Location a = LayoutFactory.eINSTANCE.createLocation();
        a.setRelative(true);
        a.setX(x);
        a.setY(y);
        return a;
    }

    static Location createAbsoluteLocation(int x, int y) {
        Location a = LayoutFactory.eINSTANCE.createLocation();
        a.setRelative(false);
        a.setX(x);
        a.setY(y);
        return a;
    }

    private static Point getDraw2DCoordinatesForDNode(Diagram diagram_p, DDiagramElement element_p) {
        Point diagramOrigin = ShapeHelper.getDiagramOrigin(diagram_p);
        if (element_p instanceof DEdge) {
            return null;
        }
        View currentNode = ShapeHelper.retrieveNode(diagram_p, element_p);
        if (currentNode != null) {
            Point locationDRAW2D = ShapeUtil.getLocationDRAW2D((Node)((Node)currentNode));
            if (locationDRAW2D == null) {
                return null;
            }
            locationDRAW2D.x -= diagramOrigin.x;
            locationDRAW2D.y -= diagramOrigin.y;
            if (element_p instanceof Port || element_p instanceof InstanceRole) {
                return locationDRAW2D;
            }
            EObject container = element_p.eContainer();
            if (!(container instanceof DSemanticDiagram)) {
                Point containerPoint = ShapeHelper.getDraw2DCoordinatesForDNode(diagram_p, (DDiagramElement)container);
                locationDRAW2D.x += containerPoint.x;
                locationDRAW2D.y += containerPoint.y;
            }
            return locationDRAW2D;
        }
        return null;
    }

    private static Dimension getRectangleDimensionForDNode(Diagram diagram_p, DDiagramElement element_p) {
        GraphicalEditPart gep;
        if (element_p instanceof DEdge) {
            return null;
        }
        View currentNode = ShapeHelper.retrieveNode(diagram_p, element_p);
        if (currentNode != null && (gep = ShapeUtil.getEditPart((View)currentNode)) != null) {
            int width = gep.getFigure().getBounds().width;
            int height = gep.getFigure().getBounds().height;
            return new Dimension(width, height);
        }
        return null;
    }

    public static PointList getRelativePointListForDEdge(Diagram diagram_p, DDiagramElement element_p) {
        if (!(element_p instanceof DEdge)) {
            return null;
        }
        View currentNode = ShapeUtil.retrieveNode((Diagram)diagram_p, (DDiagramElement)element_p);
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        if (currentNode != null && editor instanceof DiagramEditor) {
            PointList result = new PointList();
            if (((Edge)currentNode).getSource() instanceof Node) {
                Node source = (Node)((Edge)currentNode).getSource();
                result.addPoint(((Bounds)source.getLayoutConstraint()).getX(), ((Bounds)source.getLayoutConstraint()).getY());
            }
            if (((Edge)currentNode).getTarget() instanceof Node) {
                Node target = (Node)((Edge)currentNode).getTarget();
                result.addPoint(((Bounds)target.getLayoutConstraint()).getX(), ((Bounds)target.getLayoutConstraint()).getY());
            }
            RelativeBendpoints d = (RelativeBendpoints)((Edge)currentNode).getBendpoints();
            for (Object p : d.getPoints()) {
                RelativeBendpoint r = (RelativeBendpoint)p;
                result.addPoint(r.getSourceX(), r.getSourceY());
                result.addPoint(r.getTargetX(), r.getTargetY());
            }
            return result;
        }
        return null;
    }

    private static PointList getDraw2DPointListForDEdge(Diagram diagram_p, DDiagramElement element_p) {
        Map editPartRegistry;
        Object currentEditPart;
        Point diagramOrigin = ShapeHelper.getDiagramOrigin(diagram_p);
        if (!(element_p instanceof DEdge)) {
            return null;
        }
        View currentNode = ShapeUtil.retrieveNode((Diagram)diagram_p, (DDiagramElement)element_p);
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        if (currentNode != null && editor instanceof DiagramEditor && (currentEditPart = (editPartRegistry = ((DiagramEditor)editor).getDiagramGraphicalViewer().getEditPartRegistry()).get(currentNode)) instanceof ConnectionNodeEditPart) {
            ConnectionNodeEditPart edgeNode = (ConnectionNodeEditPart)currentEditPart;
            IFigure figure = edgeNode.getFigure();
            AbstractDiagramEdgeEditPart.ViewEdgeFigure edgeFigure = (AbstractDiagramEdgeEditPart.ViewEdgeFigure)figure;
            PointList result = new PointList();
            PointList points = edgeFigure.getPoints();
            int i = 0;
            while (i < points.size()) {
                Point current = points.getPoint(i);
                Point newPoint = new Point(current.x - diagramOrigin.x, current.y - diagramOrigin.y);
                result.addPoint(newPoint);
                ++i;
            }
            EObject container = element_p.eContainer();
            if (!(container instanceof DSemanticDiagram)) {
                Point containerPoint = ShapeHelper.getDraw2DCoordinatesForDNode(diagram_p, (DDiagramElement)container);
                int i2 = 0;
                while (i2 < points.size()) {
                    Point current = points.getPoint(i2);
                    Point newPoint = new Point(current.x + containerPoint.x, current.y + containerPoint.y);
                    result.addPoint(newPoint);
                    ++i2;
                }
            }
            return result;
        }
        return null;
    }

    private static Point getDraw2DCoordinatesForNote(DDiagram diagram_p, ShapeStyle note_p) {
        Point refPoint = ShapeHelper.getClosestPointToOriginInDiagram(diagram_p);
        Diagram diag = DiagramHelper.getDiagram((DDiagram)diagram_p);
        Point diagramOrigin = ShapeHelper.getDiagramOrigin(diag);
        View currentNode = null;
        currentNode = note_p instanceof Shape ? (View)note_p : (View)note_p.eContainer();
        if (currentNode != null) {
            Point locationDRAW2D = ShapeUtil.getLocationDRAW2D((Node)((Node)currentNode));
            locationDRAW2D.x = locationDRAW2D.x - diagramOrigin.x - refPoint.x;
            locationDRAW2D.y = locationDRAW2D.y - diagramOrigin.y - refPoint.y;
            return locationDRAW2D;
        }
        return null;
    }

    private static Dimension getRectangleDimensionForNote(ShapeStyle note_p) {
        View currentNode = null;
        currentNode = note_p instanceof Shape ? (View)note_p : (View)note_p.eContainer();
        if (currentNode != null) {
            GraphicalEditPart gep = ShapeUtil.getEditPart((View)currentNode);
            int width = gep.getFigure().getBounds().width;
            int height = gep.getFigure().getBounds().height;
            return new Dimension(width, height);
        }
        return null;
    }

    private static PointList getDraw2DPointListForNoteAttachment(DDiagram diagram_p, Edge edge_p) {
        Map editPartRegistry;
        Object currentEditPart;
        Point refPoint = ShapeHelper.getClosestPointToOriginInDiagram(diagram_p);
        Diagram diag = DiagramHelper.getDiagram((DDiagram)diagram_p);
        Point diagramOrigin = ShapeHelper.getDiagramOrigin(diag);
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        if (edge_p != null && editor instanceof DiagramEditor && (currentEditPart = (editPartRegistry = ((DiagramEditor)editor).getDiagramGraphicalViewer().getEditPartRegistry()).get(edge_p)) instanceof NoteAttachmentEditPart) {
            NoteAttachmentEditPart edgeNode = (NoteAttachmentEditPart)currentEditPart;
            PolylineConnectionEx figure = (PolylineConnectionEx)edgeNode.getFigure();
            PointList points = figure.getPoints();
            PointList result = new PointList();
            int i = 0;
            while (i < points.size()) {
                Point current = points.getPoint(i);
                Point newPoint = new Point(current.x - diagramOrigin.x - refPoint.x, current.y - diagramOrigin.y - refPoint.y);
                result.addPoint(newPoint);
                ++i;
            }
            EObject container = edge_p.eContainer();
            if (!(container instanceof Diagram)) {
                Point containerPoint = ShapeHelper.getDraw2DCoordinatesForNode(diagram_p, (Node)container);
                int i2 = 0;
                while (i2 < points.size()) {
                    Point current = points.getPoint(i2);
                    Point newPoint = new Point(current.x + containerPoint.x, current.y + containerPoint.y);
                    result.addPoint(newPoint);
                    ++i2;
                }
            }
            return result;
        }
        return null;
    }

    private static Point getDraw2DCoordinatesForNode(DDiagram diagram_p, Node node_p) {
        Point refPoint = ShapeHelper.getClosestPointToOriginInDiagram(diagram_p);
        Diagram diag = DiagramHelper.getDiagram((DDiagram)diagram_p);
        Point diagramOrigin = ShapeHelper.getDiagramOrigin(diag);
        if (node_p != null) {
            Point locationDRAW2D = ShapeUtil.getLocationDRAW2D((Node)node_p);
            locationDRAW2D.x = locationDRAW2D.x - diagramOrigin.x - refPoint.x;
            locationDRAW2D.y = locationDRAW2D.y - diagramOrigin.y - refPoint.y;
            EObject container = node_p.eContainer();
            if (!(container instanceof Diagram)) {
                Point containerPoint = ShapeHelper.getDraw2DCoordinatesForNode(diagram_p, (Node)container);
                locationDRAW2D.x += containerPoint.x;
                locationDRAW2D.y += containerPoint.y;
            }
            return locationDRAW2D;
        }
        return null;
    }

    private static View retrieveNode(Diagram diagram, DDiagramElement node) {
        Node ret = null;
        if (node instanceof DEdge) {
            for (Object oIte : diagram.getPersistedEdges()) {
                Edge edgeIte;
                if (!(oIte instanceof Edge) || (edgeIte = (Edge)oIte).getElement() != node) continue;
                ret = edgeIte;
                break;
            }
        } else if (node instanceof DNodeContainer || node instanceof DNode || node instanceof DNodeList || node instanceof DNodeListElement) {
            ret = ShapeHelper.retrieveNodeRec((View)diagram, node);
        }
        return ret;
    }

    public static String getNoteTextAlignment(ShapeStyle note) {
        TextAlignment actualAlignment = null;
        View v = null;
        if (note instanceof View) {
            v = (View)note;
        } else if (note.eContainer() instanceof View) {
            v = (View)note.eContainer();
        }
        if (v != null) {
            EList styles = v.getStyles();
            for (Object next : styles) {
                if (!(next instanceof TextStyle)) continue;
                actualAlignment = ((TextStyle)next).getTextAlignment();
                return actualAlignment.getLiteral();
            }
        }
        return null;
    }

    public static Node retrieveNodeRec(View anchor, DDiagramElement rootNode) {
        Node ret = null;
        for (Object oIte : anchor.getPersistedChildren()) {
            if (!(oIte instanceof Node)) continue;
            Node nodeIte = (Node)oIte;
            if (nodeIte.getElement() == rootNode) {
                ret = nodeIte;
                break;
            }
            Node node = ShapeHelper.retrieveNodeRec((View)nodeIte, rootNode);
            if (node == null) continue;
            ret = node;
            break;
        }
        return ret;
    }

    public static Location adapt(Point currentSize) {
        if (currentSize == null) {
            return null;
        }
        Location b = LayoutFactory.eINSTANCE.createLocation();
        b.setX(currentSize.x);
        b.setY(currentSize.y);
        return b;
    }

    public static Size adapt(Dimension currentSize) {
        if (currentSize == null) {
            return null;
        }
        Size b = LayoutFactory.eINSTANCE.createSize();
        b.setHeight(currentSize.height);
        b.setWidth(currentSize.width);
        return b;
    }

    public static Collection<Location> getDEdgePoints(Diagram diagram, DEdge anElement, Point ref) {
        ArrayList<Location> result = new ArrayList<Location>();
        PointList edgePoints = ShapeHelper.getDraw2DPointListForDEdge(diagram, (DDiagramElement)anElement);
        boolean isAbsolute = true;
        if (edgePoints == null) {
            edgePoints = ShapeHelper.getRelativePointListForDEdge(diagram, (DDiagramElement)anElement);
            isAbsolute = false;
        }
        if (edgePoints != null) {
            int i = 0;
            while (i < edgePoints.size()) {
                Point currentPoint = edgePoints.getPoint(i);
                if (currentPoint != null) {
                    Location location = ShapeHelper.adapt(currentPoint);
                    if (isAbsolute) {
                        location = ShapeHelper.remove(location, ref);
                    }
                    location.setRelative(!isAbsolute);
                    result.add(location);
                }
                ++i;
            }
        }
        return result;
    }

    private static Location remove(Location adapt, Point ref) {
        Location b = LayoutFactory.eINSTANCE.createLocation();
        b.setX(adapt.getX() - ref.x);
        b.setY(adapt.getY() - ref.y);
        b.setRelative(adapt.isRelative());
        return b;
    }

    public static Collection<Location> getDEdgePointsForNoteAttachment(DDiagram diagram, Edge currentEdge, Point ref) {
        ArrayList<Location> result = new ArrayList<Location>();
        PointList edgePoints = ShapeHelper.getDraw2DPointListForNoteAttachment(diagram, currentEdge);
        if (edgePoints != null) {
            int i = 0;
            while (i < edgePoints.size()) {
                Point currentPoint = edgePoints.getPoint(i);
                if (currentPoint != null) {
                    result.add(ShapeHelper.remove(ShapeHelper.adapt(currentPoint), ref));
                }
                ++i;
            }
        }
        return result;
    }

    public static Location getDNodeLocation(Diagram diagram_p, DDiagramElement element_p, Point ref) {
        Point p = ShapeHelper.getDraw2DCoordinatesForDNode(diagram_p, element_p);
        if (p != null) {
            return ShapeHelper.remove(ShapeHelper.createAbsoluteLocation(p.x, p.y), ref);
        }
        View currentNode = ShapeHelper.retrieveNode(diagram_p, element_p);
        if (currentNode != null) {
            p = new Point(((org.eclipse.gmf.runtime.notation.Location)((Node)currentNode).getLayoutConstraint()).getX(), ((org.eclipse.gmf.runtime.notation.Location)((Node)currentNode).getLayoutConstraint()).getY());
            return ShapeHelper.remove(ShapeHelper.createRelativeLocation(p.x, p.y), ref);
        }
        return null;
    }

    public static Location getDNoteLocation(DDiagram diagram, ShapeStyle currentNote, Point ref) {
        return ShapeHelper.remove(ShapeHelper.adapt(ShapeHelper.getDraw2DCoordinatesForNote(diagram, currentNote)), ref);
    }

    public static Size getDNodeSize(Diagram diagram, AbstractDNode anElement) {
        return ShapeHelper.adapt(ShapeHelper.getRectangleDimensionForDNode(diagram, (DDiagramElement)anElement));
    }

    public static Size getDNoteSize(DDiagram diagram, ShapeStyle currentNote) {
        return ShapeHelper.adapt(ShapeHelper.getRectangleDimensionForNote(currentNote));
    }
}

