/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.layout.ju.testcases;

import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.layout.ju.handlers.CompareLayoutHandler;
import org.polarsys.capella.test.diagram.layout.ju.model.ModelCopyLayout;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CopyPasteLayout
extends ModelCopyLayout {
    public void test() throws Exception {
        DiagramHelper.setPreferenceAutoRefresh((boolean)true);
        DiagramHelper.setPrefereneRefreshOnOpening((boolean)true);
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        SessionContext context = new SessionContext(session);
        this.checkFunctionLayout(context);
        this.checkComponentExchangeLayout(context);
        this.checkRECRPLLayout(context);
        this.checkTransitionLayout(context);
    }

    protected void checkFunctionLayout(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)LAYOUT_A_SOURCE_FUNCTIONS);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)LAYOUT_A_TARGET_FUNCTIONS);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        handler.compare(source.getDiagramDescriptor(), target.getDiagramDescriptor(), false);
    }

    protected void checkFunctionalChains(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)LAYOUT_E_SOURCE_FUNCTIONAL_CHAINS);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)LAYOUT_E_TARGET_FUNCTIONAL_CHAINS);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        handler.compare(source.getDiagramDescriptor(), target.getDiagramDescriptor(), false);
    }

    protected void checkComponentExchangeLayout(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)LAYOUT_D_SOURCE_COMPONENT_EXCHANGES);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)LAYOUT_D_TARGET_COMPONENT_EXCHANGES);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        handler.compare(source.getDiagramDescriptor(), target.getDiagramDescriptor(), false);
    }

    protected void checkRECRPLLayout(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)LAYOUT_B_SOURCE_REC);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)LAYOUT_B_TARGET_RPL);
        handler.getManager().getLayoutMatchPolicy().addMatchRPLtoREC((CatalogElement)context.getSemanticElement(RPL));
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        handler.compare(source.getDiagramDescriptor(), target.getDiagramDescriptor(), false);
    }

    protected void checkTransitionLayout(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)LAYOUT_C_SOURCE_TRANSITION);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)LAYOUT_C_TARGET_TRANSITION);
        handler.getManager().getLayoutMatchPolicy().addArchitectureBlankMappingMatches();
        handler.getManager().getLayoutMatchPolicy().addMatchForTransition((BlockArchitecture)context.getSemanticElement(PHYSICAL_ARCHITECTURE));
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        handler.compare(source.getDiagramDescriptor(), target.getDiagramDescriptor(), false);
    }
}

