/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;
import org.polarsys.capella.core.platform.sirius.ui.actions.AllocationManagementAction;
import org.polarsys.capella.core.preferences.Activator;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;

public class AllocationManagementTest
extends BasicTestCase {
    private static final String MODEL_NAME = "allocation-management";
    private FunctionalExchange fe1;
    private FunctionalExchange fe2;
    private FunctionalExchange fe3;
    private FunctionalExchange fe4;
    private ComponentExchange ce1;
    private ComponentExchange ce2;
    private ComponentExchange ce3;
    private ComponentExchange ce4;
    private PhysicalLink pl1;
    private PhysicalLink pl2;
    private PhysicalLink pl3;
    private PhysicalLink pl4;

    protected void setUp() throws Exception {
        super.setUp();
        Session session = this.getSession(MODEL_NAME);
        SessionContext sessionContext = new SessionContext(session);
        this.fe1 = (FunctionalExchange)sessionContext.getSemanticElement("57311489-631f-4f25-91fb-98ec98a841a6");
        this.fe2 = (FunctionalExchange)sessionContext.getSemanticElement("8dc491f1-e024-4556-8d94-ac7d0a6c7c5c");
        this.fe3 = (FunctionalExchange)sessionContext.getSemanticElement("568b896a-4b2a-48dd-ba95-e58b1ea0bc16");
        this.fe4 = (FunctionalExchange)sessionContext.getSemanticElement("c9c6c219-5908-4a86-97af-e7a903abb487");
        this.ce1 = (ComponentExchange)sessionContext.getSemanticElement("4aaba939-4f3b-4a23-bf3a-fc76085c6bbc");
        this.ce2 = (ComponentExchange)sessionContext.getSemanticElement("2958ba11-a790-4ce1-ac3a-8ea120efdd3c");
        this.ce3 = (ComponentExchange)sessionContext.getSemanticElement("9e5ed466-aa26-41e9-88c1-63f565e5c338");
        this.ce4 = (ComponentExchange)sessionContext.getSemanticElement("f3e3d39d-f52c-4adf-b0c1-82361892ea4c");
        this.pl1 = (PhysicalLink)sessionContext.getSemanticElement("833b3d46-755d-46cf-9f98-294927a0cdcb");
        this.pl2 = (PhysicalLink)sessionContext.getSemanticElement("c6914540-3b8a-4e2e-9b48-18284bfb7577");
        this.pl3 = (PhysicalLink)sessionContext.getSemanticElement("4c021004-eaea-4c45-aa33-3abdd54b59fb");
        this.pl4 = (PhysicalLink)sessionContext.getSemanticElement("49c0e7ee-a929-4184-a1eb-fb2f64b9a068");
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList(MODEL_NAME);
    }

    public void test() throws Exception {
        this.assertFunctionalExchangeToComponentExchangeAllocationInDeployedComponent();
        this.assertFunctionalExchangeToComponentExchangeAllocationInDeployedActor();
        this.assertComponentExchangeToPhysicalLinkAllocationInDeployedComponent();
        this.assertComponentExchangeToPhysicalLinkAllocationInInDeployedActor();
    }

    protected void assertFunctionalExchangeToComponentExchangeAllocationInDeployedComponent() {
        this.assertFunctionalExchangeToComponentExchangeAllocation(this.fe1, this.ce1, true);
        this.assertFunctionalExchangeToComponentExchangeAllocation(this.fe2, this.ce2, false);
    }

    protected void assertFunctionalExchangeToComponentExchangeAllocationInDeployedActor() {
        this.assertFunctionalExchangeToComponentExchangeAllocation(this.fe3, this.ce3, true);
        this.assertFunctionalExchangeToComponentExchangeAllocation(this.fe4, this.ce4, false);
    }

    protected void assertComponentExchangeToPhysicalLinkAllocationInDeployedComponent() {
        this.assertComponentExchangeToPhysicalLinkAllocation(this.ce1, this.pl1, true);
        this.assertComponentExchangeToPhysicalLinkAllocation(this.ce2, this.pl2, false);
    }

    protected void assertComponentExchangeToPhysicalLinkAllocationInInDeployedActor() {
        this.assertComponentExchangeToPhysicalLinkAllocation(this.ce3, this.pl3, true);
        this.assertComponentExchangeToPhysicalLinkAllocation(this.ce4, this.pl4, false);
    }

    protected void assertFunctionalExchangeToComponentExchangeAllocation(final FunctionalExchange functionalExchange, final ComponentExchange componentExchange, boolean syncFunctionPortsToComponentPorts) {
        Activator.getDefault().getPreferenceStore().putValue("sync.componentport2functionport.allowed", String.valueOf(syncFunctionPortsToComponentPorts));
        AllocationManagementTest.assertEquals((boolean)syncFunctionPortsToComponentPorts, (boolean)CapellaModelPreferencesPlugin.getDefault().isSynchronizationOfComponentPortToFunctionPortAllowed());
        TransactionHelper.getExecutionManager((EObject)functionalExchange).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                AllocationManagementAction.getInstance().allocatingFEsToComponentExchanges(Arrays.asList(functionalExchange), (EObject)componentExchange);
            }
        });
        AllocationManagementTest.assertTrue((boolean)functionalExchange.getAllocatingComponentExchanges().contains((Object)componentExchange));
        AllocationManagementTest.assertTrue((boolean)componentExchange.getAllocatedFunctionalExchanges().contains((Object)functionalExchange));
        FunctionOutputPort sourceFunctionOutputPort = functionalExchange.getSourceFunctionOutputPort();
        FunctionInputPort targetFunctionInputPort = functionalExchange.getTargetFunctionInputPort();
        ComponentPort sourceComponentPort = (ComponentPort)componentExchange.getSourcePort();
        ComponentPort targetComponentPort = (ComponentPort)componentExchange.getTargetPort();
        if (syncFunctionPortsToComponentPorts) {
            AllocationManagementTest.assertTrue((boolean)sourceFunctionOutputPort.getAllocatorComponentPorts().contains((Object)sourceComponentPort));
            AllocationManagementTest.assertTrue((boolean)targetFunctionInputPort.getAllocatorComponentPorts().contains((Object)targetComponentPort));
            AllocationManagementTest.assertTrue((boolean)sourceComponentPort.getAllocatedFunctionPorts().contains((Object)sourceFunctionOutputPort));
            AllocationManagementTest.assertTrue((boolean)targetComponentPort.getAllocatedFunctionPorts().contains((Object)targetFunctionInputPort));
        } else {
            AllocationManagementTest.assertTrue((boolean)sourceFunctionOutputPort.getAllocatorComponentPorts().isEmpty());
            AllocationManagementTest.assertTrue((boolean)targetFunctionInputPort.getAllocatorComponentPorts().isEmpty());
            AllocationManagementTest.assertTrue((boolean)sourceComponentPort.getAllocatedFunctionPorts().isEmpty());
            AllocationManagementTest.assertTrue((boolean)targetComponentPort.getAllocatedFunctionPorts().isEmpty());
        }
    }

    protected void assertComponentExchangeToPhysicalLinkAllocation(final ComponentExchange componentExchange, final PhysicalLink physicalLink, boolean syncPhysicalPortsToComponentPorts) {
        Activator.getDefault().getPreferenceStore().putValue("sync.physicalport2componentport.physicallink.allowed", String.valueOf(syncPhysicalPortsToComponentPorts));
        AllocationManagementTest.assertEquals((boolean)syncPhysicalPortsToComponentPorts, (boolean)CapellaModelPreferencesPlugin.getDefault().isSynchronizationOfPhysicalPortToComponentPortOnPhysicalLinkAllowed());
        TransactionHelper.getExecutionManager((EObject)componentExchange).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                AllocationManagementAction.getInstance().allocatingCEsToPhysicalLinks(Arrays.asList(componentExchange), (EObject)physicalLink);
            }
        });
        AllocationManagementTest.assertTrue((boolean)componentExchange.getAllocatorPhysicalLinks().contains((Object)physicalLink));
        AllocationManagementTest.assertTrue((boolean)physicalLink.getAllocatedComponentExchanges().contains((Object)componentExchange));
        ComponentPort sourceComponentPort = (ComponentPort)componentExchange.getSourcePort();
        ComponentPort targetComponentPort = (ComponentPort)componentExchange.getTargetPort();
        PhysicalPort sourcePhysicalPort = physicalLink.getSourcePhysicalPort();
        PhysicalPort targetPhysicalPort = physicalLink.getTargetPhysicalPort();
        if (syncPhysicalPortsToComponentPorts) {
            sourceComponentPort.getAllocatingPhysicalPorts().contains((Object)sourcePhysicalPort);
            targetComponentPort.getAllocatingPhysicalPorts().contains((Object)targetPhysicalPort);
            sourcePhysicalPort.getAllocatedComponentPorts().contains((Object)sourceComponentPort);
            targetPhysicalPort.getAllocatedComponentPorts().contains((Object)targetComponentPort);
        } else {
            sourceComponentPort.getAllocatingPhysicalPorts().isEmpty();
            targetComponentPort.getAllocatingPhysicalPorts().isEmpty();
            sourcePhysicalPort.getAllocatedComponentPorts().isEmpty();
            targetPhysicalPort.getAllocatedComponentPorts().isEmpty();
        }
    }
}

