/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.properties.fields.PhysicalComponentNatureGroup;
import org.polarsys.capella.core.data.pa.properties.sections.PhysicalComponentSection;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;
import org.polarsys.capella.core.preferences.Activator;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CheckPhysCompNatureOptionTestCase
extends BasicTestCase {
    private ScopedPreferenceStore preferenceStore;
    private static final String PROJECT_NAME = "component-breakdown";

    public void test() {
        this.preferenceStore = (ScopedPreferenceStore)Activator.getDefault().getPreferenceStore();
        Session session = this.getSession(PROJECT_NAME);
        CheckPhysCompNatureOptionTestCase.assertNotNull((Object)session);
        this.updateDataPreferences("true");
        CheckPhysCompNatureOptionTestCase.assertTrue((boolean)CapellaModelPreferencesPlugin.getDefault().isChangePhysicalComponentNatureAllowed());
        SessionContext context = new SessionContext(session);
        String idPhysComp_01 = "6a369845-b31c-4c9f-b586-3b659d245b88";
        PhysicalComponent PC_01 = (PhysicalComponent)context.getSemanticElement(idPhysComp_01);
        this.checkPhysicalComponentSection(PC_01, true);
        this.updateDataPreferences("false");
        CheckPhysCompNatureOptionTestCase.assertFalse((boolean)CapellaModelPreferencesPlugin.getDefault().isChangePhysicalComponentNatureAllowed());
        this.checkPhysicalComponentSection(PC_01, false);
    }

    protected void checkPhysicalComponentSection(PhysicalComponent physicalComponent, boolean checkCriteria) {
        PhysicalComponentSection physicalComponentSection = new PhysicalComponentSection();
        CheckPhysCompNatureOptionTestCase.assertTrue((boolean)physicalComponentSection.select((Object)physicalComponent));
        Shell temporaryShell = new Shell();
        physicalComponentSection.createControls((Composite)temporaryShell, null);
        physicalComponentSection.loadData((EObject)physicalComponent);
        List semanticFields = physicalComponentSection.getSemanticFields();
        for (AbstractSemanticField crtSemanticField : semanticFields) {
            if (!(crtSemanticField instanceof PhysicalComponentNatureGroup)) continue;
            PhysicalComponentNatureGroup pcNatureGrp = (PhysicalComponentNatureGroup)crtSemanticField;
            List pcNatureButtons = pcNatureGrp.getSemanticFields();
            for (Button pcNatureBtn : pcNatureButtons) {
                CheckPhysCompNatureOptionTestCase.assertEquals((boolean)pcNatureBtn.isEnabled(), (boolean)checkCriteria);
            }
        }
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList(PROJECT_NAME);
    }

    private void updateDataPreferences(String newPref) {
        this.preferenceStore.putValue("data.physical.component.nature.change", newPref);
        String tmpCheckPref = this.preferenceStore.getString("data.physical.component.nature.change");
        CheckPhysCompNatureOptionTestCase.assertTrue((boolean)tmpCheckPref.equals(newPref));
    }
}

