/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class DDiagramEditorUndoRedoHandlerTest
extends BasicTestCase {
    String projectTestName = "StatusLine";
    DataPkg root;
    DRepresentation d1;
    DRepresentation d2;

    public void testDDiagramEditorUndoHandler(final Session session) throws ExecutionException, PartInitException {
        AbstractEMFOperation prepareDiagrams = new AbstractEMFOperation(TransactionHelper.getEditingDomain((Session)session), "prepare"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Resource resource = TestHelper.getSemanticResource((Session)session);
                DDiagramEditorUndoRedoHandlerTest.this.root = (DataPkg)TestHelper.getFirstMatchingObject((Resource)resource, (EClass)InformationPackage.Literals.DATA_PKG);
                DataPkg p1 = InformationFactory.eINSTANCE.createDataPkg("p1");
                DataPkg p2 = InformationFactory.eINSTANCE.createDataPkg("p2");
                DDiagramEditorUndoRedoHandlerTest.this.root.getOwnedDataPkgs().add((Object)p1);
                DDiagramEditorUndoRedoHandlerTest.this.root.getOwnedDataPkgs().add((Object)p2);
                RepresentationDescription cdb1Description = DiagramHelper.getRepresentationDescription((Session)session, (EObject)p1, (String)"Class Diagram Blank");
                RepresentationDescription cdb2Description = DiagramHelper.getRepresentationDescription((Session)session, (EObject)p2, (String)"Class Diagram Blank");
                DDiagramEditorUndoRedoHandlerTest.this.d1 = DialectManager.INSTANCE.createRepresentation("p1", (EObject)p1, cdb1Description, session, (IProgressMonitor)new NullProgressMonitor());
                DDiagramEditorUndoRedoHandlerTest.this.d2 = DialectManager.INSTANCE.createRepresentation("p2", (EObject)p2, cdb2Description, session, (IProgressMonitor)new NullProgressMonitor());
                return Status.OK_STATUS;
            }
        };
        IStatus status = this.getOperationHistory().execute((IUndoableOperation)prepareDiagrams, (IProgressMonitor)new NullProgressMonitor(), null);
        DDiagramEditorUndoRedoHandlerTest.assertEquals((Object)Status.OK_STATUS, (Object)status);
        IEditorPart d1Editor = DiagramHelper.opendiagramEditor((Session)session, (DRepresentation)this.d1);
        IEditorPart d2Editor = DiagramHelper.opendiagramEditor((Session)session, (DRepresentation)this.d2);
        TestOperation testOperation = new TestOperation("testOperation");
        testOperation.addContext(this.getUndoContext(session));
        this.getOperationHistory().execute((IUndoableOperation)testOperation, (IProgressMonitor)new NullProgressMonitor(), null);
        DDiagramEditorUndoRedoHandlerTest.assertSame((Object)((Object)TestOperationState.EXECUTE), (Object)((Object)testOperation.getState()));
        IAction d1UndoAction = d1Editor.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.UNDO.getId());
        DDiagramEditorUndoRedoHandlerTest.assertTrue((boolean)d1UndoAction.isEnabled());
        DDiagramEditorUndoRedoHandlerTest.assertTrue((boolean)d1UndoAction.isHandled());
        IAction d2UndoAction = d2Editor.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.UNDO.getId());
        DDiagramEditorUndoRedoHandlerTest.assertTrue((boolean)d2UndoAction.isEnabled());
        DDiagramEditorUndoRedoHandlerTest.assertTrue((boolean)d2UndoAction.isHandled());
        d2Editor.getSite().getPage().closeEditor(d2Editor, false);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)d1Editor);
        DDiagramEditorUndoRedoHandlerTest.assertTrue((boolean)d1UndoAction.isEnabled());
        DDiagramEditorUndoRedoHandlerTest.assertTrue((boolean)d1UndoAction.isHandled());
        d1UndoAction.run();
        DDiagramEditorUndoRedoHandlerTest.assertSame((Object)((Object)testOperation.getState()), (Object)((Object)TestOperationState.UNDO));
        IViewPart explorer = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("capella.project.explorer");
        ((CommonNavigator)explorer).getCommonViewer().expandToLevel((Object)this.root, 0);
        ((ISetSelectionTarget)explorer).selectReveal((ISelection)new StructuredSelection((Object)this.root));
        IAction explorerRedo = explorer.getViewSite().getActionBars().getGlobalActionHandler(ActionFactory.REDO.getId());
        DDiagramEditorUndoRedoHandlerTest.assertTrue((boolean)explorerRedo.isEnabled());
        DDiagramEditorUndoRedoHandlerTest.assertTrue((boolean)explorerRedo.isHandled());
        explorerRedo.run();
        DDiagramEditorUndoRedoHandlerTest.assertSame((Object)((Object)testOperation.getState()), (Object)((Object)TestOperationState.REDO));
    }

    protected IOperationHistory getOperationHistory() {
        return OperationHistoryFactory.getOperationHistory();
    }

    protected IUndoContext getUndoContext(Session session) {
        return ((IWorkspaceCommandStack)TransactionHelper.getEditingDomain((Session)session).getCommandStack()).getDefaultUndoContext();
    }

    public void test() throws Exception {
        Session session = this.getSession(this.projectTestName);
        this.testDDiagramEditorUndoHandler(session);
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.projectTestName);
    }

    class TestOperation
    extends AbstractOperation {
        private TestOperationState state;

        public TestOperation(String label) {
            super(label);
            this.state = null;
        }

        public TestOperationState getState() {
            return this.state;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.state = TestOperationState.EXECUTE;
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.state = TestOperationState.REDO;
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.state = TestOperationState.UNDO;
            return Status.OK_STATUS;
        }
    }

    static enum TestOperationState {
        EXECUTE,
        UNDO,
        REDO;

    }
}

