/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import org.polarsys.capella.core.model.helpers.graph.BasicGraph;
import org.polarsys.capella.core.model.helpers.graph.GraphEdge;
import org.polarsys.capella.core.model.helpers.graph.GraphNode;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class GraphTest
extends BasicTestCase {
    public void test() throws Exception {
        BasicGraph g = new BasicGraph((Object)"ij");
        BasicGraph.Node a = (BasicGraph.Node)g.getOrCreateNode((Object)"A");
        BasicGraph.Node b = (BasicGraph.Node)g.getOrCreateNode((Object)"B");
        BasicGraph.Node c = (BasicGraph.Node)g.getOrCreateNode((Object)"C");
        BasicGraph.Edge ab = (BasicGraph.Edge)g.getOrCreateEdge((Object)"AB");
        ab.setSource((GraphNode)a);
        ab.setTarget((GraphNode)b);
        BasicGraph.Edge ac = (BasicGraph.Edge)g.getOrCreateEdge((Object)"AC");
        ac.setSource((GraphNode)a);
        ac.setTarget((GraphNode)c);
        BasicGraph.Edge ba = (BasicGraph.Edge)g.getOrCreateEdge((Object)"BA");
        ba.setSource((GraphNode)b);
        ba.setTarget((GraphNode)a);
        GraphTest.assertTrue((boolean)c.getIncomingEdges().contains(ac));
        GraphTest.assertTrue((boolean)c.getOutgoingEdges().isEmpty());
        GraphTest.assertTrue((boolean)a.getIncomingEdges().contains(ba));
        GraphTest.assertTrue((boolean)a.getOutgoingEdges().contains(ac));
        GraphTest.assertTrue((boolean)a.getOutgoingEdges().contains(ab));
        GraphTest.assertTrue((boolean)b.getIncomingEdges().contains(ab));
        GraphTest.assertTrue((boolean)b.getOutgoingEdges().contains(ba));
        g.mergeNodes((GraphNode)b, (GraphNode)c, (Object)"B2");
        GraphTest.assertTrue((boolean)g.hasNode((Object)"B2"));
        GraphTest.assertTrue((boolean)b.getIncomingEdges().isEmpty());
        GraphTest.assertTrue((boolean)b.getOutgoingEdges().isEmpty());
        GraphTest.assertTrue((boolean)c.getIncomingEdges().isEmpty());
        GraphTest.assertTrue((boolean)c.getOutgoingEdges().isEmpty());
        GraphTest.assertTrue((!g.hasNode((Object)"B") ? 1 : 0) != 0);
        GraphTest.assertTrue((!g.hasNode((Object)"C") ? 1 : 0) != 0);
        BasicGraph.Node b2 = (BasicGraph.Node)g.getOrCreateNode((Object)"B2");
        GraphTest.assertTrue((ab.getTarget() == b2 ? 1 : 0) != 0);
        GraphTest.assertTrue((ac.getTarget() == b2 ? 1 : 0) != 0);
        GraphTest.assertTrue((ba.getSource() == b2 ? 1 : 0) != 0);
        GraphTest.assertTrue((boolean)b2.getIncomingEdges().contains(ab));
        GraphTest.assertTrue((boolean)b2.getIncomingEdges().contains(ac));
        GraphTest.assertTrue((boolean)b2.getOutgoingEdges().contains(ba));
        g.removeEdge((GraphEdge)ab);
        GraphTest.assertTrue((ab.getSource() == null ? 1 : 0) != 0);
        GraphTest.assertTrue((ab.getTarget() == null ? 1 : 0) != 0);
        GraphTest.assertTrue((!g.hasEdge((Object)((String)ab.getSemantic())) ? 1 : 0) != 0);
        GraphTest.assertTrue((!b2.getIncomingEdges().contains(ab) ? 1 : 0) != 0);
        GraphTest.assertTrue((!a.getOutgoingEdges().contains(ab) ? 1 : 0) != 0);
    }
}

