/*******************************************************************************
 * Copyright (c) 2019, 2020 THALES GLOBAL SERVICES.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.test.diagram.tools.ju.cdb;

import org.polarsys.capella.test.diagram.common.ju.context.CDBDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.CDBDiagram.ExchangeItemType;
import org.polarsys.capella.test.diagram.tools.ju.model.CDBCommunication;
import org.polarsys.capella.test.diagram.tools.ju.model.settings.CDBProjectSettings;

/**
 *
 */
public class InsertRemoveExchangeItems extends CDBCommunication {

  public InsertRemoveExchangeItems(CDBProjectSettings settings) {
    super(settings);
  }

  @Override
  protected void testCDB() {
    cdb = CDBDiagram.createDiagram(context, settings.DATAPKG);
    testInsertRemoveExchangeItems(ExchangeItemType.EVENT);
    testInsertRemoveExchangeItems(ExchangeItemType.OPERATION);
    testInsertRemoveExchangeItems(ExchangeItemType.FLOW);
    testInsertRemoveExchangeItems(ExchangeItemType.DATA);
    testInsertRemoveExchangeItems(ExchangeItemType.UNDEFINED);
  }

  protected void testInsertRemoveExchangeItems(ExchangeItemType eiType) {
    String ei1 = cdb.createNodeExchangeItem(eiType);
    String ei2 = cdb.createNodeExchangeItem(eiType);

    cdb.removeExchangeItem(ei1, ei2);
    cdb.insertExchangeItem(ei1, ei2);
  }
}
