/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.ccri;

import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateNodeTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CreateDiagramElement
extends AbstractDiagramTestCase {
    private String PHYSICAL_CCRI_DIAGRAM = "Physical Contextual Capability Realization Involvement Diagram";
    private String LOGICAL_CRI_DIAGRAM = "Logical Contextual Capability Realization Involvement Diagram";
    private String elementType;

    public CreateDiagramElement(String elementType) {
        this.elementType = elementType;
    }

    protected String getRequiredTestModel() {
        return "DiagramAction";
    }

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        DiagramContext physicalDiagramContext = (DiagramContext)new OpenDiagramStep(context, this.PHYSICAL_CCRI_DIAGRAM).run();
        DDiagram physicalCCRIDiagram = physicalDiagramContext.getDiagram();
        int originalPhysicalDiagramSize = physicalCCRIDiagram.getDiagramElements().size();
        new CreateNodeTool(physicalDiagramContext, this.elementType, physicalDiagramContext.getDiagramId()).run();
        DiagramContext logicalDiagramContext = (DiagramContext)new OpenDiagramStep(context, this.LOGICAL_CRI_DIAGRAM).run();
        DDiagram logicalCCRIDiagram = logicalDiagramContext.getDiagram();
        int originalLogicalDiagramSize = logicalCCRIDiagram.getDiagramElements().size();
        new CreateNodeTool(logicalDiagramContext, this.elementType, logicalDiagramContext.getDiagramId()).run();
        CreateDiagramElement.assertEquals((String)"Wrong number of DiagramElements in the Physical CCRI Diagram", (int)(originalPhysicalDiagramSize + 1), (int)physicalCCRIDiagram.getDiagramElements().size());
        CreateDiagramElement.assertEquals((String)"Wrong number of DiagramElements in the Logical CCRI Diagram", (int)(originalLogicalDiagramSize + 1), (int)logicalCCRIDiagram.getDiagramElements().size());
    }
}

