/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.ccri;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateNodeTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CreateEdges
extends AbstractDiagramTestCase {
    private String PHYSICAL_CCRI_DIAGRAM = "Physical Contextual Capability Realization Involvement Diagram";
    private String LOGICAL_CRI_DIAGRAM = "Logical Contextual Capability Realization Involvement Diagram";
    private String mainPhysicalCapabilityRealizationID = "a75a0f75-102e-464d-8ea3-c846002da06b";
    private String mainLogicalCapabilityRealizationID = "2e82c298-dfdd-4a30-9bd7-6d50ecab3df7";
    private String createdPhysicalActorNameAndID = "NewPhysicalActor";
    private String createdLogicalActorNameAndID = "NewLogicalActor";
    private String createdPhysicalComponentNameAndID = "NewPhysicalComponent";
    private String createdLogicalComponentNameAndID = "NewLogicalComponent";

    private void setName(ExecutionManager executionManager, NamedElement object, String newName) {
        final String finalNewName = newName;
        final NamedElement finalObject = object;
        executionManager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                finalObject.setName(finalNewName);
            }
        });
    }

    private void createElementAndSetName(DiagramContext diagramContext, String toolName, String elementNameAndID) {
        DDiagramElement diagramElement = (DDiagramElement)new CreateNodeTool(diagramContext, toolName, diagramContext.getDiagramId(), elementNameAndID).run();
        ExecutionManager executionManager = TransactionHelper.getExecutionManager((EObject)diagramElement.getTarget());
        this.setName(executionManager, (NamedElement)diagramElement.getTarget(), elementNameAndID);
    }

    protected String getRequiredTestModel() {
        return "DiagramAction";
    }

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        DiagramContext physicalDiagramContext = (DiagramContext)new OpenDiagramStep(context, this.PHYSICAL_CCRI_DIAGRAM).run();
        this.createElementAndSetName(physicalDiagramContext, "actor", this.createdPhysicalActorNameAndID);
        this.createElementAndSetName(physicalDiagramContext, "component", this.createdPhysicalComponentNameAndID);
        new CreateEdgeTool(physicalDiagramContext, "involvement", "INV 1", this.mainPhysicalCapabilityRealizationID, this.createdPhysicalActorNameAndID, 1).run();
        new CreateEdgeTool(physicalDiagramContext, "involvement", "INV 2", this.mainPhysicalCapabilityRealizationID, this.createdPhysicalComponentNameAndID, 1).run();
        DiagramContext logicalDiagramContext = (DiagramContext)new OpenDiagramStep(context, this.LOGICAL_CRI_DIAGRAM).run();
        this.createElementAndSetName(logicalDiagramContext, "actor", this.createdLogicalActorNameAndID);
        this.createElementAndSetName(logicalDiagramContext, "component", this.createdLogicalComponentNameAndID);
        new CreateEdgeTool(logicalDiagramContext, "involvement", "INV 1", this.mainLogicalCapabilityRealizationID, this.createdLogicalActorNameAndID, 1).run();
        new CreateEdgeTool(logicalDiagramContext, "involvement", "INV 2", this.mainLogicalCapabilityRealizationID, this.createdLogicalComponentNameAndID, 1).run();
    }
}

