/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.cdb;

import org.polarsys.capella.test.diagram.common.ju.context.CDBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.CDBCommunication;
import org.polarsys.capella.test.diagram.tools.ju.model.settings.CDBProjectSettings;
import org.polarsys.capella.test.diagram.tools.ju.model.settings.OA_CDBProjectSettings;
import org.polarsys.capella.test.framework.context.SessionContext;

public class InsertRemoveDataTypes
extends CDBCommunication {
    public InsertRemoveDataTypes(CDBProjectSettings settings) {
        super(settings);
    }

    @Override
    protected void testCDB() {
        this.cdb = CDBDiagram.createDiagram((SessionContext)this.context, (String)this.settings.DATAPKG);
        this.testInsertRemoveDataType(CDBDiagram.DataType.BOOLEAN_TYPE);
        this.testInsertRemoveDataType(CDBDiagram.DataType.ENUMERATION);
        this.testInsertRemoveDataType(CDBDiagram.DataType.NUMERIC_TYPE);
        this.testInsertRemoveDataType(CDBDiagram.DataType.PHYSICAL_QUANTITY);
        this.testInsertRemoveDataType(CDBDiagram.DataType.STRING_TYPE);
        if (!(this.settings instanceof OA_CDBProjectSettings)) {
            this.testInsertRemovePredefinedDataType();
        }
        this.testInsertRemoveClass();
        this.testInsertRemoveUnion();
        this.testInsertRemoveCollection();
    }

    protected void testInsertRemoveDataType(CDBDiagram.DataType dataType) {
        String type1 = this.cdb.createDataType(dataType);
        String type2 = this.cdb.createDataType(dataType);
        this.cdb.removeType(new String[]{type1, type2});
        this.cdb.insertType(new String[]{type1, type2});
    }

    protected void testInsertRemovePredefinedDataType() {
        this.cdb.insertType(new String[]{this.settings.PREDEFINED_DATATYPE_BOOLEAN, this.settings.PREDEFINED_DATATYPE_CHAR, this.settings.PREDEFINED_DATATYPE_STRING});
        this.cdb.removeType(new String[]{this.settings.PREDEFINED_DATATYPE_BOOLEAN, this.settings.PREDEFINED_DATATYPE_CHAR, this.settings.PREDEFINED_DATATYPE_STRING});
    }

    protected void testInsertRemoveClass() {
        String type1 = this.cdb.createClass();
        String type2 = this.cdb.createClass();
        this.cdb.removeType(new String[]{type1, type2});
        this.cdb.insertType(new String[]{type1, type2});
    }

    protected void testInsertRemoveUnion() {
        String type1 = this.cdb.createUnion();
        String type2 = this.cdb.createUnion();
        this.cdb.removeType(new String[]{type1, type2});
        this.cdb.insertType(new String[]{type1, type2});
    }

    protected void testInsertRemoveCollection() {
        String type1 = this.cdb.createCollection();
        String type2 = this.cdb.createCollection();
        this.cdb.removeType(new String[]{type1, type2});
        this.cdb.insertType(new String[]{type1, type2});
    }
}

