/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.idb;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.test.diagram.common.ju.context.IDBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.TestHelper;
import org.polarsys.capella.test.framework.model.GenericModel;

public class CreateComponent_Nature
extends EmptyProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.init(context);
        this.testOn(context, "Interfaces Diagram Blank", "16953dc7-be25-45ef-9da9-32869d0cb53f", true);
        this.testOnInternal(context, "Contextual Component Internal Interfaces", GenericModel.PC_1, true);
        this.testOnExternal(context, "Contextual Component External Interfaces", GenericModel.PC_1, false);
    }

    private void init(SessionContext context) {
        IDBDiagram idb = IDBDiagram.createDiagram((SessionContext)context, (String)"Interfaces Diagram Blank", (String)"16953dc7-be25-45ef-9da9-32869d0cb53f");
        idb.createComponent(GenericModel.BEHAVIOR_1);
        idb.createComponent(GenericModel.NODE_1);
        this.setNature(context, GenericModel.NODE_1, PhysicalComponentNature.NODE);
        idb.createComponent(GenericModel.NODE_1, GenericModel.NODE_1_1);
    }

    public void testOn(SessionContext context, String diagramKind, String root, boolean checkSubComponents) throws Exception {
        IDBDiagram idb = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)"16953dc7-be25-45ef-9da9-32869d0cb53f");
        idb.createComponent(GenericModel.BEHAVIOR_2);
        this.checkNature(context, GenericModel.BEHAVIOR_2, PhysicalComponentNature.BEHAVIOR);
        idb.createComponent(GenericModel.NODE_2);
        this.setNature(context, GenericModel.NODE_2, PhysicalComponentNature.NODE);
        idb.createComponent(GenericModel.NODE_2, GenericModel.NODE_2_1);
        this.checkNature(context, GenericModel.NODE_2_1, PhysicalComponentNature.NODE);
        idb.createComponent(GenericModel.BEHAVIOR_2, GenericModel.BEHAVIOR_2_1);
        this.checkNature(context, GenericModel.BEHAVIOR_2_1, PhysicalComponentNature.BEHAVIOR);
        idb = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)GenericModel.BEHAVIOR_1);
        idb.createComponent(GenericModel.BEHAVIOR_1_1);
        this.checkNature(context, GenericModel.BEHAVIOR_1_1, PhysicalComponentNature.BEHAVIOR);
        idb = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)GenericModel.NODE_1);
        idb.createComponent(GenericModel.NODE_1_1);
        this.checkNature(context, GenericModel.NODE_1_1, PhysicalComponentNature.NODE);
    }

    public void testOnInternal(SessionContext context, String diagramKind, String root, boolean checkSubComponents) throws Exception {
        IDBDiagram cii = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)"16953dc7-be25-45ef-9da9-32869d0cb53f");
        cii.createComponent("16953dc7-be25-45ef-9da9-32869d0cb53f", GenericModel.BEHAVIOR_2);
        this.checkNature(context, GenericModel.BEHAVIOR_2, PhysicalComponentNature.BEHAVIOR);
        cii.createComponent("16953dc7-be25-45ef-9da9-32869d0cb53f", GenericModel.NODE_2);
        this.setNature(context, GenericModel.NODE_2, PhysicalComponentNature.NODE);
        cii.createComponent(GenericModel.NODE_2, GenericModel.NODE_2_1);
        this.checkNature(context, GenericModel.NODE_2_1, PhysicalComponentNature.NODE);
        cii.createComponent(GenericModel.BEHAVIOR_2, GenericModel.BEHAVIOR_2_1);
        this.checkNature(context, GenericModel.BEHAVIOR_2_1, PhysicalComponentNature.BEHAVIOR);
        cii = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)GenericModel.BEHAVIOR_1);
        cii.createComponent(GenericModel.BEHAVIOR_1_1);
        this.checkNature(context, GenericModel.BEHAVIOR_1_1, PhysicalComponentNature.BEHAVIOR);
        cii = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)GenericModel.NODE_1);
        cii.createComponent(GenericModel.PC_1);
        this.checkNature(context, GenericModel.PC_1, PhysicalComponentNature.BEHAVIOR);
        cii.createComponent(GenericModel.NODE_1, GenericModel.PC_1);
        this.checkNature(context, GenericModel.PC_1, PhysicalComponentNature.NODE);
        cii = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)GenericModel.NODE_1_1);
        cii.createComponent(GenericModel.PC_1);
        this.checkNature(context, GenericModel.PC_1, PhysicalComponentNature.NODE);
    }

    public void testOnExternal(SessionContext context, String diagramKind, String root, boolean checkSubComponents) throws Exception {
        IDBDiagram cei = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)GenericModel.BEHAVIOR_1);
        cei.createComponent(GenericModel.BEHAVIOR_1_1);
        this.checkNature(context, GenericModel.BEHAVIOR_1_1, PhysicalComponentNature.BEHAVIOR);
        cei = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)GenericModel.NODE_1);
        cei.createComponent(GenericModel.BEHAVIOR_2);
        this.checkNature(context, GenericModel.BEHAVIOR_2, PhysicalComponentNature.BEHAVIOR);
        cei = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)GenericModel.NODE_1_1);
        cei.createComponent(GenericModel.PC_1);
        this.checkNature(context, GenericModel.PC_1, PhysicalComponentNature.NODE);
    }

    private void checkNature(SessionContext context, String id, PhysicalComponentNature nature) {
        PhysicalComponent component = (PhysicalComponent)context.getSemanticElement(id);
        CreateComponent_Nature.assertTrue((String)NLS.bind((String)"Component ''{0}'' must be ''{1}''", (Object)id, (Object)nature), (component.getNature() == nature ? 1 : 0) != 0);
    }

    public void setNature(final SessionContext session, final String component, final PhysicalComponentNature nature) {
        TestHelper.getExecutionManager((Session)session.getSession()).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                ((PhysicalComponent)session.getSemanticElement(component)).setNature(nature);
            }
        });
    }
}

