/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.idb;

import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.test.diagram.common.ju.context.IDBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.idb.IDBProject;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CreateGeneralization
extends IDBProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.init(context);
        this.testOnDiagram(context, "Interfaces Diagram Blank", "32f06455-48c7-4d68-aea5-cf397ab4aff2");
        this.testOnDiagram(context, "Contextual Component Detailed Interfaces", this.componentContext);
        this.testOnDiagram(context, "Contextual Component External Interfaces", this.componentContext);
        this.testOnDiagram(context, "Contextual Component Internal Interfaces", this.componentContext);
    }

    @Override
    protected void testOnDiagram(SessionContext context, String diagramKind, String targetId) {
        IDBDiagram idb = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)targetId);
        this.testInterfaces(idb);
        if (!"Contextual Component Detailed Interfaces".equals(idb.getType())) {
            this.testComponents(idb);
        }
    }

    private void testComponents(IDBDiagram idb) {
        SessionContext sessionContext = idb.getSessionContext();
        String component1 = idb.createComponent();
        String component2 = idb.createComponent();
        String component3 = idb.createComponent();
        sessionContext.setPreference("componentNonActorInheritance.allowed", false);
        sessionContext.setPreference("inheritance.allowed", false);
        idb.createGeneralizationNotEnabled(component1, component2);
        sessionContext.setPreference("componentNonActorInheritance.allowed", true);
        idb.createGeneralization(component2, component1);
        idb.createGeneralizationNotEnabled(component1, component2);
        sessionContext.setPreference("inheritance.allowed", true);
        idb.createGeneralization(component3, component1);
        idb.createGeneralizationNotEnabled(component1, component3);
    }

    private void testInterfaces(IDBDiagram idb) {
        String interface1 = idb.createInterface();
        String interface2 = idb.createInterface();
        String interface3 = idb.createInterface();
        idb.createGeneralization(interface2, interface1);
        idb.createGeneralization(interface3, interface2);
        idb.createGeneralizationNotEnabled(interface3, interface1);
        idb.createGeneralizationNotEnabled(interface1, interface2);
        idb.createGeneralizationNotEnabled(interface2, interface3);
    }
}

