/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.idb;

import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.test.diagram.common.ju.context.IDBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class InsertRelationship
extends EmptyProject {
    String interface1;
    String interface2;

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        IDBDiagram idb = IDBDiagram.createDiagram((SessionContext)context, (String)"32f06455-48c7-4d68-aea5-cf397ab4aff2");
        this.createComponents(idb);
        this.createCommunicationLinks(idb);
        this.createInterfacesLinks(idb);
        this.createGeneralizationLinks(idb);
        this.testInsertInterfacesLinksOnDiagram(context);
        this.testInsertInterfacesLinksOnLC2(context);
        this.testInsertCommunicationLinksOnDiagram(context);
        this.testInsertCommunicationLinksOnLC2(context);
        this.testInsertGeneralizationLinks(context);
    }

    protected void createComponents(IDBDiagram idb) {
        idb.createComponent(GenericModel.LC_1);
        idb.createComponent(GenericModel.LC_2);
        idb.createComponent(GenericModel.LC_2, GenericModel.LC_3);
        idb.createComponent(GenericModel.LC_2, GenericModel.LC_4);
    }

    protected void createInterfacesLinks(IDBDiagram idb) {
        this.interface1 = idb.createInterfaceInContainer(GenericModel.LC_2);
        this.interface2 = idb.createInterfaceInContainer(GenericModel.LC_2);
        idb.createUses(GenericModel.LC_1, this.interface1, GenericModel.OBJECT_1);
        idb.createImplements(GenericModel.LC_1, this.interface2, GenericModel.OBJECT_2);
    }

    protected void testInsertInterfacesLinksOnLC2(SessionContext context) {
        IDBDiagram idb = IDBDiagram.createDiagram((SessionContext)context, (String)"32f06455-48c7-4d68-aea5-cf397ab4aff2");
        idb.open();
        idb.insertComponents(new String[]{GenericModel.LC_1, GenericModel.LC_2});
        idb.insertRelationship(GenericModel.LC_1, new String[]{GenericModel.OBJECT_1});
        idb.hasView(GenericModel.OBJECT_1);
        idb.hasView(this.interface1);
        idb.insertRelationship(GenericModel.LC_1, new String[]{GenericModel.OBJECT_2});
        idb.hasView(GenericModel.OBJECT_2);
        idb.hasView(this.interface2);
        idb.mustGraphicalOwnedBy(this.interface1, GenericModel.LC_2);
        idb.mustGraphicalOwnedBy(this.interface2, GenericModel.LC_2);
    }

    protected void testInsertInterfacesLinksOnDiagram(SessionContext context) {
        IDBDiagram idb = IDBDiagram.createDiagram((SessionContext)context, (String)"32f06455-48c7-4d68-aea5-cf397ab4aff2");
        idb.open();
        idb.insertComponents(new String[]{GenericModel.LC_1});
        idb.insertRelationship(GenericModel.LC_1, new String[]{GenericModel.OBJECT_1});
        idb.hasView(GenericModel.OBJECT_1);
        idb.hasView(this.interface1);
        idb.insertRelationship(GenericModel.LC_1, new String[]{GenericModel.OBJECT_2});
        idb.hasView(GenericModel.OBJECT_2);
        idb.hasView(this.interface2);
        idb.mustGraphicalOwnedBy(this.interface1, idb.getDiagramId());
        idb.mustGraphicalOwnedBy(this.interface2, idb.getDiagramId());
    }

    private void createCommunicationLinks(IDBDiagram diagramContext) {
        diagramContext.createEvent(GenericModel.LC_2, GenericModel.EXCHANGE_ITEM_1);
        diagramContext.createEvent(GenericModel.LC_2, GenericModel.EXCHANGE_ITEM_2);
        diagramContext.createCommunicationLinkAcquire(GenericModel.LC_1, GenericModel.EXCHANGE_ITEM_1, GenericModel.CL_1);
        diagramContext.createCommunicationLinkAcquire(GenericModel.LC_1, GenericModel.EXCHANGE_ITEM_2, GenericModel.CL_2);
    }

    private void createGeneralizationLinks(IDBDiagram diagramContext) {
        SessionContext sessionContext = diagramContext.getSessionContext();
        sessionContext.setPreference("componentNonActorInheritance.allowed", true);
        sessionContext.setPreference("inheritance.allowed", true);
        diagramContext.createGeneralization(GenericModel.LC_1, GenericModel.LC_2, GenericModel.GENERALIZATION_2);
        diagramContext.createGeneralization(GenericModel.LC_1, GenericModel.LC_3, GenericModel.GENERALIZATION_3);
        diagramContext.createGeneralization(GenericModel.LC_1, GenericModel.LC_4, GenericModel.GENERALIZATION_4);
    }

    private void testInsertCommunicationLinksOnDiagram(SessionContext context) {
        IDBDiagram idb = IDBDiagram.createDiagram((SessionContext)context, (String)"32f06455-48c7-4d68-aea5-cf397ab4aff2");
        idb.open();
        idb.insertComponents(new String[]{GenericModel.LC_1});
        idb.insertRelationship(GenericModel.LC_1, new String[]{GenericModel.CL_1});
        idb.hasView(GenericModel.CL_1);
        idb.hasView(GenericModel.EXCHANGE_ITEM_1);
        idb.insertRelationship(GenericModel.LC_1, new String[]{GenericModel.CL_2});
        idb.hasView(GenericModel.CL_2);
        idb.hasView(GenericModel.EXCHANGE_ITEM_2);
        idb.mustGraphicalOwnedBy(GenericModel.EXCHANGE_ITEM_1, idb.getDiagramId());
        idb.mustGraphicalOwnedBy(GenericModel.EXCHANGE_ITEM_2, idb.getDiagramId());
    }

    private void testInsertCommunicationLinksOnLC2(SessionContext context) {
        IDBDiagram idb = IDBDiagram.createDiagram((SessionContext)context, (String)"32f06455-48c7-4d68-aea5-cf397ab4aff2");
        idb.open();
        idb.insertComponents(new String[]{GenericModel.LC_1, GenericModel.LC_2});
        idb.insertRelationship(GenericModel.LC_1, new String[]{GenericModel.CL_1});
        idb.hasView(GenericModel.CL_1);
        idb.hasView(GenericModel.EXCHANGE_ITEM_1);
        idb.insertRelationship(GenericModel.LC_1, new String[]{GenericModel.CL_2});
        idb.hasView(GenericModel.CL_2);
        idb.hasView(GenericModel.EXCHANGE_ITEM_2);
        idb.mustGraphicalOwnedBy(GenericModel.EXCHANGE_ITEM_1, GenericModel.LC_2);
        idb.mustGraphicalOwnedBy(GenericModel.EXCHANGE_ITEM_2, GenericModel.LC_2);
    }

    private void testInsertGeneralizationLinks(SessionContext context) {
        IDBDiagram idb = IDBDiagram.createDiagram((SessionContext)context, (String)"32f06455-48c7-4d68-aea5-cf397ab4aff2");
        idb.open();
        idb.insertComponents(new String[]{GenericModel.LC_1});
        idb.insertRelationship(GenericModel.LC_1, new String[]{GenericModel.GENERALIZATION_3});
        idb.hasView(GenericModel.GENERALIZATION_3);
        idb.hasView(GenericModel.LC_3);
        idb.mustGraphicalOwnedBy(GenericModel.LC_3, idb.getDiagramId());
        idb.insertRelationship(GenericModel.LC_1, new String[]{GenericModel.GENERALIZATION_2});
        idb.hasView(GenericModel.GENERALIZATION_2);
        idb.hasView(GenericModel.LC_2);
        idb.mustGraphicalOwnedBy(GenericModel.LC_2, idb.getDiagramId());
        idb.insertRelationship(GenericModel.LC_1, new String[]{GenericModel.GENERALIZATION_4});
        idb.hasView(GenericModel.GENERALIZATION_4);
        idb.hasView(GenericModel.LC_4);
        idb.mustGraphicalOwnedBy(GenericModel.LC_4, GenericModel.LC_2);
    }
}

