/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.msm;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.MSMDiagram;
import org.polarsys.capella.test.framework.context.SessionContext;

public class MSMComputedTransitionsTest
extends AbstractDiagramTestCase {
    public static final String MODE4 = "184b065a-e311-4260-9506-d66e34498b97";
    public static final String MODE6 = "9576a98a-35f5-469a-8ee1-7e44e0706ed8";
    public static final String MODE8 = "b11f60ec-6ba1-4740-9f1f-0cfe4ee249f4";
    public static final String MODE3 = "cc3f249e-2954-48dc-94e4-301f7cb6a0b6";
    public static final String transition24 = "6b866b60-ab02-4137-aaed-b7454d84814e";
    public static final String transition23 = "ade45cc9-6c64-4360-b085-1510a1abd97e";
    public static final String transition6Join = "968ec028-0e70-4afd-9d1e-32781766b86c";
    public static final String transitionJoin8 = "cc0405b0-caa2-495e-9474-0ce5d9accdfc";
    public static final String transition13 = "bb822510-4444-4785-b90b-001c68207d78";
    public static final String transition14 = "2b4a930e-0f72-4181-8bc1-df905c1a23f4";
    public static final String DIAGRAM_NAME = "[MSM] Default Region";
    Session session;
    SessionContext context;
    TransactionalEditingDomain ted;
    MSMDiagram diagramContext;
    DDiagram diagram;

    protected String getRequiredTestModel() {
        return "MSMComputedTransitions";
    }

    public void test() throws Exception {
        this.session = this.getSessionForTestModel(this.getRequiredTestModel());
        this.context = new SessionContext(this.session);
        this.ted = this.session.getTransactionalEditingDomain();
        this.diagramContext = MSMDiagram.openDiagram((SessionContext)this.context, (String)DIAGRAM_NAME, (BlockArchitectureExt.Type)BlockArchitectureExt.Type.SA);
        this.diagram = this.diagramContext.getDiagram();
        this.diagramContext.refreshDiagram();
        this.diagramContext.hasHiddenView(MODE4);
        this.diagramContext.hasHiddenView(MODE6);
        this.diagramContext.hasHiddenView(MODE8);
        this.hasComputedTransitionMapping(transition14);
        this.hasComputedTransitionMapping(transition23);
        this.hasComputedTransitionMapping(transition24);
        this.hasComputedTransitionMapping(transition6Join);
        this.hasComputedTransitionMapping(transitionJoin8);
        this.hasTransitionMapping(transition13);
    }

    private void hasComputedTransitionMapping(String id) {
        EObject semanticElement = this.context.getSemanticElement(id);
        List<DDiagramElement> viewsOnDiagram = this.getViewsOnDiagram(this.diagram, semanticElement);
        MSMComputedTransitionsTest.assertEquals((int)2, (int)viewsOnDiagram.size());
        Optional<DDiagramElement> computedTransitionMapping = viewsOnDiagram.stream().filter(v -> "MSM_ComputedTransition".equals(v.getMapping().getName())).findFirst();
        MSMComputedTransitionsTest.assertTrue((boolean)computedTransitionMapping.isPresent());
        MSMComputedTransitionsTest.assertTrue((boolean)computedTransitionMapping.get().isVisible());
        Optional<DDiagramElement> transitionMapping = viewsOnDiagram.stream().filter(v -> "MSM_Transition".equals(v.getMapping().getName())).findFirst();
        MSMComputedTransitionsTest.assertTrue((boolean)transitionMapping.isPresent());
        MSMComputedTransitionsTest.assertFalse((boolean)transitionMapping.get().isVisible());
    }

    private void hasTransitionMapping(String id) {
        EObject semanticElement = this.context.getSemanticElement(id);
        List<DDiagramElement> viewsOnDiagram = this.getViewsOnDiagram(this.diagram, semanticElement);
        MSMComputedTransitionsTest.assertEquals((int)1, (int)viewsOnDiagram.size());
        MSMComputedTransitionsTest.assertTrue((boolean)viewsOnDiagram.stream().filter(v -> "MSM_ComputedTransition".equals(v.getMapping().getName())).findFirst().isEmpty());
        MSMComputedTransitionsTest.assertTrue((boolean)viewsOnDiagram.stream().filter(v -> "MSM_Transition".equals(v.getMapping().getName())).findFirst().isPresent());
    }

    public List<DDiagramElement> getViewsOnDiagram(DDiagram diagram, EObject semanticObject) {
        ArrayList<DDiagramElement> result = new ArrayList<DDiagramElement>();
        LinkedList elements = new LinkedList(diagram.getDiagramElements());
        for (DDiagramElement element : elements) {
            if (element.getTarget() != semanticObject) continue;
            result.add(element);
        }
        return result;
    }

    protected void undoAllChanges() {
    }
}

