/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.sequence;

import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.ESDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.SequenceDiagram;
import org.polarsys.capella.test.diagram.tools.ju.sequence.SequenceTest;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.SkeletonHelper;
import org.polarsys.capella.test.framework.model.GenericModel;

public class CreateComponentExchange
extends SequenceTest {
    public void test() throws Exception {
        BlockArchitectureExt.Type[] types = new BlockArchitectureExt.Type[]{BlockArchitectureExt.Type.OA, BlockArchitectureExt.Type.LA, BlockArchitectureExt.Type.PA};
        this.testOnAllLevels(types, SequenceTest.SequenceType.ES);
    }

    @Override
    public void test(SequenceDiagram diagram) {
        this.setUpDiagram(diagram);
        this.testCreateComponentExchange((ESDiagram)diagram);
        this.testCreateComponentExchangeWithReturnBranch((ESDiagram)diagram);
    }

    @Override
    public void setUpDiagram(SequenceDiagram diagram) {
        super.setUpDiagram(diagram);
        BlockArchitectureExt.Type type = diagram.getDiagramBlockArchitecture();
        SkeletonHelper.createComponentExchange((String)this.getContextId(type), (String)GenericModel.COMPONENT_EXCHANGE_1, (SessionContext)this.context);
        SkeletonHelper.createComponentExchange((String)this.getContextId(type), (String)GenericModel.COMPONENT_EXCHANGE_2, (SessionContext)this.context);
        SkeletonHelper.createComponentExchange((String)this.getContextId(type), (String)GenericModel.COMPONENT_EXCHANGE_3, (SessionContext)this.context);
        SkeletonHelper.createComponentExchange((String)this.getContextId(type), (String)GenericModel.COMPONENT_EXCHANGE_4, (SessionContext)this.context);
        SkeletonHelper.createComponentExchange((String)this.getContextId(type), (String)GenericModel.COMPONENT_EXCHANGE_5, (SessionContext)this.context);
        SkeletonHelper.createComponentExchange((String)this.getContextId(type), (String)GenericModel.COMPONENT_EXCHANGE_6, (SessionContext)this.context);
    }

    protected void testCreateComponentExchange(ESDiagram diagram) {
        diagram.createComponentExchange(GenericModel.COMPONENT_EXCHANGE_1, this.actor1, this.actor2);
        diagram.createComponentExchange(GenericModel.COMPONENT_EXCHANGE_2, this.actor1, this.component1);
        diagram.createComponentExchange(GenericModel.COMPONENT_EXCHANGE_3, this.component1, this.component2);
    }

    protected void testCreateComponentExchangeWithReturnBranch(ESDiagram diagram) {
        diagram.createComponentExchangeWithReturnBranch(GenericModel.COMPONENT_EXCHANGE_4, this.actor1, this.actor2);
        diagram.createComponentExchangeWithReturnBranch(GenericModel.COMPONENT_EXCHANGE_5, this.actor1, this.component1);
        diagram.createComponentExchangeWithReturnBranch(GenericModel.COMPONENT_EXCHANGE_6, this.component1, this.component2);
    }
}

