/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.sequence;

import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.ISDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.OA_ESDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.SequenceDiagram;
import org.polarsys.capella.test.diagram.tools.ju.sequence.SequenceTest;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.SkeletonHelper;
import org.polarsys.capella.test.framework.model.GenericModel;

public class CreateSequenceMessage
extends SequenceTest {
    public void test() throws Exception {
        BlockArchitectureExt.Type[] types = new BlockArchitectureExt.Type[]{BlockArchitectureExt.Type.SA, BlockArchitectureExt.Type.LA, BlockArchitectureExt.Type.PA};
        this.testOnAllLevels(types, SequenceTest.SequenceType.IS);
    }

    @Override
    public void test(SequenceDiagram diagram) {
        if (diagram instanceof ISDiagram) {
            this.setUpDiagram(diagram);
            ISDiagram isDiagram = (ISDiagram)diagram;
            isDiagram.createSequenceMessage(GenericModel.EXCHANGE_ITEM_ALLOCATION_1, this.actor1, this.actor2);
            isDiagram.createSequenceMessageWithReturnBranch(GenericModel.EXCHANGE_ITEM_ALLOCATION_2, this.actor1, this.actor2);
        }
    }

    @Override
    public void setUpDiagram(SequenceDiagram diagram) {
        this.actor1 = diagram.createActor();
        this.actor2 = diagram.createActor();
        if (diagram instanceof ISDiagram) {
            SkeletonHelper.createInterface((String)this.getInterfacesId(diagram.getDiagramBlockArchitecture()), (String)GenericModel.INTERFACE_1, (SessionContext)this.context);
            SkeletonHelper.createExchangeItem((String)this.getInterfacesId(diagram.getDiagramBlockArchitecture()), (String)GenericModel.EXCHANGE_ITEM_1, (SessionContext)this.context);
            SkeletonHelper.createExchangeItemAllocation((String)GenericModel.EXCHANGE_ITEM_ALLOCATION_1, (String)GenericModel.INTERFACE_1, (String)GenericModel.EXCHANGE_ITEM_1, (SessionContext)this.context);
            SkeletonHelper.createExchangeItemAllocation((String)GenericModel.EXCHANGE_ITEM_ALLOCATION_2, (String)GenericModel.INTERFACE_1, (String)GenericModel.EXCHANGE_ITEM_1, (SessionContext)this.context);
        } else if (diagram instanceof OA_ESDiagram) {
            BlockArchitectureExt.Type type = diagram.getDiagramBlockArchitecture();
            String contextId = this.getContextId(type);
            String rootFunctionId = this.getRootFunctionId(type);
            SkeletonHelper.createCommunicationMean((String)contextId, (String)GenericModel.COMMUNICATION_MEAN_1, (SessionContext)this.context);
            SkeletonHelper.createCommunicationMean((String)contextId, (String)GenericModel.COMMUNICATION_MEAN_2, (SessionContext)this.context);
            SkeletonHelper.createInteraction((String)rootFunctionId, (String)GenericModel.INTERACTION_1, (SessionContext)this.context);
            SkeletonHelper.createInteraction((String)rootFunctionId, (String)GenericModel.INTERACTION_2, (SessionContext)this.context);
        }
    }
}

