/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.sequence;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.test.diagram.common.ju.context.SequenceDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.sequence.SequenceTest;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class InsertAllocatedFunctions
extends SequenceTest {
    public void test() throws Exception {
        BlockArchitectureExt.Type[] types = new BlockArchitectureExt.Type[]{BlockArchitectureExt.Type.OA, BlockArchitectureExt.Type.SA, BlockArchitectureExt.Type.LA, BlockArchitectureExt.Type.PA};
        BlockArchitectureExt.Type[] typesIS = new BlockArchitectureExt.Type[]{BlockArchitectureExt.Type.SA, BlockArchitectureExt.Type.LA, BlockArchitectureExt.Type.PA};
        this.testOnAllLevels(types, SequenceTest.SequenceType.ES);
        this.testOnAllLevels(typesIS, SequenceTest.SequenceType.IS);
    }

    @Override
    public void test(SequenceDiagram diagram) {
        this.setUpDiagram(diagram);
        diagram.insertAllocatedFunction(this.actor1, GenericModel.FUNCTION_1);
        diagram.insertAllocatedFunction(this.actor1, GenericModel.FUNCTION_2);
        diagram.insertAllocatedFunction(this.actor2, GenericModel.FUNCTION_3);
    }

    @Override
    public void setUpDiagram(SequenceDiagram diagram) {
        this.actor1 = diagram.createActor();
        this.actor2 = diagram.createActor();
        XDFBDiagram xdfb = XDFBDiagram.createDiagram((SessionContext)this.context, (String)this.getRootFunctionId(diagram.getDiagramBlockArchitecture()));
        xdfb.createFunction(GenericModel.FUNCTION_1);
        xdfb.createFunction(GenericModel.FUNCTION_1_1, GenericModel.FUNCTION_1);
        xdfb.createFunction(GenericModel.FUNCTION_2);
        xdfb.createFunction(GenericModel.FUNCTION_3);
        this.addAllocatedFunctions(this.actor1, GenericModel.FUNCTION_1);
        this.addAllocatedFunctions(this.actor1, GenericModel.FUNCTION_2);
        this.addAllocatedFunctions(this.actor2, GenericModel.FUNCTION_3);
    }

    private void addAllocatedFunctions(String elementId, String functionId) {
        Part part;
        AbstractType type;
        InstanceRole instRole;
        AbstractInstance inst;
        EObject obj = this.context.getSemanticElement(elementId);
        if (obj instanceof InstanceRole && (inst = (instRole = (InstanceRole)obj).getRepresentedInstance()) instanceof Part && (type = (part = (Part)inst).getAbstractType()) instanceof AbstractFunctionalBlock) {
            final AbstractFunctionalBlock block = (AbstractFunctionalBlock)type;
            EObject objF = this.context.getSemanticElement(functionId);
            if (objF instanceof AbstractFunction) {
                final AbstractFunction f = (AbstractFunction)objF;
                AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

                    public void run() {
                        ComponentFunctionalAllocation cfa = FaFactory.eINSTANCE.createComponentFunctionalAllocation();
                        block.getOwnedFunctionalAllocation().add((Object)cfa);
                        cfa.setTargetElement((TraceableElement)f);
                        cfa.setSourceElement((TraceableElement)block);
                        CapellaElementExt.creationService((EObject)cfa);
                    }
                };
                this.context.getExecutionManager().execute((ICommand)cmd);
            }
        }
    }
}

