/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.sequence;

import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.CapabilityDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.ESDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.FSDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.ISDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.OA_ESDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.PA_ESDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.SA_ESDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.SequenceDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.SequenceDiagramProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.SkeletonHelper;
import org.polarsys.capella.test.framework.model.GenericModel;

public abstract class SequenceTest
extends SequenceDiagramProject {
    protected SessionContext context = null;
    protected String scenario = GenericModel.SCENARIO_1;
    protected String capability = GenericModel.CAPABILITY_1;
    protected String actor1 = "";
    protected String actor2 = "";
    protected String component1 = "";
    protected String component2 = "";
    protected String function1 = "";
    protected String function2 = "";

    public void testOnAllLevels(BlockArchitectureExt.Type[] types, SequenceType seqType) {
        BlockArchitectureExt.Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            BlockArchitectureExt.Type type = typeArray[n2];
            this.doTest(type, seqType, this.getCapabilitiesId(type), this.capability, this.scenario);
            ++n2;
        }
    }

    public abstract void test(SequenceDiagram var1);

    protected void setUpDiagram(SequenceDiagram diagram) {
        if (diagram instanceof FSDiagram) {
            this.function1 = ((FSDiagram)diagram).createFunction();
            this.function2 = ((FSDiagram)diagram).createFunction();
        } else {
            this.actor1 = diagram.createActor();
            this.actor2 = diagram.createActor();
            BlockArchitectureExt.Type type = diagram.getDiagramBlockArchitecture();
            if (diagram instanceof ESDiagram) {
                switch (type) {
                    case SA: {
                        break;
                    }
                    case PA: {
                        this.component1 = ((PA_ESDiagram)diagram).createComponent(PhysicalComponentNature.BEHAVIOR);
                        this.component2 = ((PA_ESDiagram)diagram).createComponent(PhysicalComponentNature.NODE);
                        break;
                    }
                    default: {
                        this.component1 = ((ESDiagram)diagram).createComponent();
                        this.component2 = ((ESDiagram)diagram).createComponent();
                    }
                }
            }
        }
    }

    protected SequenceDiagram createDiagram(SessionContext context, BlockArchitectureExt.Type type, SequenceType seqType, String containerId, String capabilityId, String scenarioId) {
        ESDiagram diagram = null;
        switch (seqType) {
            case ES: {
                diagram = ESDiagram.createDiagram((SessionContext)context, (String)scenarioId);
                break;
            }
            case FS: {
                diagram = FSDiagram.createDiagram((SessionContext)context, (String)scenarioId);
                break;
            }
            case IS: {
                diagram = ISDiagram.createDiagram((SessionContext)context, (String)scenarioId);
                break;
            }
        }
        return diagram;
    }

    protected void doTest(BlockArchitectureExt.Type type, SequenceType seqType, String containerId, String capabilityId, String scenarioId) {
        Session session = this.getSession(this.getRequiredTestModel());
        this.context = new SessionContext(session);
        SequenceDiagram diagram = this.openDiagram(type, seqType);
        if (diagram != null) {
            this.test(diagram);
            diagram.close();
        }
    }

    protected SequenceDiagram openDiagram(BlockArchitectureExt.Type type, SequenceType seqType) {
        OA_ESDiagram diagram = null;
        block0 : switch (type) {
            case OA: {
                switch (seqType) {
                    case ES: {
                        diagram = OA_ESDiagram.openDiagram((SessionContext)this.context, (String)"OA_ES", (BlockArchitectureExt.Type)type);
                        break block0;
                    }
                }
                break;
            }
            case SA: {
                switch (seqType) {
                    case ES: {
                        diagram = SA_ESDiagram.openDiagram((SessionContext)this.context, (String)"SA_ES", (BlockArchitectureExt.Type)type);
                        break block0;
                    }
                    case IS: {
                        diagram = ISDiagram.openDiagram((SessionContext)this.context, (String)"SA_IS", (BlockArchitectureExt.Type)type);
                        break block0;
                    }
                    case FS: {
                        diagram = FSDiagram.openDiagram((SessionContext)this.context, (String)"SA_FS", (BlockArchitectureExt.Type)type);
                        break block0;
                    }
                }
                break;
            }
            case LA: {
                switch (seqType) {
                    case ES: {
                        diagram = ESDiagram.openDiagram((SessionContext)this.context, (String)"LA_ES", (BlockArchitectureExt.Type)type);
                        break block0;
                    }
                    case IS: {
                        diagram = ISDiagram.openDiagram((SessionContext)this.context, (String)"LA_IS", (BlockArchitectureExt.Type)type);
                        break block0;
                    }
                    case FS: {
                        diagram = FSDiagram.openDiagram((SessionContext)this.context, (String)"LA_FS", (BlockArchitectureExt.Type)type);
                        break block0;
                    }
                }
                break;
            }
            case PA: {
                switch (seqType) {
                    case ES: {
                        diagram = PA_ESDiagram.openDiagram((SessionContext)this.context, (String)"PA_ES", (BlockArchitectureExt.Type)type);
                        break block0;
                    }
                    case IS: {
                        diagram = ISDiagram.openDiagram((SessionContext)this.context, (String)"PA_IS", (BlockArchitectureExt.Type)type);
                        break block0;
                    }
                    case FS: {
                        diagram = FSDiagram.openDiagram((SessionContext)this.context, (String)"PA_FS", (BlockArchitectureExt.Type)type);
                        break block0;
                    }
                }
                break;
            }
        }
        return diagram;
    }

    protected String createCapability(SessionContext context, BlockArchitectureExt.Type type, String containerId, String capabilityId) {
        CapabilityDiagram capabilityDiagram = CapabilityDiagram.createDiagram((SessionContext)context, (String)containerId, (String)this.getCapabilityDiagramName(type));
        capabilityDiagram.createCapability(capabilityId);
        return capabilityId;
    }

    protected String createScenario(SessionContext context, String scenarioId, String capabilityId) {
        SkeletonHelper.createScenario((String)capabilityId, (String)scenarioId, (SessionContext)context);
        return scenarioId;
    }

    protected String getCapabilityDiagramName(BlockArchitectureExt.Type type) {
        String capabilityDiagramName = "";
        switch (type) {
            case OA: {
                capabilityDiagramName = "Operational Capabilities Blank";
                break;
            }
            case SA: {
                capabilityDiagramName = "Missions Capabilities Blank";
                break;
            }
            default: {
                capabilityDiagramName = "Capability Realization Blank";
            }
        }
        return capabilityDiagramName;
    }

    public static enum SequenceType {
        ES,
        FS,
        IS;

    }
}

