/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.tb;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.polarsys.capella.common.ui.MdeCommonUiActivator;
import org.polarsys.capella.core.diagram.helpers.TitleBlockHelper;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.CDBDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CDBTitleBlockTestCase
extends AbstractDiagramTestCase {
    private ScopedPreferenceStore preferenceStore;
    protected Session session;
    protected SessionContext context;
    protected CommonDiagram diagram;
    protected CommonDiagram newDiagram;
    protected ArrayList<String> elementsId = new ArrayList();
    protected String diagramName;
    protected String dataPKG;
    private static final String CLASS_ID = "330d0716-9466-4a2c-8a06-9b95b1d2d1ef";
    private static final String DATA_ID = "28654216-6820-4e87-8d31-d146b194ba19";
    private static final String BOOLEAN_ID = "06c37c44-d801-4ff0-8f0f-2708df03d97b";
    private static final String DIAGRAM_NAME = "[CDB] Data Logical";
    private static final String DATA_PKG = "402bc79a-3d0f-4361-8deb-b0e2237bfed5";

    public CDBTitleBlockTestCase() {
        this.elementsId.add(CLASS_ID);
        this.elementsId.add(DATA_ID);
        this.elementsId.add(BOOLEAN_ID);
        this.diagramName = DIAGRAM_NAME;
        this.dataPKG = DATA_PKG;
    }

    protected String getRequiredTestModel() {
        return "TitleBlocksModel";
    }

    public void test() throws Exception {
        this.initTest();
        this.titleBlocks();
        DiagramHelper.setSynchronized((DDiagram)this.diagram.getDiagram(), (boolean)false);
        this.titleBlocks();
        this.deleteAll();
    }

    public void titleBlocks() {
        this.diagramTitleBlock();
        for (String elementId : this.elementsId) {
            this.elementTitleBlock(elementId);
        }
    }

    public void diagramTitleBlock() {
        DDiagramElement viewTB = this.diagram.createDiagramTitleBlock();
        DAnnotation diagramTB = (DAnnotation)viewTB.getTarget();
        this.diagram.removeDiagramTitleBlock(diagramTB.getUid());
        this.diagram.checkCreateDiagramTitleBlock();
        this.diagram.insertDiagramTitleBlock(diagramTB.getUid());
        viewTB = DiagramServices.getDiagramServices().getDiagramElement(this.diagram.getDiagram(), (EObject)diagramTB);
        this.diagram.deleteSemantic(viewTB);
        CDBTitleBlockTestCase.assertTrue((boolean)TitleBlockHelper.getAllAnnotationsForTitleBlock((DAnnotation)diagramTB).isEmpty());
    }

    public void elementTitleBlock(String elementId) {
        DDiagramElement viewTB = this.diagram.createDiagramTitleBlock();
        DAnnotation elementTB = (DAnnotation)viewTB.getTarget();
        this.diagram.removeElementTitleBlock(elementTB.getUid());
        this.diagram.checkCreateElementTitleBlock(elementId);
        this.diagram.insertElementTitleBlock(elementTB.getUid());
        this.diagram.insertLineInTitleBlock(elementTB, 0);
        this.diagram.insertColumnInTitleBlock(elementTB, 0);
        this.diagram.removeLineFromTitleBlock(elementTB, 0);
        this.diagram.removeColumnFromTitleBlock(elementTB, 0);
        viewTB = DiagramServices.getDiagramServices().getDiagramElement(this.diagram.getDiagram(), (EObject)elementTB);
        this.diagram.deleteSemantic(viewTB);
        CDBTitleBlockTestCase.assertTrue((boolean)TitleBlockHelper.getAllAnnotationsForTitleBlock((DAnnotation)elementTB).isEmpty());
        CDBTitleBlockTestCase.assertTrue((this.diagram.getSessionContext().getSemanticElement(elementId).eContainer() != null ? 1 : 0) != 0);
    }

    public void deleteAll() {
        this.newDiagram.createDiagramTitleBlock();
        this.newDiagram.createConstraint(this.newDiagram.getDiagramId());
        this.newDiagram.deleteAllSemantic();
        CDBTitleBlockTestCase.assertTrue((this.newDiagram.getDiagram().getOwnedDiagramElements().size() == 0 ? 1 : 0) != 0);
    }

    protected void initTest() {
        this.session = this.getSession(this.getRequiredTestModel());
        this.context = new SessionContext(this.session);
        this.diagram = CDBDiagram.openDiagram((SessionContext)this.context, (String)this.diagramName);
        this.preferenceStore = (ScopedPreferenceStore)MdeCommonUiActivator.getDefault().getPreferenceStore();
        this.preferenceStore.setValue("defaultTitleBlock", true);
        this.newDiagram = CDBDiagram.createDiagram((SessionContext)this.context, (String)this.dataPKG);
        this.session.save((IProgressMonitor)new NullProgressMonitor());
    }
}

